/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.server.rest;

import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.collect.server.service.ExternalParametersService;
import fr.gouv.vitamui.collect.server.service.ProjectObjectGroupService;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.vitam.api.dto.ResultsDto;
import io.swagger.annotations.Api;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@Api(tags={"Collect"})
@RequestMapping(value={"/collect-api/v1/projects/object-groups"})
@RestController
@ResponseBody
public class ProjectObjectGroupController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectObjectGroupController.class);
    private static final String MANDATORY_IDENTIFIER = "The Identifier is a mandatory parameter: ";
    private final ProjectObjectGroupService projectObjectGroupService;
    private final ExternalParametersService externalParametersService;

    @GetMapping(value={"/downloadobjectfromunit/{id}"}, produces={"application/octet-stream"})
    @Secured(value={"ROLE_COLLECT_GET_ARCHIVE_BINARY"})
    public Mono<ResponseEntity<Resource>> downloadObjectFromUnit(@PathVariable(value="id") String id, @RequestParam(value="objectId") String objectId, @RequestParam(value="usage", required=false) String usage, @RequestParam(value="version", required=false) Integer version) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{objectId});
        SanityChecker.checkSecureParameter((String[])new String[]{objectId});
        LOGGER.debug("Download the Archive Unit Object with id {} ", (Object)objectId);
        return this.projectObjectGroupService.downloadObjectFromUnit(id, objectId, usage, version, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @GetMapping(value={"/{id}"})
    @Secured(value={"ROLE_COLLECT_GET_ARCHIVE_BINARY"})
    public ResultsDto findObjectById(@PathVariable(value="id") String id) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Find an ObjectGroup by id {} ", (Object)id);
        return this.projectObjectGroupService.findObjectById(id, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @Generated
    public ProjectObjectGroupController(ProjectObjectGroupService projectObjectGroupService, ExternalParametersService externalParametersService) {
        this.projectObjectGroupService = projectObjectGroupService;
        this.externalParametersService = externalParametersService;
    }
}

