/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.server.rest;

import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.collect.common.dto.CollectProjectDto;
import fr.gouv.vitamui.collect.common.dto.CollectTransactionDto;
import fr.gouv.vitamui.collect.server.service.ExternalParametersService;
import fr.gouv.vitamui.collect.server.service.ProjectService;
import fr.gouv.vitamui.common.security.SafeFileChecker;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Collect"})
@RequestMapping(value={"/collect-api/v1/projects"})
@RestController
@ResponseBody
public class ProjectController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectController.class);
    private static final String MANDATORY_IDENTIFIER = "The Identifier is a mandatory parameter: ";
    private final ProjectService projectService;
    private final ExternalParametersService externalParametersService;

    @Secured(value={"ROLE_GET_PROJECTS"})
    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<CollectProjectDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) throws PreconditionFailedException {
        direction.ifPresent(SanityChecker::sanitizeCriteria);
        orderBy.ifPresent(xva$0 -> SanityChecker.checkSecureParameter((String[])new String[]{xva$0}));
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, criteria, orderBy, direction});
        return this.projectService.getAllProjectsPaginated(page, size, criteria, orderBy, direction, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @ApiOperation(value="Get transactions by project paginated")
    @GetMapping(params={"page", "size"}, value={"/{id}/transactions"})
    @Secured(value={"ROLE_GET_TRANSACTIONS"})
    public PaginatedValuesDto<CollectTransactionDto> getTransactionsByProjectPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction, @PathVariable(value="id") String projectId) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{projectId});
        SanityChecker.checkSecureParameter((String[])new String[]{projectId});
        SanityChecker.sanitizeCriteria(direction);
        SanityChecker.sanitizeCriteria(criteria);
        orderBy.ifPresent(xva$0 -> SanityChecker.checkSecureParameter((String[])new String[]{xva$0}));
        LOGGER.debug("getTransactionsByProjectPaginated page={}, size={}, criteria={}, orderBy={}, direction={}", new Object[]{page, size, criteria, orderBy, direction});
        return this.projectService.getTransactionsByProjectPaginated(projectId, page, size, orderBy, direction, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @Secured(value={"ROLE_CREATE_PROJECTS"})
    @PostMapping
    public CollectProjectDto createProject(@RequestBody CollectProjectDto collectProjectDto) throws PreconditionFailedException {
        ParameterChecker.checkParameter((String)"the project is mandatory : ", (Object[])new Object[]{collectProjectDto});
        SanityChecker.sanitizeCriteria((Object)((Object)collectProjectDto));
        LOGGER.debug("Project to create : {}", (Object)collectProjectDto);
        return this.projectService.createProject(collectProjectDto, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @Secured(value={"ROLE_CREATE_TRANSACTIONS"})
    @PostMapping(value={"/{id}/transactions"})
    public CollectTransactionDto createTransactionForProject(@PathVariable(value="id") String id, @RequestBody CollectTransactionDto collectTransactionDto) throws PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        ParameterChecker.checkParameter((String)"The transaction is a mandatory parameter: ", (Object[])new Object[]{collectTransactionDto});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria((Object)((Object)collectTransactionDto));
        LOGGER.debug("Transaction to create : {}", (Object)collectTransactionDto);
        return this.projectService.createTransactionForProject(collectTransactionDto, id, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @Secured(value={"ROLE_CREATE_PROJECTS"})
    @ApiOperation(value="Upload and stream collect zip file", consumes="application/octet-stream")
    @PostMapping(value={"/upload"}, consumes={"application/octet-stream"})
    public void streamingUpload(InputStream inputStream, @RequestHeader(value="X-Transaction-Id") String transactionId, @RequestHeader(value="X-Attachment-Id", required=false) String attachmentId, @RequestHeader(value="X-Original-Filename") String originalFileName) throws PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The transaction ID is a mandatory parameter: ", (String[])new String[]{transactionId});
        SanityChecker.checkSecureParameter((String[])new String[]{transactionId, attachmentId});
        SanityChecker.isValidFileName((String)originalFileName);
        SafeFileChecker.checkSafeFilePath((String)originalFileName);
        LOGGER.debug("[External] upload collect zip file : {}", (Object)originalFileName);
        this.projectService.streamingUpload(inputStream, transactionId, attachmentId, originalFileName, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @Secured(value={"ROLE_UPDATE_PROJECTS"})
    @PutMapping(value={"/{id}"})
    public CollectProjectDto updateProject(@PathVariable(value="id") String id, @RequestBody CollectProjectDto collectProjectDto) throws PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria((Object)((Object)collectProjectDto));
        LOGGER.debug("[External] Project to update : {}", (Object)collectProjectDto);
        return this.projectService.update(id, collectProjectDto, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @Secured(value={"ROLE_GET_PROJECTS"})
    @GetMapping(value={"/{id}"})
    public CollectProjectDto findProjectById(@PathVariable(value="id") String id) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("The project id {} ", (Object)id);
        return this.projectService.getProjectById(id, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @Secured(value={"ROLE_GET_PROJECTS"})
    @DeleteMapping(value={"/{id}"})
    public void deleteProjectById(@PathVariable(value="id") String id) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("The project id {} ", (Object)id);
        this.projectService.deleteProjectById(id, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @Secured(value={"ROLE_GET_TRANSACTIONS"})
    @GetMapping(value={"/{id}/last-transaction"})
    public CollectTransactionDto findLastTransactionByProjectId(@PathVariable(value="id") String id) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Find the transaction by project with ID {}", (Object)id);
        return this.projectService.getLastTransactionForProjectId(id, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @Generated
    public ProjectController(ProjectService projectService, ExternalParametersService externalParametersService) {
        this.projectService = projectService;
        this.externalParametersService = externalParametersService;
    }
}

