/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.server.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitamui.collect.server.config.ApiCollectApplicationProperties;
import fr.gouv.vitamui.collect.server.dao.SearchCriteriaHistoryRepository;
import fr.gouv.vitamui.collect.server.security.WebSecurityConfig;
import fr.gouv.vitamui.collect.server.service.ExternalParametersService;
import fr.gouv.vitamui.collect.server.service.ProjectObjectGroupService;
import fr.gouv.vitamui.collect.server.service.ProjectService;
import fr.gouv.vitamui.collect.server.service.SearchCriteriaHistoryService;
import fr.gouv.vitamui.collect.server.service.TransactionArchiveUnitService;
import fr.gouv.vitamui.collect.server.service.TransactionService;
import fr.gouv.vitamui.collect.server.service.converters.SearchCriteriaHistoryConverter;
import fr.gouv.vitamui.commons.api.application.AbstractContextConfiguration;
import fr.gouv.vitamui.commons.mongo.dao.CustomSequenceRepository;
import fr.gouv.vitamui.commons.mongo.service.SequenceGeneratorService;
import fr.gouv.vitamui.commons.rest.RestExceptionHandler;
import fr.gouv.vitamui.commons.rest.configuration.SwaggerConfiguration;
import fr.gouv.vitamui.commons.vitam.api.administration.AgencyCommonService;
import fr.gouv.vitamui.commons.vitam.api.administration.RuleCommonService;
import fr.gouv.vitamui.commons.vitam.api.collect.CollectService;
import fr.gouv.vitamui.commons.vitam.api.config.VitamAccessConfig;
import fr.gouv.vitamui.commons.vitam.api.config.VitamAdministrationConfig;
import fr.gouv.vitamui.commons.vitam.api.config.VitamCollectConfig;
import fr.gouv.vitamui.iam.client.ExternalParametersRestClient;
import fr.gouv.vitamui.iam.client.IamRestClientFactory;
import fr.gouv.vitamui.iam.client.UserRestClient;
import fr.gouv.vitamui.iam.security.provider.ApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.provider.ExternalApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.provider.InternalApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.service.IamClientUserAuthenticationService;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.iam.security.service.UserAuthenticationService;
import fr.gouv.vitamui.security.client.ContextRestClient;
import fr.gouv.vitamui.security.client.SecurityRestClientFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={RestExceptionHandler.class, SwaggerConfiguration.class, WebSecurityConfig.class, VitamAccessConfig.class, VitamCollectConfig.class, VitamAdministrationConfig.class})
public class ApiCollectServerConfig
extends AbstractContextConfiguration {
    @Bean
    public SecurityRestClientFactory securityRestClientFactory(ApiCollectApplicationProperties apiCollectApplicationProperties, RestTemplateBuilder restTemplateBuilder) {
        return new SecurityRestClientFactory(apiCollectApplicationProperties.getSecurityClient(), restTemplateBuilder);
    }

    @Bean
    public ContextRestClient contextCrudRestClient(SecurityRestClientFactory securityRestClientFactory) {
        return securityRestClientFactory.getContextRestClient();
    }

    @Bean
    public UserAuthenticationService authentificationService(UserRestClient userRestClient) {
        return new IamClientUserAuthenticationService(userRestClient);
    }

    @Bean
    public InternalApiAuthenticationProvider internalApiAuthenticationProvider(UserAuthenticationService userAuthenticationService) {
        return new InternalApiAuthenticationProvider(userAuthenticationService);
    }

    @Bean
    public ExternalApiAuthenticationProvider externalApiAuthenticationProvider(SecurityRestClientFactory securityRestClientFactory, UserAuthenticationService userAuthenticationService) {
        return new ExternalApiAuthenticationProvider(securityRestClientFactory.getContextRestClient(), userAuthenticationService);
    }

    @Bean
    public ApiAuthenticationProvider apiAuthenticationProvider(InternalApiAuthenticationProvider internalApiAuthenticationProvider, ExternalApiAuthenticationProvider externalApiAuthenticationProvider) {
        return new ApiAuthenticationProvider(internalApiAuthenticationProvider, externalApiAuthenticationProvider);
    }

    @Bean
    public SecurityService externalSecurityService() {
        return new SecurityService();
    }

    @Bean
    public IamRestClientFactory iamExternalRestClientFactory(ApiCollectApplicationProperties apiCollectApplicationProperties, RestTemplateBuilder restTemplateBuilder) {
        return new IamRestClientFactory(apiCollectApplicationProperties.getIamClient(), restTemplateBuilder);
    }

    @Bean
    public UserRestClient userInternalRestClient(IamRestClientFactory iamRestClientFactory) {
        return iamRestClientFactory.getUserExternalRestClient();
    }

    @Bean
    public ProjectService collectInternalService(CollectService collectService, ObjectMapper objectMapper, ExternalParametersService externalParametersService) {
        return new ProjectService(collectService, objectMapper, externalParametersService);
    }

    @Bean
    public TransactionService transactionInternalService(CollectService collectService) {
        return new TransactionService(collectService);
    }

    @Bean
    public TransactionArchiveUnitService projectArchiveUnitInternalService(CollectService collectService, AgencyCommonService agencyCommonService, RuleCommonService ruleCommonService, ObjectMapper objectMapper) {
        return new TransactionArchiveUnitService(collectService, agencyCommonService, ruleCommonService, objectMapper);
    }

    @Bean
    public ProjectObjectGroupService projectObjectGroupInternalService(CollectService collectService, ObjectMapper objectMapper) {
        return new ProjectObjectGroupService(collectService, objectMapper);
    }

    @Bean
    public SequenceGeneratorService sequenceGeneratorService(CustomSequenceRepository sequenceRepository) {
        return new SequenceGeneratorService(sequenceRepository);
    }

    @Bean
    public SearchCriteriaHistoryService searchCriteriaHistoryInternalService(SequenceGeneratorService sequenceGeneratorService, SearchCriteriaHistoryRepository searchCriteriaHistoryRepository, SearchCriteriaHistoryConverter searchCriteriaHistoryConverter, SecurityService securityService) {
        return new SearchCriteriaHistoryService(sequenceGeneratorService, searchCriteriaHistoryRepository, searchCriteriaHistoryConverter, securityService);
    }

    @Bean
    public ExternalParametersRestClient externalParametersInternalRestClient(IamRestClientFactory iamRestClientFactory) {
        return iamRestClientFactory.getExternalParametersExternalRestClient();
    }
}

