/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.storage.filesystem;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.MetadatasObject;
import fr.gouv.vitam.common.storage.ContainerInformation;
import fr.gouv.vitam.common.storage.StorageConfiguration;
import fr.gouv.vitam.common.storage.cas.container.api.ContentAddressableStorageJcloudsAbstract;
import fr.gouv.vitam.common.storage.cas.container.api.MetadatasStorageObject;
import fr.gouv.vitam.common.storage.constants.ErrorMessage;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Properties;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.providers.ProviderMetadata;

public class FileSystem
extends ContentAddressableStorageJcloudsAbstract {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(FileSystem.class);

    public FileSystem(StorageConfiguration configuration) {
        super(configuration);
    }

    @Override
    public void closeContext() {
        this.context.close();
    }

    @Override
    public ContainerInformation getContainerInformation(String containerName) throws ContentAddressableStorageNotFoundException {
        ParametersChecker.checkParameter((String)"Container name may not be null", (String[])new String[]{containerName});
        File baseDirFile = this.getBaseDir(containerName);
        long usableSpace = baseDirFile.getUsableSpace();
        ContainerInformation containerInformation = new ContainerInformation();
        containerInformation.setUsableSpace(usableSpace);
        return containerInformation;
    }

    private File getBaseDir(String containerName) throws ContentAddressableStorageNotFoundException {
        ProviderMetadata providerMetadata = this.context.unwrap().getProviderMetadata();
        Properties properties = providerMetadata.getDefaultProperties();
        String baseDir = properties.getProperty("jclouds.filesystem.basedir");
        File baseDirFile = new File(baseDir, containerName);
        if (!baseDirFile.exists()) {
            throw new ContentAddressableStorageNotFoundException("Storage container " + containerName + " not found");
        }
        return baseDirFile;
    }

    @Override
    public BlobStoreContext getContext(StorageConfiguration configuration) {
        Properties props = new Properties();
        props.setProperty("jclouds.filesystem.basedir", configuration.getStoragePath());
        LOGGER.debug("Get File System Context");
        return (BlobStoreContext)ContextBuilder.newBuilder((String)"filesystem").overrides(props).buildView(BlobStoreContext.class);
    }

    private File getFileFromJClouds(String containerName, String objectId) throws ContentAddressableStorageNotFoundException {
        File file = new File(this.getBaseDir(containerName), objectId);
        if (!file.exists()) {
            throw new ContentAddressableStorageNotFoundException("Storage not found: " + containerName + "/" + objectId);
        }
        return file;
    }

    private BasicFileAttributes getFileAttributes(File file) throws IOException {
        Path path = Paths.get(file.getPath(), new String[0]);
        BasicFileAttributeView basicView = Files.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]);
        BasicFileAttributes basicAttribs = basicView.readAttributes();
        return basicAttribs;
    }

    @Override
    public MetadatasObject getObjectMetadata(String containerName, String objectId, boolean noCache) throws ContentAddressableStorageException {
        MetadatasStorageObject result = new MetadatasStorageObject();
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_OBJECT_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectId});
        try {
            File file = this.getFileFromJClouds(containerName, objectId);
            BasicFileAttributes basicAttribs = this.getFileAttributes(file);
            long size = Files.size(Paths.get(file.getPath(), new String[0]));
            result.setObjectName(objectId);
            result.setDigest(this.getObjectDigest(containerName, objectId, VitamConfiguration.getDefaultDigestType(), noCache));
            result.setFileSize(size);
            result.setType(containerName.split("_")[1]);
            result.setLastAccessDate(basicAttribs.lastAccessTime().toString());
            result.setLastModifiedDate(basicAttribs.lastModifiedTime().toString());
        }
        catch (FileNotFoundException | NoSuchFileException fe) {
            throw new ContentAddressableStorageNotFoundException("The file for object " + objectId + " for container " + containerName + " is not found", (Throwable)fe);
        }
        catch (IOException io) {
            throw new ContentAddressableStorageException("The file for object " + objectId + "for container " + containerName + " is not accessible", (Throwable)io);
        }
        finally {
            this.closeContext();
        }
        return result;
    }

    public void close() {
        this.closeContext();
    }
}

