/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server.job.auditobject;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InternalServerException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.exception.WorkflowNotFoundException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.logbook.LogbookEvent;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClient;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import fr.gouv.vitam.scheduler.server.job.auditobject.AuditProcessState;
import fr.gouv.vitam.scheduler.server.job.auditobject.LastOperationExecution;
import java.util.Objects;
import java.util.Optional;

public class AuditOperationFinder {
    public static final String LAST_UPDATE_DATE_FIELD_NAME = "Last_Update_Date";
    public static final String JOB_EXECUTION_EVENT_TYPE = "LIST_OBJECTGROUP_ID";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AuditOperationFinder.class);
    private final boolean ALLOW_EXECUTION = Boolean.TRUE;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;
    private final ProcessingManagementClientFactory processingManagementClientFactory;

    public AuditOperationFinder(LogbookOperationsClientFactory logbookOperationsClientFactory, ProcessingManagementClientFactory processingManagementClientFactory) {
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
        this.processingManagementClientFactory = processingManagementClientFactory;
    }

    public LastOperationExecution findLastAuditData(String auditAction) {
        LastOperationExecution lastOperationExecution;
        block8: {
            LogbookOperationsClient logbookOperationsClient = this.logbookOperationsClientFactory.getClient();
            try {
                ObjectNode query = this.buildLogbookSelectQuery(auditAction);
                JsonNode result = logbookOperationsClient.selectOperation((JsonNode)query);
                lastOperationExecution = this.toLogbookOperation(result).map(firstResult -> {
                    boolean hasCompleted = this.hasOperationCompleted((LogbookOperation)firstResult);
                    String lastRunDate = this.getLastUpdateDateByIdOperation((LogbookOperation)firstResult);
                    Integer tenantId = firstResult.getTenant();
                    String operationId = firstResult.getId();
                    return new LastOperationExecution(operationId, tenantId, lastRunDate, hasCompleted);
                }).orElse(LastOperationExecution.NOT_FOUND_EXECUTION);
                if (logbookOperationsClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (logbookOperationsClient != null) {
                        try {
                            logbookOperationsClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidCreateOperationException | InvalidParseOperationException | LogbookClientException e) {
                    throw new VitamRuntimeException(e);
                }
            }
            logbookOperationsClient.close();
        }
        return lastOperationExecution;
    }

    private Optional<LogbookOperation> toLogbookOperation(JsonNode result) {
        try {
            RequestResponseOK response = RequestResponseOK.getFromJsonNode((JsonNode)result, LogbookOperation.class);
            return Optional.ofNullable((LogbookOperation)response.getFirstResult());
        }
        catch (InvalidParseOperationException e) {
            throw new IllegalStateException("An error has occurred while parsing the operation", e);
        }
    }

    private boolean hasOperationCompleted(LogbookOperation logbookOperation) {
        boolean bl;
        block9: {
            ProcessingManagementClient processingManagementClient = this.processingManagementClientFactory.getClient();
            try {
                ItemStatus operationProcessStatus = processingManagementClient.getOperationProcessStatus(logbookOperation.getId());
                ProcessState state = operationProcessStatus.getGlobalState();
                AuditProcessState auditProcessState = AuditProcessState.wrap(state);
                bl = auditProcessState.hasLastWorkflowCompleted();
                if (processingManagementClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (processingManagementClient != null) {
                        try {
                            processingManagementClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (WorkflowNotFoundException e) {
                    LOGGER.info("Workflow not found, it must have completed long ago", (Throwable)e);
                    return this.ALLOW_EXECUTION;
                }
                catch (BadRequestException | InternalServerException | VitamClientException e) {
                    throw new VitamRuntimeException("An error has occurred while trying to fetch the operation status due to :", e);
                }
            }
            processingManagementClient.close();
        }
        return bl;
    }

    private String getLastUpdateDateByIdOperation(LogbookOperation logbookOperation) {
        return logbookOperation.getEvents().stream().filter(e -> Objects.equals(e.getEvType(), JOB_EXECUTION_EVENT_TYPE)).map(LogbookEvent::getEvDetData).map(this::getLastUpdateDateFromEvDetData).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(null);
    }

    private Optional<String> getLastUpdateDateFromEvDetData(String evDetData) {
        return Optional.ofNullable(evDetData).map(data -> {
            try {
                return JsonHandler.getFromString((String)data);
            }
            catch (InvalidParseOperationException e) {
                throw new IllegalStateException("evDetData format issue", e);
            }
        }).map(e -> e.get(LAST_UPDATE_DATE_FIELD_NAME)).map(JsonNode::asText);
    }

    private ObjectNode buildLogbookSelectQuery(String auditAction) throws InvalidCreateOperationException, InvalidParseOperationException {
        Select select = new Select();
        select.setQuery((Query)QueryHelper.and().add(new Query[]{QueryHelper.eq((String)"events.evType", (String)("AUDIT_CHECK_OBJECT." + auditAction)), QueryHelper.isNull((String)"rightsStatementIdentifier")}));
        select.addOrderByDescFilter(new String[]{"evDateTime"});
        select.setLimitFilter(0L, 1L);
        return select.getFinalSelect();
    }
}

