/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server.job;

import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class StorageLogTraceabilityJob
implements Job {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(StorageLogTraceabilityJob.class);
    private final StorageClientFactory storageClientFactory;

    public StorageLogTraceabilityJob() {
        this(StorageClientFactory.getInstance());
    }

    public StorageLogTraceabilityJob(StorageClientFactory storageClientFactory) {
        this.storageClientFactory = storageClientFactory;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        VitamThreadUtils.getVitamSession().setTenantId(VitamConfiguration.getAdminTenant());
        VitamThreadUtils.getVitamSession().setRequestId(GUIDFactory.newOperationLogbookGUID((int)VitamConfiguration.getAdminTenant()));
        try (StorageClient client = this.storageClientFactory.getClient();){
            LOGGER.info("Start storage log traceability");
            client.storageLogTraceability(VitamConfiguration.getTenants());
            LOGGER.info("Storage log traceability done successfully");
        }
        catch (InvalidParseOperationException | StorageServerClientException e) {
            throw new JobExecutionException(e);
        }
    }
}

