/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server.job;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.client.configuration.ClientConfigurationImpl;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class StorageBackupLogJob
implements Job {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(StorageBackupLogJob.class);
    static final String STORAGE_BACKUP_TYPE_PARAMETER = "StorageBackupType";
    static final String STORAGE_SERVER_HOSTS_PARAMETER = "StorageServerHosts";
    private static final String SERVER_SEPARATOR = ";";
    private static final String PORT_SEPARATOR = ":";
    private final StorageClientFactory storageClientFactory;

    public StorageBackupLogJob() {
        this(StorageClientFactory.getInstance());
    }

    @VisibleForTesting
    StorageBackupLogJob(StorageClientFactory storageClientFactory) {
        this.storageClientFactory = storageClientFactory;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        Integer adminTenant = VitamConfiguration.getAdminTenant();
        VitamThreadUtils.getVitamSession().setTenantId(adminTenant);
        VitamThreadUtils.getVitamSession().setRequestId(GUIDFactory.newRequestIdGUID((int)adminTenant));
        JobDataMap jobDataMap = context.getTrigger().getJobDataMap();
        String[] storageServerHosts = jobDataMap.getString(STORAGE_SERVER_HOSTS_PARAMETER).split(SERVER_SEPARATOR);
        boolean isError = false;
        for (String storageServerHost : storageServerHosts) {
            String[] host = storageServerHost.split(PORT_SEPARATOR);
            ClientConfigurationImpl clientConfiguration = new ClientConfigurationImpl(host[0], Integer.parseInt(host[1]));
            StorageClientFactory.changeMode((ClientConfiguration)clientConfiguration);
            try (StorageClient storageClient = this.storageClientFactory.getClient();){
                String storageBackupType = jobDataMap.getString(STORAGE_BACKUP_TYPE_PARAMETER);
                try {
                    switch (storageBackupType) {
                        case "AccessLog": {
                            LOGGER.info("Storage " + storageBackupType + " backup started on instance " + storageServerHost);
                            storageClient.storageAccessLogBackup(VitamConfiguration.getTenants());
                            break;
                        }
                        case "WriteLog": {
                            LOGGER.info("Storage " + storageBackupType + " backup started on instance " + storageServerHost);
                            storageClient.storageLogBackup(VitamConfiguration.getTenants());
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(storageBackupType);
                        }
                    }
                    LOGGER.info("Storage " + storageBackupType + " backup finished on instance " + storageServerHost);
                }
                catch (InvalidParseOperationException | StorageServerClientException e) {
                    LOGGER.error("An error occurred while backup storage " + storageBackupType + " on instance " + storageServerHost);
                    isError = true;
                }
            }
        }
        if (isError) {
            throw new JobExecutionException("Storage backup log completed with error");
        }
    }
}

