/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server.job;

import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientServerException;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class ReconstructionReferentialJob
implements Job {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ReconstructionReferentialJob.class);
    private final AdminManagementClientFactory adminManagementClientFactory;

    public ReconstructionReferentialJob() {
        this(AdminManagementClientFactory.getInstance());
    }

    ReconstructionReferentialJob(AdminManagementClientFactory adminManagementClientFactory) {
        this.adminManagementClientFactory = adminManagementClientFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        boolean allReferentialsSucceeded = true;
        ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)VitamThreadFactory.getInstance());
        try {
            List<CompletableFuture<Void>> completableFutures = this.getReconstructionCompletableFutures(executorService);
            for (CompletableFuture<Void> completableFuture : completableFutures) {
                try {
                    completableFuture.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new JobExecutionException(e.getMessage());
                }
                catch (ExecutionException e) {
                    LOGGER.error("Reconstruction failed", (Throwable)e);
                    allReferentialsSucceeded = false;
                }
            }
        }
        finally {
            executorService.shutdown();
        }
        if (!allReferentialsSucceeded) {
            throw new JobExecutionException("one or more referentials are failed");
        }
    }

    private List<CompletableFuture<Void>> getReconstructionCompletableFutures(ExecutorService executorService) {
        ArrayList<CompletableFuture<Void>> completableFutures = new ArrayList<CompletableFuture<Void>>();
        block3: for (FunctionalAdminCollections referential : FunctionalAdminCollections.values()) {
            switch (referential) {
                case ACCESSION_REGISTER_DETAIL: 
                case ACCESSION_REGISTER_SUMMARY: 
                case ACCESSION_REGISTER_SYMBOLIC: 
                case VITAM_SEQUENCE: {
                    continue block3;
                }
                default: {
                    String referentialValue = referential.name();
                    CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
                        try (AdminManagementClient client = this.adminManagementClientFactory.getClient();){
                            VitamThreadUtils.getVitamSession().setTenantId(VitamConfiguration.getAdminTenant());
                            VitamThreadUtils.getVitamSession().setRequestId(GUIDFactory.newOperationLogbookGUID((int)VitamConfiguration.getAdminTenant()));
                            LOGGER.info("Reconstruction " + referentialValue + " in progress...");
                            client.reconstructCollection(referentialValue);
                            LOGGER.info("Reconstruction " + referentialValue + " is finished");
                        }
                        catch (AdminManagementClientServerException e) {
                            throw new IllegalStateException(" Error when reconstruction " + referentialValue + "  :  " + VitamConfiguration.getAdminTenant(), e);
                        }
                    }, executorService);
                    completableFutures.add(completableFuture);
                }
            }
        }
        return completableFutures;
    }
}

