/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server.job;

import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.model.reconstruction.ReconstructionRequestItem;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import java.util.List;
import java.util.stream.Collectors;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class ReconstructionOperationJob
implements Job {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ReconstructionOperationJob.class);
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;

    public ReconstructionOperationJob() {
        this(LogbookOperationsClientFactory.getInstance());
    }

    ReconstructionOperationJob(LogbookOperationsClientFactory logbookOperationsClientFactory) {
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        Integer adminTenant = VitamConfiguration.getAdminTenant();
        try {
            VitamThreadUtils.getVitamSession().setTenantId(adminTenant);
            VitamThreadUtils.getVitamSession().setRequestId(GUIDFactory.newOperationLogbookGUID((int)adminTenant));
            List reconstructionItems = VitamConfiguration.getTenants().stream().map(ReconstructionRequestItem::new).collect(Collectors.toList());
            try (LogbookOperationsClient client = this.logbookOperationsClientFactory.getClient();){
                LOGGER.info("Reconstruction operation in progress...");
                client.reconstructCollection(reconstructionItems);
                LOGGER.info("Reconstruction operation is finished");
            }
        }
        catch (LogbookClientServerException e) {
            throw new IllegalStateException(" Error when securing logbook operations  :  " + adminTenant, e);
        }
    }
}

