/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server.job;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataNotFoundException;
import fr.gouv.vitam.metadata.api.model.ReconstructionRequestItem;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import java.util.ArrayList;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class MetadataReconstructionJob
implements Job {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MetadataReconstructionJob.class);
    private final MetaDataClientFactory metaDataClientFactory;
    public static final String OBJECTGROUP = "OBJECTGROUP";
    public static final String UNIT = "UNIT";
    public static final String UNIT_GRAPH = "UNIT_GRAPH";
    public static final String OBJECTGROUP_GRAPH = "OBJECTGROUP_GRAPH";

    public MetadataReconstructionJob() {
        this.metaDataClientFactory = MetaDataClientFactory.getInstance();
    }

    @VisibleForTesting
    public MetadataReconstructionJob(MetaDataClientFactory metaDataClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        Integer adminTenant = VitamConfiguration.getAdminTenant();
        VitamThreadUtils.getVitamSession().setTenantId(adminTenant);
        VitamThreadUtils.getVitamSession().setRequestId(GUIDFactory.newOperationLogbookGUID((int)adminTenant));
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
            LOGGER.info("Process of reconstruction in progress...");
            ArrayList<ReconstructionRequestItem> requestItemList = new ArrayList<ReconstructionRequestItem>();
            VitamConfiguration.getTenants().forEach(tenant -> {
                requestItemList.add(this.getReconstructionRequestItem((Integer)tenant, UNIT));
                requestItemList.add(this.getReconstructionRequestItem((Integer)tenant, OBJECTGROUP));
            });
            requestItemList.add(this.getReconstructionRequestItem(VitamConfiguration.getAdminTenant(), UNIT_GRAPH));
            requestItemList.add(this.getReconstructionRequestItem(VitamConfiguration.getAdminTenant(), OBJECTGROUP_GRAPH));
            metaDataClient.reconstructCollection(requestItemList);
            LOGGER.info("End of process reconstruction");
        }
        catch (InvalidParseOperationException | MetaDataClientServerException | MetaDataNotFoundException e) {
            throw new JobExecutionException(e);
        }
    }

    private ReconstructionRequestItem getReconstructionRequestItem(Integer tenant, String collection) {
        ReconstructionRequestItem requestItem = new ReconstructionRequestItem();
        requestItem.setCollection(collection).setTenant(tenant).setLimit(VitamConfiguration.getRestoreBulkSize());
        return requestItem;
    }
}

