/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server;

import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.FileNotFoundException;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

public class SchedulerListener
implements ServletContextListener {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SchedulerListener.class);
    private static SchedulerListener INSTANCE = null;
    private final Scheduler scheduler;

    private SchedulerListener() throws SchedulerException {
        try {
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory(PropertiesUtils.getConfigFile((String)"quartz.properties").getPath());
            this.scheduler = schedulerFactory.getScheduler();
        }
        catch (FileNotFoundException e) {
            throw new SchedulerException((Throwable)e);
        }
    }

    public static SchedulerListener getInstance() throws SchedulerException {
        if (INSTANCE == null) {
            INSTANCE = new SchedulerListener();
        }
        return INSTANCE;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void contextInitialized(ServletContextEvent sce) {
        LOGGER.warn("Scheduler started");
        try {
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            LOGGER.error("cannot start scheduler", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        LOGGER.warn("Scheduler destroyed");
        try {
            this.scheduler.shutdown(true);
        }
        catch (SchedulerException e) {
            LOGGER.error("Cannot shutdown scheduler", (Throwable)e);
        }
    }
}

