/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ihmrecette.appserver;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.processing.WorkFlowExecutionContext;
import fr.gouv.vitam.common.model.storage.AccessRequestStatus;
import fr.gouv.vitam.common.stream.VitamAsyncInputStreamResponse;
import fr.gouv.vitam.storage.driver.Connection;
import fr.gouv.vitam.storage.driver.Driver;
import fr.gouv.vitam.storage.driver.exception.StorageDriverException;
import fr.gouv.vitam.storage.driver.model.StorageAccessRequestCreationRequest;
import fr.gouv.vitam.storage.driver.model.StorageObjectRequest;
import fr.gouv.vitam.storage.engine.common.exception.StorageDriverNotFoundException;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.exception.StorageTechnicalException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.referential.StorageOfferProvider;
import fr.gouv.vitam.storage.engine.common.referential.StorageOfferProviderFactory;
import fr.gouv.vitam.storage.engine.common.referential.StorageStrategyProvider;
import fr.gouv.vitam.storage.engine.common.referential.StorageStrategyProviderFactory;
import fr.gouv.vitam.storage.engine.common.referential.model.OfferReference;
import fr.gouv.vitam.storage.engine.common.referential.model.StorageOffer;
import fr.gouv.vitam.storage.engine.common.referential.model.StorageStrategy;
import fr.gouv.vitam.storage.engine.server.rest.StorageConfiguration;
import fr.gouv.vitam.storage.engine.server.spi.DriverManager;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class StorageService {
    private static final String STRATEGY_ID_IS_MANDATORY = "Strategy id is mandatory";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(StorageService.class);
    private static final StorageStrategyProvider STRATEGY_PROVIDER = StorageStrategyProviderFactory.getDefaultProvider();
    private static final StorageOfferProvider OFFER_PROVIDER = StorageOfferProviderFactory.getDefaultProvider();
    private static final String OBJECT_ID_IS_MANDATORY = "Object id is mandatory";
    private static final String CATEGORY_IS_MANDATORY = "Category is mandatory";
    private static final String ACCESS_REQUEST_ID_IS_MANDATORY = "Access request id is mandatory";

    public StorageService(StorageConfiguration configuration) {
        ParametersChecker.checkParameter((String)"Storage service configuration is mandatory", (Object[])new Object[]{configuration});
        String urlWorkspace = configuration.getUrlWorkspace();
        WorkspaceClientFactory.changeMode((String)urlWorkspace, (WorkFlowExecutionContext)WorkFlowExecutionContext.VITAM);
    }

    private static StorageOffer getStorageOffer(OfferReference offerReference) {
        StorageOffer storageOffer = null;
        try {
            storageOffer = OFFER_PROVIDER.getStorageOffer(offerReference.getId());
        }
        catch (StorageException e) {
            LOGGER.error((Throwable)e);
        }
        return storageOffer;
    }

    private VitamError buildError(VitamCode vitamCode, String message) {
        return new VitamError(VitamCodeHelper.getCode((VitamCode)vitamCode)).setContext(vitamCode.getService().getName()).setHttpCode(vitamCode.getStatus().getStatusCode()).setState(vitamCode.getDomain().getName()).setMessage(vitamCode.getMessage()).setDescription(message);
    }

    public RequestResponse<String> createAccessRequest(Integer tenantId, String strategyId, String offerId, String objectId, DataCategory category) throws StorageTechnicalException, StorageNotFoundException {
        RequestResponseOK requestResponseOK;
        block8: {
            this.checkStoreDataParams(strategyId, objectId, category);
            Driver driver = this.getDriver(strategyId, offerId, true);
            Connection connection = driver.connect(offerId);
            try {
                StorageAccessRequestCreationRequest storageAccessRequestCreationRequest = new StorageAccessRequestCreationRequest(tenantId, category.getFolder(), Collections.singletonList(objectId));
                String accessRequestId = connection.createAccessRequest(storageAccessRequestCreationRequest);
                requestResponseOK = new RequestResponseOK().setHttpCode(Response.Status.OK.getStatusCode()).addResult((Object)accessRequestId);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StorageDriverException e) {
                    return this.buildError(VitamCode.STORAGE_OBJECT_NOT_FOUND, e.getMessage());
                }
            }
            connection.close();
        }
        return requestResponseOK;
    }

    public VitamAsyncInputStreamResponse download(Integer tenantId, DataCategory dataCategory, String strategyId, String offerId, String objectId) throws StorageTechnicalException, StorageDriverException, StorageNotFoundException {
        ParametersChecker.checkParameter((String)ACCESS_REQUEST_ID_IS_MANDATORY, (String[])new String[]{objectId});
        Driver driver = this.getDriver(strategyId, offerId, false);
        try (Connection connection = driver.connect(offerId);){
            StorageObjectRequest request = new StorageObjectRequest(tenantId, dataCategory.getFolder(), objectId);
            VitamAsyncInputStreamResponse vitamAsyncInputStreamResponse = new VitamAsyncInputStreamResponse(connection.getObject(request).getObject(), Response.Status.OK, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            return vitamAsyncInputStreamResponse;
        }
    }

    public RequestResponse<AccessRequestStatus> checkAccessRequestStatus(Integer tenantId, String strategyId, String offerId, String accessRequestId) throws StorageTechnicalException, StorageNotFoundException {
        RequestResponseOK requestResponseOK;
        block8: {
            ParametersChecker.checkParameter((String)ACCESS_REQUEST_ID_IS_MANDATORY, (String[])new String[]{accessRequestId});
            Driver driver = this.getDriver(strategyId, offerId, true);
            Connection connection = driver.connect(offerId);
            try {
                Map accessRequestStatusMap = connection.checkAccessRequestStatuses(List.of(accessRequestId), tenantId.intValue(), false);
                requestResponseOK = new RequestResponseOK().setHttpCode(Response.Status.OK.getStatusCode()).addResult((Object)((AccessRequestStatus)accessRequestStatusMap.get(accessRequestId)));
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StorageDriverException e) {
                    return this.buildError(VitamCode.STORAGE_OBJECT_NOT_FOUND, e.getMessage());
                }
            }
            connection.close();
        }
        return requestResponseOK;
    }

    public RequestResponse<AccessRequestStatus> removeAccessRequest(Integer tenantId, String strategyId, String offerId, String accessRequestId) throws StorageTechnicalException, StorageNotFoundException {
        RequestResponseOK requestResponseOK;
        block8: {
            ParametersChecker.checkParameter((String)ACCESS_REQUEST_ID_IS_MANDATORY, (String[])new String[]{accessRequestId});
            Driver driver = this.getDriver(strategyId, offerId, true);
            Connection connection = driver.connect(offerId);
            try {
                connection.removeAccessRequest(accessRequestId, tenantId.intValue(), false);
                requestResponseOK = new RequestResponseOK().setHttpCode(Response.Status.OK.getStatusCode());
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StorageDriverException e) {
                    return this.buildError(VitamCode.STORAGE_OBJECT_NOT_FOUND, e.getMessage());
                }
            }
            connection.close();
        }
        return requestResponseOK;
    }

    private Driver getDriver(String strategyId, String offerId, boolean mustBeAsyncDriver) throws StorageTechnicalException, StorageNotFoundException {
        List<OfferReference> offerReferences = this.getOffersReferences(strategyId);
        if (offerReferences == null || offerReferences.isEmpty()) {
            throw new StorageTechnicalException("No offer found in strategy " + strategyId);
        }
        StorageOffer storageOffers = offerReferences.stream().map(StorageService::getStorageOffer).filter(o -> o.getId().equals(offerId)).findFirst().orElseThrow(() -> new StorageTechnicalException("No such offer " + offerId + " in strategy " + strategyId));
        if (mustBeAsyncDriver && !storageOffers.isAsyncRead()) {
            throw new StorageTechnicalException("Offer " + offerId + " does not support AsyncRead");
        }
        try {
            return DriverManager.getDriverFor((String)offerId);
        }
        catch (StorageDriverNotFoundException exc) {
            throw new StorageTechnicalException((Throwable)exc);
        }
    }

    private void checkStoreDataParams(String strategyId, String dataId, DataCategory category) {
        ParametersChecker.checkParameter((String)STRATEGY_ID_IS_MANDATORY, (String[])new String[]{strategyId});
        ParametersChecker.checkParameter((String)OBJECT_ID_IS_MANDATORY, (String[])new String[]{dataId});
        ParametersChecker.checkParameter((String)CATEGORY_IS_MANDATORY, (Object[])new Object[]{category});
    }

    public List<OfferReference> getOffersReferences(String strategyId) throws StorageNotFoundException, StorageTechnicalException {
        StorageStrategy storageStrategy = STRATEGY_PROVIDER.getStorageStrategy(strategyId);
        if (storageStrategy == null) {
            throw new StorageNotFoundException(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_STRATEGY_NOT_FOUND, (Object[])new Object[0]));
        }
        ArrayList<OfferReference> offerReferences = new ArrayList<OfferReference>();
        if (!storageStrategy.getOffers().isEmpty()) {
            offerReferences.addAll(storageStrategy.getOffers());
        }
        return offerReferences;
    }
}

