/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.rest;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.schema.SchemaInputModel;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.core.schema.SchemaService;
import fr.gouv.vitam.functional.administration.utils.ResponseErrorUtils;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/adminmanagement/v1")
@ApplicationPath(value="webresources")
@Tag(name="Functional-Administration")
public class SchemaResource {
    private static final String FUNCTIONAL_ADMINISTRATION_MODULE = "FUNCTIONAL_ADMINISTRATION_MODULE";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SchemaResource.class);
    public static final String UNIT_SCHEMA_URI = "/schema/unit";
    public static final String OBJECTGROUP_SCHEMA_URI = "/schema/objectgroup";
    private static final String SCHEMA_JSON_IS_MANDATORY_PARAMETER = "The json input of external schema type is mandatory";
    private final SchemaService schemaService;

    public SchemaResource(SchemaService schemaService) {
        this.schemaService = schemaService;
    }

    @Path(value="/schema/unit")
    @GET
    @Produces(value={"application/json"})
    public Response unitSchema() {
        try {
            LOGGER.info(" retrieving unit schema elements");
            List unitSchema = this.schemaService.findUnitSchema();
            return Response.ok((Object)unitSchema).build();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | ReferentialException | IOException e) {
            LOGGER.error("Cannot retrieve unit schema ", e);
            return Response.serverError().build();
        }
    }

    @Path(value="/schema/objectgroup")
    @GET
    @Produces(value={"application/json"})
    public Response objectGroupSchema() {
        try {
            LOGGER.info(" retrieving object group schema elements");
            List objectGroupSchema = this.schemaService.findObjectGroupInternalSchema();
            return Response.ok((Object)objectGroupSchema).build();
        }
        catch (InvalidParseOperationException | ReferentialException | IOException e) {
            LOGGER.error("Cannot retrieve object group schema ", e);
            return Response.serverError().build();
        }
    }

    @Path(value="/schema/unit")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response importExternalSchemaElements(List<SchemaInputModel> externalSchemaList, @Context UriInfo uri) {
        ParametersChecker.checkParameter((String)SCHEMA_JSON_IS_MANDATORY_PARAMETER, (Object[])new Object[]{externalSchemaList});
        try {
            RequestResponse requestResponse = this.schemaService.importExternalSchemaElements(externalSchemaList);
            if (!requestResponse.isOk()) {
                return Response.status((int)requestResponse.getHttpCode()).entity((Object)requestResponse).build();
            }
            return Response.accepted((Object)uri.getRequestUri().normalize()).entity((Object)requestResponse).build();
        }
        catch (Exception exp) {
            LOGGER.error("Unexpected server error {}", (Throwable)exp);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(ResponseErrorUtils.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, exp.getMessage(), FUNCTIONAL_ADMINISTRATION_MODULE)).build();
        }
    }

    @Path(value="/schema/unit")
    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteUnitExternalSchemas(List<String> paths) {
        ParametersChecker.checkParameter((String)"The unit external schema paths list is mandatory", (Object[])new Object[]{paths});
        try {
            Integer tenantId = ParameterHelper.getTenantParameter();
            this.schemaService.checkAndDeleteExternalSchemaElementsByPaths(paths, tenantId.equals(VitamConfiguration.getAdminTenant()));
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (BadRequestException exp) {
            LOGGER.error("Bad Request Error {}", (Throwable)exp);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ResponseErrorUtils.getErrorEntity(Response.Status.BAD_REQUEST, exp.getMessage(), FUNCTIONAL_ADMINISTRATION_MODULE)).build();
        }
        catch (Exception exp) {
            LOGGER.error("Unexpected server error {}", (Throwable)exp);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(ResponseErrorUtils.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, exp.getMessage(), FUNCTIONAL_ADMINISTRATION_MODULE)).build();
        }
    }
}

