/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.MongoCollection;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.collections.VitamCollectionHelper;
import fr.gouv.vitam.common.database.index.model.ReindexationOK;
import fr.gouv.vitam.common.database.index.model.ReindexationResult;
import fr.gouv.vitam.common.database.index.model.SwitchIndexResult;
import fr.gouv.vitam.common.database.parameter.IndexParameters;
import fr.gouv.vitam.common.database.parameter.SwitchIndexParameters;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchAccess;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexAlias;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexSettings;
import fr.gouv.vitam.common.database.server.elasticsearch.IndexationHelper;
import fr.gouv.vitam.common.error.ServiceName;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.functional.administration.common.config.ElasticsearchFunctionalAdminIndexManager;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.CollectionUtils;

@Path(value="/adminmanagement/v1")
@ApplicationPath(value="webresources")
@Tag(name="Functional-Administration")
public class ReindexationResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ReindexationResource.class);
    private static final String OPTIONS_IS_MANDATORY_PARAMETER = "Parameters are mandatory";
    private static final String REINDEXATION_EXCEPTION_MSG = "ERROR: Exception has been thrown when reindexing Vitam collections: ";
    private static final String REINDEX_URI = "/reindex";
    private static final String ALIASES_URI = "/alias";
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;
    private final MetaDataClientFactory metaDataClientFactory;
    private final IndexationHelper indexationHelper;
    private final ElasticsearchFunctionalAdminIndexManager indexManager;

    @VisibleForTesting
    public ReindexationResource(LogbookOperationsClientFactory logbookOperationsClientFactory, MetaDataClientFactory metaDataClientFactory, IndexationHelper indexationHelper, ElasticsearchFunctionalAdminIndexManager indexManager) {
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
        this.metaDataClientFactory = metaDataClientFactory;
        this.indexationHelper = indexationHelper;
        this.indexManager = indexManager;
        LOGGER.debug("init Reindexation Resource server");
    }

    public ReindexationResource(ElasticsearchFunctionalAdminIndexManager indexManager) {
        this.indexManager = indexManager;
        this.logbookOperationsClientFactory = LogbookOperationsClientFactory.getInstance();
        this.metaDataClientFactory = MetaDataClientFactory.getInstance();
        this.indexationHelper = IndexationHelper.getInstance();
        LOGGER.debug("init Reindexation Resource server");
    }

    @Path(value="/reindex")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response reindex(@Valid List<IndexParameters> indexParameters) {
        ParametersChecker.checkParameter((String)OPTIONS_IS_MANDATORY_PARAMETER, (Object[])new Object[]{indexParameters});
        ArrayList<ReindexationResult> results = new ArrayList<ReindexationResult>();
        for (IndexParameters index : indexParameters) {
            ReindexationResult indexationResult2 = VitamCollectionHelper.isLogbookCollection((String)index.getCollectionName()) ? this.reindexLogbookCollection(index) : (VitamCollectionHelper.isMetadataCollection((String)index.getCollectionName()) ? this.reindexMetaDataCollection(index) : this.reindexFunctionalAdminCollection(index));
            results.add(indexationResult2);
        }
        boolean atLeastOneOK = results.stream().anyMatch(indexationResult -> CollectionUtils.isNotEmpty((Collection)indexationResult.getIndexOK()));
        boolean atLeastOneKO = results.stream().anyMatch(indexationResult -> CollectionUtils.isNotEmpty((Collection)indexationResult.getIndexKO()));
        if (atLeastOneKO && !atLeastOneOK) {
            Response.Status returnedStatus = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)returnedStatus).entity((Object)new VitamError(returnedStatus.name()).setHttpCode(returnedStatus.getStatusCode()).setContext(ServiceName.FUNCTIONAL_ADMINISTRATION.getName()).setState("code_vitam").setMessage(JsonHandler.unprettyPrint(results)).setDescription("Internal error.")).build();
        }
        if (atLeastOneKO) {
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)new RequestResponseOK().addAllResults(results).setHttpCode(Response.Status.ACCEPTED.getStatusCode())).build();
        }
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)new RequestResponseOK().addAllResults(results).setHttpCode(Response.Status.CREATED.getStatusCode())).build();
    }

    private ReindexationResult reindexLogbookCollection(IndexParameters indexParameters) {
        ReindexationResult reindexationResult;
        block8: {
            LogbookOperationsClient logbookOperationsClient = this.logbookOperationsClientFactory.getClient();
            try {
                reindexationResult = logbookOperationsClient.reindex(indexParameters);
                if (logbookOperationsClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (logbookOperationsClient != null) {
                        try {
                            logbookOperationsClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error(REINDEXATION_EXCEPTION_MSG, (Throwable)e);
                    return this.indexationHelper.getFullKOResult(indexParameters, REINDEXATION_EXCEPTION_MSG);
                }
            }
            logbookOperationsClient.close();
        }
        return reindexationResult;
    }

    private ReindexationResult reindexMetaDataCollection(IndexParameters indexParameters) {
        ReindexationResult reindexationResult;
        block8: {
            MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();
            try {
                reindexationResult = (ReindexationResult)JsonHandler.getFromJsonNode((JsonNode)metaDataClient.reindex(indexParameters), ReindexationResult.class);
                if (metaDataClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (metaDataClient != null) {
                        try {
                            metaDataClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error(REINDEXATION_EXCEPTION_MSG, (Throwable)e);
                    return this.indexationHelper.getFullKOResult(indexParameters, REINDEXATION_EXCEPTION_MSG);
                }
            }
            metaDataClient.close();
        }
        return reindexationResult;
    }

    private ReindexationResult reindexFunctionalAdminCollection(IndexParameters indexParameters) {
        FunctionalAdminCollections collectionToReindex;
        try {
            collectionToReindex = FunctionalAdminCollections.valueOf((String)indexParameters.getCollectionName());
        }
        catch (IllegalArgumentException ex) {
            String message = String.format("Try to reindex an unknown collection %s", indexParameters.getCollectionName());
            LOGGER.error(message, (Throwable)ex);
            return this.indexationHelper.getFullKOResult(indexParameters, message);
        }
        if (CollectionUtils.isNotEmpty((Collection)indexParameters.getTenants())) {
            LOGGER.warn("Ignoring tenant list for collection " + String.valueOf(collectionToReindex));
        }
        MongoCollection mongoCollection = collectionToReindex.getCollection();
        try {
            ElasticsearchIndexAlias indexAlias = this.indexManager.getElasticsearchIndexAliasResolver(collectionToReindex).resolveIndexName(null);
            ElasticsearchIndexSettings indexSettings = this.indexManager.getElasticsearchIndexSettings(collectionToReindex);
            ReindexationOK reindexResult = this.indexationHelper.reindex(mongoCollection, (ElasticsearchAccess)collectionToReindex.getEsClient(), indexAlias, indexSettings, collectionToReindex.getElasticsearchCollection(), null, null, this.indexManager.getElasticSearchConfigurationFile());
            ReindexationResult indexationResult = new ReindexationResult();
            indexationResult.setCollectionName(indexParameters.getCollectionName());
            indexationResult.setIndexOK(Collections.singletonList(reindexResult));
            return indexationResult;
        }
        catch (Exception exc) {
            LOGGER.error("Cannot reindex collection " + collectionToReindex.name() + ". Unexpected error");
            return this.indexationHelper.getFullKOResult(indexParameters, exc.getMessage());
        }
    }

    @Path(value="/alias")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response switchIndexes(@Valid List<SwitchIndexParameters> switchIndexParameters) {
        ParametersChecker.checkParameter((String)OPTIONS_IS_MANDATORY_PARAMETER, (Object[])new Object[]{switchIndexParameters});
        ArrayList results = new ArrayList();
        switchIndexParameters.forEach(switchIndex -> {
            try {
                SwitchIndexResult switchIndexResult = VitamCollectionHelper.isLogbookCollection((String)switchIndex.getCollectionName()) ? this.switchLogbookCollectionAlias((SwitchIndexParameters)switchIndex) : (VitamCollectionHelper.isMetadataCollection((String)switchIndex.getCollectionName()) ? this.switchMetadataCollectionAlias((SwitchIndexParameters)switchIndex) : this.switchFunctionalAdminCollection((SwitchIndexParameters)switchIndex));
                results.add(switchIndexResult);
            }
            catch (Exception e) {
                String message = String.format("Error while switching indexes for alias '%s' into '%s'", switchIndex.getAlias(), switchIndex.getIndexName());
                LOGGER.error(message, (Throwable)e);
                results.add(this.indexationHelper.getKOResult(switchIndex, message));
            }
        });
        boolean atLeastOneOK = results.stream().anyMatch(switchIndexResult -> switchIndexResult.getStatusCode() == StatusCode.OK);
        boolean atLeastOneKO = results.stream().anyMatch(switchIndexResult -> switchIndexResult.getStatusCode() != StatusCode.OK);
        if (atLeastOneKO && !atLeastOneOK) {
            Response.Status returnedStatus = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)returnedStatus).entity((Object)new VitamError(returnedStatus.name()).setHttpCode(returnedStatus.getStatusCode()).setContext(ServiceName.FUNCTIONAL_ADMINISTRATION.getName()).setState("code_vitam").setMessage(JsonHandler.unprettyPrint(results)).setDescription("Internal error.")).build();
        }
        if (atLeastOneKO) {
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)new RequestResponseOK().addAllResults(results).setHttpCode(Response.Status.ACCEPTED.getStatusCode())).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new RequestResponseOK().addAllResults(results).setHttpCode(Response.Status.OK.getStatusCode())).build();
    }

    private SwitchIndexResult switchFunctionalAdminCollection(SwitchIndexParameters switchIndex) throws DatabaseException {
        ElasticsearchIndexAlias alias = ElasticsearchIndexAlias.ofFullIndexName((String)switchIndex.getAlias());
        ElasticsearchIndexAlias newIndex = ElasticsearchIndexAlias.ofFullIndexName((String)switchIndex.getIndexName());
        return this.indexationHelper.switchIndex(alias, newIndex, (ElasticsearchAccess)FunctionalAdminCollections.ACCESS_CONTRACT.getEsClient());
    }

    private SwitchIndexResult switchLogbookCollectionAlias(SwitchIndexParameters switchIndex) {
        SwitchIndexResult switchIndexResult;
        block8: {
            LogbookOperationsClient logbookOperationsClient = this.logbookOperationsClientFactory.getClient();
            try {
                switchIndexResult = logbookOperationsClient.switchIndexes(switchIndex);
                if (logbookOperationsClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (logbookOperationsClient != null) {
                        try {
                            logbookOperationsClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    String message = "Error while switching indexes on logbook collection " + switchIndex.getAlias();
                    LOGGER.error(message, (Throwable)e);
                    return this.indexationHelper.getKOResult(switchIndex, message);
                }
            }
            logbookOperationsClient.close();
        }
        return switchIndexResult;
    }

    private SwitchIndexResult switchMetadataCollectionAlias(SwitchIndexParameters switchIndex) {
        SwitchIndexResult switchIndexResult;
        block8: {
            MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();
            try {
                switchIndexResult = metaDataClient.switchIndexes(switchIndex);
                if (metaDataClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (metaDataClient != null) {
                        try {
                            metaDataClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    String message = "Error while switching indexes on metadata collection " + switchIndex.getAlias();
                    LOGGER.error(message, (Throwable)e);
                    return this.indexationHelper.getKOResult(switchIndex, message);
                }
            }
            metaDataClient.close();
        }
        return switchIndexResult;
    }
}

