/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.core.ontologies.OntologyService;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.List;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/adminmanagement/v1")
@ApplicationPath(value="webresources")
@Tag(name="Functional-Administration")
public class OntologyResource {
    private static final String FUNCTIONAL_ADMINISTRATION_MODULE = "FUNCTIONAL_ADMINISTRATION_MODULE";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(OntologyResource.class);
    private static final String ONTOLOGY_URI = "/ontologies";
    private static final String ONTOLOGY_CACHE_URI = "/ontologies/cache";
    private static final String ONTOLOGY_JSON_IS_MANDATORY_PATAMETER = "The json input of ontology type is mandatory";
    private final OntologyService ontologyService;

    public OntologyResource(OntologyService ontologyService) {
        this.ontologyService = ontologyService;
        LOGGER.debug("init Ontology Resource server");
    }

    @Path(value="/ontologies")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response importOntologies(@HeaderParam(value="Force-Update") boolean forceUpdate, List<OntologyModel> ontologyModelList, @Context UriInfo uri) {
        ParametersChecker.checkParameter((String)ONTOLOGY_JSON_IS_MANDATORY_PATAMETER, (Object[])new Object[]{ontologyModelList});
        try {
            RequestResponse requestResponse = this.ontologyService.importOntologies(forceUpdate, ontologyModelList);
            if (!requestResponse.isOk()) {
                return Response.status((int)requestResponse.getHttpCode()).entity((Object)requestResponse).build();
            }
            return Response.created((URI)uri.getRequestUri().normalize()).entity((Object)requestResponse).build();
        }
        catch (VitamException exp) {
            LOGGER.error((Throwable)exp);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(this.getErrorEntity(Response.Status.BAD_REQUEST, exp.getMessage())).build();
        }
        catch (Exception exp) {
            LOGGER.error("Unexpected server error {}", (Throwable)exp);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, exp.getMessage())).build();
        }
    }

    @GET
    @Path(value="/ontologies")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response findOntologies(JsonNode queryDsl) {
        try {
            RequestResponseOK ontologyModelList = this.ontologyService.findOntologies(queryDsl).setQuery(queryDsl);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)ontologyModelList).build();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage())).build();
        }
    }

    @GET
    @Path(value="/ontologies/cache")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response findOntologiesForCache(JsonNode queryDsl) {
        try {
            RequestResponseOK ontologyModelList = this.ontologyService.findOntologiesForCache(queryDsl).setQuery(queryDsl);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)ontologyModelList).build();
        }
        catch (ReferentialException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(this.getErrorEntity(Response.Status.BAD_REQUEST, e.getMessage())).build();
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage())).build();
        }
    }

    private VitamError<OntologyModel> getErrorEntity(Response.Status status, String message) {
        String aMessage = message != null && !message.trim().isEmpty() ? message : (status.getReasonPhrase() != null ? status.getReasonPhrase() : status.name());
        return new VitamError(String.valueOf(status.getStatusCode())).setHttpCode(status.getStatusCode()).setContext(FUNCTIONAL_ADMINISTRATION_MODULE).setState("ko").setMessage(status.getReasonPhrase()).setDescription(aMessage);
    }
}

