/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.rest;

import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.OntologyLoader;
import fr.gouv.vitam.common.database.api.VitamRepositoryFactory;
import fr.gouv.vitam.common.database.api.VitamRepositoryProvider;
import fr.gouv.vitam.common.database.collections.CachedOntologyLoader;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.serverv2.application.CommonBusinessApplication;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.client.AdminManagementOntologyLoader;
import fr.gouv.vitam.functional.administration.common.client.FunctionAdministrationOntologyLoader;
import fr.gouv.vitam.functional.administration.common.config.AdminManagementConfiguration;
import fr.gouv.vitam.functional.administration.common.config.AdminManagementConfigurationValidator;
import fr.gouv.vitam.functional.administration.common.config.ElasticsearchCustomSearchManager;
import fr.gouv.vitam.functional.administration.common.config.ElasticsearchFunctionalAdminIndexManager;
import fr.gouv.vitam.functional.administration.common.counter.VitamCounterService;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminImpl;
import fr.gouv.vitam.functional.administration.core.agencies.AgenciesService;
import fr.gouv.vitam.functional.administration.core.archiveunitprofiles.ArchiveUnitProfileService;
import fr.gouv.vitam.functional.administration.core.archiveunitprofiles.ArchiveUnitProfileServiceImpl;
import fr.gouv.vitam.functional.administration.core.archiveunitprofilesSchema.ArchiveUnitProfileSchemaServiceImpl;
import fr.gouv.vitam.functional.administration.core.backup.FunctionalBackupService;
import fr.gouv.vitam.functional.administration.core.context.ContextService;
import fr.gouv.vitam.functional.administration.core.context.ContextServiceImpl;
import fr.gouv.vitam.functional.administration.core.griffin.GriffinService;
import fr.gouv.vitam.functional.administration.core.griffin.PreservationScenarioService;
import fr.gouv.vitam.functional.administration.core.ontologies.OntologyService;
import fr.gouv.vitam.functional.administration.core.ontologies.OntologyServiceImpl;
import fr.gouv.vitam.functional.administration.core.schema.SchemaService;
import fr.gouv.vitam.functional.administration.core.security.profile.SecurityProfileService;
import fr.gouv.vitam.functional.administration.rest.AdminManagementResource;
import fr.gouv.vitam.functional.administration.rest.AdminPublicConfigurationResource;
import fr.gouv.vitam.functional.administration.rest.AgenciesResource;
import fr.gouv.vitam.functional.administration.rest.ArchiveUnitProfileResource;
import fr.gouv.vitam.functional.administration.rest.ArchiveUnitProfileSchemaResource;
import fr.gouv.vitam.functional.administration.rest.ContextResource;
import fr.gouv.vitam.functional.administration.rest.ContractResource;
import fr.gouv.vitam.functional.administration.rest.EvidenceResource;
import fr.gouv.vitam.functional.administration.rest.OntologyResource;
import fr.gouv.vitam.functional.administration.rest.PreservationResource;
import fr.gouv.vitam.functional.administration.rest.ProbativeValueResource;
import fr.gouv.vitam.functional.administration.rest.ProfileResource;
import fr.gouv.vitam.functional.administration.rest.ReconstructionResource;
import fr.gouv.vitam.functional.administration.rest.ReindexationResource;
import fr.gouv.vitam.functional.administration.rest.SchemaResource;
import fr.gouv.vitam.functional.administration.rest.SecurityProfileResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;

public class BusinessApplication
extends Application {
    private final CommonBusinessApplication commonBusinessApplication;
    private final Set<Object> singletons;

    public BusinessApplication(@Context ServletConfig servletConfig) {
        String configurationFile = servletConfig.getInitParameter("vitam.configurationFile");
        this.commonBusinessApplication = new CommonBusinessApplication();
        this.singletons = new HashSet<Object>();
        this.singletons.addAll(this.commonBusinessApplication.getResources());
        try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)configurationFile);){
            AdminManagementConfiguration configuration = (AdminManagementConfiguration)PropertiesUtils.readYaml((InputStream)yamlIS, AdminManagementConfiguration.class);
            AdminManagementConfigurationValidator.validateConfiguration((AdminManagementConfiguration)configuration);
            ElasticsearchFunctionalAdminIndexManager indexManager = new ElasticsearchFunctionalAdminIndexManager(configuration);
            CachedOntologyLoader ontologyLoader = new CachedOntologyLoader(VitamConfiguration.getOntologyCacheMaxEntries(), VitamConfiguration.getOntologyCacheTimeoutInSeconds(), (OntologyLoader)new FunctionAdministrationOntologyLoader());
            CachedOntologyLoader agenciesOntologyLoader = new CachedOntologyLoader(VitamConfiguration.getOntologyCacheMaxEntries(), VitamConfiguration.getOntologyCacheTimeoutInSeconds(), (OntologyLoader)new AdminManagementOntologyLoader(AdminManagementClientFactory.getInstance(), Optional.of(FunctionalAdminCollections.AGENCIES.getName())));
            CachedOntologyLoader rulesOntologyLoader = new CachedOntologyLoader(VitamConfiguration.getOntologyCacheMaxEntries(), VitamConfiguration.getOntologyCacheTimeoutInSeconds(), (OntologyLoader)new AdminManagementOntologyLoader(AdminManagementClientFactory.getInstance(), Optional.of(FunctionalAdminCollections.RULES.getName())));
            AdminManagementResource resource = new AdminManagementResource(configuration, (OntologyLoader)ontologyLoader, indexManager);
            MongoDbAccessAdminImpl mongoDbAccess = resource.getLogbookDbAccess();
            Map externalIdentifiers = configuration.getListEnableExternalIdentifiers();
            VitamCounterService vitamCounterService = new VitamCounterService(mongoDbAccess, VitamConfiguration.getTenants(), externalIdentifiers);
            resource.setVitamCounterService(vitamCounterService);
            FunctionalBackupService functionalBackupService = new FunctionalBackupService(vitamCounterService);
            SecurityProfileService securityProfileService = new SecurityProfileService(mongoDbAccess, vitamCounterService, functionalBackupService);
            ContextServiceImpl contextService = new ContextServiceImpl(mongoDbAccess, vitamCounterService);
            securityProfileService.setContextService((ContextService)contextService);
            contextService.setSecurityProfileService(securityProfileService);
            ElasticsearchCustomSearchManager elasticsearchCustomSearchManager = new ElasticsearchCustomSearchManager(configuration, VitamConfiguration.getTenants());
            AgenciesService agenciesService = new AgenciesService(mongoDbAccess, vitamCounterService, functionalBackupService);
            OntologyServiceImpl ontologyService = new OntologyServiceImpl(mongoDbAccess, functionalBackupService);
            SchemaService schemaService = new SchemaService(configuration, mongoDbAccess, functionalBackupService, (OntologyService)ontologyService, elasticsearchCustomSearchManager);
            ArchiveUnitProfileServiceImpl archiveUnitProfileService = new ArchiveUnitProfileServiceImpl(mongoDbAccess, vitamCounterService, functionalBackupService);
            ArchiveUnitProfileSchemaServiceImpl archiveUnitProfileSchemaService = new ArchiveUnitProfileSchemaServiceImpl((ArchiveUnitProfileService)archiveUnitProfileService, schemaService);
            VitamRepositoryFactory vitamRepositoryProvider = VitamRepositoryFactory.get();
            this.singletons.add((Object)resource);
            this.singletons.add(new ArchiveUnitProfileResource((ArchiveUnitProfileService)archiveUnitProfileService));
            this.singletons.add(new ArchiveUnitProfileSchemaResource(archiveUnitProfileSchemaService));
            this.singletons.add(new OntologyResource((OntologyService)ontologyService));
            this.singletons.add(new ContractResource(mongoDbAccess, vitamCounterService));
            this.singletons.add(new ContextResource((ContextService)contextService));
            this.singletons.add(new SecurityProfileResource(securityProfileService));
            this.singletons.add(new AdminPublicConfigurationResource(configuration));
            this.singletons.add(new AgenciesResource(agenciesService));
            this.singletons.add(new ReindexationResource(indexManager));
            this.singletons.add(new EvidenceResource(mongoDbAccess, vitamCounterService));
            this.singletons.add(new ReconstructionResource(configuration, (VitamRepositoryProvider)vitamRepositoryProvider, (OntologyLoader)ontologyLoader, indexManager));
            this.singletons.add(new ProbativeValueResource());
            this.singletons.add(new ProfileResource(configuration, mongoDbAccess, vitamCounterService, functionalBackupService));
            PreservationScenarioService preservationScenarioService = new PreservationScenarioService(mongoDbAccess, functionalBackupService);
            GriffinService griffinService = new GriffinService(mongoDbAccess, functionalBackupService);
            PreservationResource griffinResource = new PreservationResource(preservationScenarioService, griffinService);
            this.singletons.add(griffinResource);
            this.singletons.add(new SchemaResource(schemaService));
        }
        catch (VitamException | IOException e) {
            throw new VitamRuntimeException(e);
        }
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

