/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.rest;

import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.core.archiveunitprofilesSchema.ArchiveUnitProfileSchemaServiceImpl;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/adminmanagement/v1")
@ApplicationPath(value="webresources")
@Tag(name="Functional-Administration")
public class ArchiveUnitProfileSchemaResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ArchiveUnitProfileSchemaResource.class);
    public static final String SCHEMA_ARCHIVE_UNIT_PROFILE_URI = "/archiveunitprofiles/{id}/schema";
    private final ArchiveUnitProfileSchemaServiceImpl archiveUnitProfileSchemaServiceImpl;

    public ArchiveUnitProfileSchemaResource(ArchiveUnitProfileSchemaServiceImpl archiveUnitProfileSchemaServiceImpl) {
        this.archiveUnitProfileSchemaServiceImpl = archiveUnitProfileSchemaServiceImpl;
    }

    @Path(value="/archiveunitprofiles/{id}/schema")
    @GET
    @Produces(value={"application/json"})
    public Response getArchiveUnitProfileSchema(@PathParam(value="id") String archiveUnitId) {
        try {
            LOGGER.info(" retrieving archive unit schema elements");
            List archiveUnitSchema = this.archiveUnitProfileSchemaServiceImpl.getCombinedSchemaModelsById(archiveUnitId);
            return Response.ok((Object)archiveUnitSchema).build();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | ReferentialException | IOException e) {
            LOGGER.error("Cannot retrieve unit schema ", e);
            return Response.serverError().build();
        }
    }
}

