/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.rest;

import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.configuration.PublicConfiguration;
import fr.gouv.vitam.functional.administration.common.config.AdminManagementConfiguration;
import fr.gouv.vitam.functional.administration.core.configuration.PublicConfigurationService;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/adminmanagement/v1")
@Tag(name="Functional-Administration")
public class AdminPublicConfigurationResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AdminPublicConfigurationResource.class);
    private static final String FUNCTIONAL_ADMINISTRATION_MODULE = "FUNCTIONAL_ADMINISTRATION_MODULE";
    private final PublicConfigurationService publicConfigurationService;

    public AdminPublicConfigurationResource(AdminManagementConfiguration adminManagementConfiguration) {
        this.publicConfigurationService = new PublicConfigurationService(adminManagementConfiguration);
    }

    @Path(value="/configuration")
    @GET
    @Produces(value={"application/json"})
    public Response getPublicConfiguration() {
        try {
            PublicConfiguration publicConfiguration = this.publicConfigurationService.getPublicConfiguration();
            return new RequestResponseOK().addResult((Object)publicConfiguration).setHttpCode(Response.Status.OK.getStatusCode()).toResponse();
        }
        catch (Exception e) {
            LOGGER.error("Unexpected server error", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), null)).build();
        }
    }

    private <T> VitamError<T> getErrorEntity(Response.Status status, String message, String code) {
        String aMessage = this.messageFromReason(status, message);
        String aCode = code != null ? code : String.valueOf(status.getStatusCode());
        return new VitamError(aCode).setHttpCode(status.getStatusCode()).setContext(FUNCTIONAL_ADMINISTRATION_MODULE).setState("code_vitam").setMessage(status.getReasonPhrase()).setDescription(aMessage);
    }

    private String messageFromReason(Response.Status status, String message) {
        return message != null && !message.trim().isEmpty() ? message : (status.getReasonPhrase() != null ? status.getReasonPhrase() : status.name());
    }
}

