/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.OntologyLoader;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InternalServerException;
import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.exception.WorkflowNotFoundException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.AuthenticationLevel;
import fr.gouv.vitam.common.model.DataMigrationBody;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.ProcessAction;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.AccessionRegisterDetailModel;
import fr.gouv.vitam.common.model.processing.WorkFlowExecutionContext;
import fr.gouv.vitam.common.security.rest.VitamAuthentication;
import fr.gouv.vitam.common.server.application.configuration.DbConfiguration;
import fr.gouv.vitam.common.server.application.configuration.DbConfigurationImpl;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.common.AccessionRegisterDetail;
import fr.gouv.vitam.functional.administration.common.config.AdminManagementConfiguration;
import fr.gouv.vitam.functional.administration.common.config.ElasticsearchFunctionalAdminIndexManager;
import fr.gouv.vitam.functional.administration.common.counter.VitamCounterService;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminFactory;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminImpl;
import fr.gouv.vitam.functional.administration.core.accession.register.ReferentialAccessionRegisterImpl;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.parameters.Contexts;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClient;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.ValidationException;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="/adminmanagement/v1")
@ApplicationPath(value="webresources")
@Tag(name="Functional-Administration")
public class AdminMigrationResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AdminMigrationResource.class);
    private final HashMap<Integer, String> xrequestIds;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;
    private final ProcessingManagementClientFactory processingManagementClientFactory;
    private final WorkspaceClientFactory workspaceClientFactory;
    private final AdminManagementConfiguration configuration;
    private final MongoDbAccessAdminImpl mongoAccess;
    private VitamCounterService vitamCounterService;
    private final MetaDataClientFactory metaDataClientFactory;

    AdminMigrationResource(AdminManagementConfiguration configuration, OntologyLoader ontologyLoader, ElasticsearchFunctionalAdminIndexManager indexManager) {
        this(LogbookOperationsClientFactory.getInstance(), ProcessingManagementClientFactory.getInstance(), WorkspaceClientFactory.getInstance((WorkFlowExecutionContext)WorkFlowExecutionContext.VITAM), configuration, ontologyLoader, indexManager);
    }

    @VisibleForTesting
    public AdminMigrationResource(LogbookOperationsClientFactory logbookOperationsClientFactory, ProcessingManagementClientFactory processingManagementClientFactory, WorkspaceClientFactory workspaceClientFactory, AdminManagementConfiguration configuration, OntologyLoader ontologyLoader, ElasticsearchFunctionalAdminIndexManager indexManager) {
        this.configuration = configuration;
        DbConfigurationImpl adminConfiguration = configuration.isDbAuthentication() ? new DbConfigurationImpl(configuration.getMongoDbNodes(), configuration.getDbName(), true, configuration.getDbUserName(), configuration.getDbPassword()) : new DbConfigurationImpl(configuration.getMongoDbNodes(), configuration.getDbName());
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
        this.processingManagementClientFactory = processingManagementClientFactory;
        this.workspaceClientFactory = workspaceClientFactory;
        this.xrequestIds = new HashMap();
        this.mongoAccess = MongoDbAccessAdminFactory.create((DbConfiguration)adminConfiguration, (OntologyLoader)ontologyLoader, (ElasticsearchFunctionalAdminIndexManager)indexManager);
        this.metaDataClientFactory = MetaDataClientFactory.getInstance();
    }

    @POST
    @Path(value="/startMigration")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @VitamAuthentication(authentLevel=AuthenticationLevel.BASIC_AUTHENT)
    public Response start(@Context HttpHeaders headers) {
        this.xrequestIds.clear();
        VitamConfiguration.getTenants().forEach(integer -> this.xrequestIds.put((Integer)integer, GUIDFactory.newGUID().getId()));
        for (Map.Entry<Integer, String> entry : this.xrequestIds.entrySet()) {
            VitamThreadUtils.getVitamSession().setRequestId(entry.getValue());
            VitamThreadUtils.getVitamSession().setTenantId(entry.getKey());
            this.migrateTo(entry.getKey());
        }
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity(this.xrequestIds).build();
    }

    @HEAD
    @Path(value="/migrationStatus")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @VitamAuthentication(authentLevel=AuthenticationLevel.BASIC_AUTHENT)
    public Response check() {
        ProcessingManagementClient processingManagementClient = this.processingManagementClientFactory.getClient();
        if (this.xrequestIds.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        for (Map.Entry<Integer, String> entry : this.xrequestIds.entrySet()) {
            VitamThreadUtils.getVitamSession().setTenantId(entry.getKey());
            try {
                boolean isProcessPauseFatal;
                ItemStatus operationProcessStatus = processingManagementClient.getOperationProcessStatus(entry.getValue());
                boolean isProcessFinished = operationProcessStatus.getGlobalState().equals((Object)ProcessState.COMPLETED);
                boolean bl = isProcessPauseFatal = operationProcessStatus.getGlobalState().equals((Object)ProcessState.PAUSE) && StatusCode.FATAL.equals((Object)operationProcessStatus.getGlobalStatus());
                if (isProcessFinished || isProcessPauseFatal) continue;
                return Response.status((Response.Status)Response.Status.ACCEPTED).build();
            }
            catch (WorkflowNotFoundException e) {
                LOGGER.warn("Could not find process '" + entry.getValue() + "'. Cleaned Process ?", (Throwable)e);
            }
            catch (VitamException e) {
                LOGGER.error("Could not check process status " + entry.getValue(), (Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Path(value="collectionMigration")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response migrateCollection(DataMigrationBody dataMigrationBody) {
        try {
            this.validateDataMigrationBody(dataMigrationBody);
        }
        catch (ValidationException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage())).build();
        }
        if (FunctionalAdminCollections.ACCESSION_REGISTER_DETAIL.getName().equals(dataMigrationBody.getCollection()) && this.authorizedFieldsForCollection(AccessionRegisterDetail.AUTHORIZED_FIELDS_TO_UPDATE, dataMigrationBody.getFields())) {
            return this.migrateAccessionRegisterDetails(dataMigrationBody);
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorEntity(Response.Status.BAD_REQUEST, "Incorrect body fields! Data migration has been aborted !")).build();
    }

    private boolean authorizedFieldsForCollection(List<String> authorizedFieldsToUpdate, List<String> fields) {
        return authorizedFieldsToUpdate.containsAll(fields);
    }

    private Response migrateAccessionRegisterDetails(DataMigrationBody dataMigrationBody) {
        Response response;
        AccessionRegisterDetailModel accessionRegister = (AccessionRegisterDetailModel)JsonHandler.getFromJsonNode((JsonNode)dataMigrationBody.getModel(), AccessionRegisterDetailModel.class);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("register ID / Originating Agency: " + accessionRegister.getId() + " / " + accessionRegister.getOriginatingAgency());
        }
        ParametersChecker.checkParameter((String)"Accession Register is a mandatory parameter", (Object[])new Object[]{accessionRegister});
        if (accessionRegister.getTenant() == null) {
            throw new ValidationException(String.format("The Tenant of the document's ID : %s is not setted !", accessionRegister.getId()));
        }
        VitamThreadUtils.getVitamSession().setTenantId(accessionRegister.getTenant());
        ReferentialAccessionRegisterImpl accessionRegisterManagement = new ReferentialAccessionRegisterImpl(this.mongoAccess, this.vitamCounterService, this.metaDataClientFactory, this.configuration);
        try {
            accessionRegisterManagement.migrateAccessionRegister(accessionRegister, dataMigrationBody.getFields());
            response = Response.status((Response.Status)Response.Status.CREATED).build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    try {
                        accessionRegisterManagement.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (BadRequestException e) {
                    LOGGER.error((Throwable)e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorEntity(Response.Status.BAD_REQUEST, e.getMessage())).build();
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage())).build();
                }
            }
            catch (InvalidParseOperationException e) {
                LOGGER.error((Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage())).build();
            }
        }
        accessionRegisterManagement.close();
        return response;
    }

    private void validateDataMigrationBody(DataMigrationBody dataMigrationBody) throws ValidationException {
        if (StringUtils.isBlank((String)dataMigrationBody.getCollection())) {
            throw new ValidationException("Collection name is empty !");
        }
        if (dataMigrationBody.getFields() == null || dataMigrationBody.getFields().isEmpty()) {
            throw new ValidationException("Fields are empty !");
        }
        if (JsonHandler.isNullOrEmpty((JsonNode)dataMigrationBody.getModel())) {
            throw new ValidationException("Model is empty !");
        }
    }

    private void migrateTo(Integer tenant) {
        ParametersChecker.checkParameter((String)"TenantId is mandatory", (Object[])new Object[]{tenant});
        String requestId = VitamThreadUtils.getVitamSession().getRequestId();
        try (ProcessingManagementClient processingClient = this.processingManagementClientFactory.getClient();
             WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
            GUID guid = GUIDReader.getGUID((String)requestId);
            VitamThreadUtils.getVitamSession().setRequestId(guid.getId());
            this.createOperation(guid);
            workspaceClient.createContainer(guid.getId());
            processingClient.initVitamProcess(guid.getId(), Contexts.DATA_MIGRATION.name());
            RequestResponse jsonNodeRequestResponse = processingClient.executeOperationProcess(guid.getId(), Contexts.DATA_MIGRATION.name(), ProcessAction.RESUME.getValue());
            jsonNodeRequestResponse.toResponse();
        }
        catch (BadRequestException | LogbookClientBadRequestException e) {
            LOGGER.error(e);
            Response.status((Response.Status)Response.Status.BAD_REQUEST).header("X-Request-Id", (Object)requestId).build();
        }
        catch (InternalServerException | InvalidGuidOperationException | VitamClientException | ContentAddressableStorageServerException e) {
            LOGGER.error(e);
            Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).header("X-Request-Id", (Object)requestId).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage())).build();
        }
    }

    private VitamError getErrorEntity(Response.Status status, String message) {
        String aMessage = message != null && !message.trim().isEmpty() ? message : (status.getReasonPhrase() != null ? status.getReasonPhrase() : status.name());
        return new VitamError(status.name()).setHttpCode(status.getStatusCode()).setMessage(status.getReasonPhrase()).setDescription(aMessage);
    }

    private void createOperation(GUID guid) throws LogbookClientBadRequestException {
        try (LogbookOperationsClient client = this.logbookOperationsClientFactory.getClient();){
            LogbookOperationParameters initParameter = LogbookParameterHelper.newLogbookOperationParameters((GUID)guid, (String)Contexts.DATA_MIGRATION.name(), (GUID)guid, (LogbookTypeProcess)LogbookTypeProcess.DATA_MIGRATION, (StatusCode)StatusCode.STARTED, (String)(VitamLogbookMessages.getLabelOp((String)String.format("%s.%s", Contexts.DATA_MIGRATION.name(), StatusCode.STARTED.name())) + " : " + String.valueOf(guid)), (GUID)guid);
            client.create(new LogbookOperationParameters[]{initParameter});
        }
        catch (LogbookClientAlreadyExistsException | LogbookClientServerException e) {
            throw new VitamRuntimeException("Internal server error ", e);
        }
    }
}

