/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Iterables;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.OntologyLoader;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.parser.request.adapter.SingleVarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.parser.request.single.SelectParserSingle;
import fr.gouv.vitam.common.database.utils.AccessContractRestrictionHelper;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.AccessUnauthorizedException;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.AuditOptions;
import fr.gouv.vitam.common.model.ProcessAction;
import fr.gouv.vitam.common.model.ProcessPause;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.VitamSession;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.model.administration.AccessionRegisterDetailModel;
import fr.gouv.vitam.common.model.administration.ActivationStatus;
import fr.gouv.vitam.common.model.administration.FileRulesModel;
import fr.gouv.vitam.common.model.audit.AuditReferentialOptions;
import fr.gouv.vitam.common.model.processing.WorkFlowExecutionContext;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.server.application.configuration.DbConfiguration;
import fr.gouv.vitam.common.server.application.configuration.DbConfigurationImpl;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.common.server.application.resources.BasicVitamStatusServiceImpl;
import fr.gouv.vitam.common.server.application.resources.VitamStatusService;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.common.stream.VitamAsyncInputStreamResponse;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.common.AccessionRegisterSummary;
import fr.gouv.vitam.functional.administration.common.ErrorReport;
import fr.gouv.vitam.functional.administration.common.FileFormat;
import fr.gouv.vitam.functional.administration.common.FileRules;
import fr.gouv.vitam.functional.administration.common.config.AdminManagementConfiguration;
import fr.gouv.vitam.functional.administration.common.config.ElasticsearchFunctionalAdminIndexManager;
import fr.gouv.vitam.functional.administration.common.counter.VitamCounterService;
import fr.gouv.vitam.functional.administration.common.exception.AuditVitamException;
import fr.gouv.vitam.functional.administration.common.exception.DatabaseConflictException;
import fr.gouv.vitam.functional.administration.common.exception.FileRulesCsvException;
import fr.gouv.vitam.functional.administration.common.exception.FileRulesDeleteException;
import fr.gouv.vitam.functional.administration.common.exception.FileRulesException;
import fr.gouv.vitam.functional.administration.common.exception.FileRulesIllegalDurationModeUpdateException;
import fr.gouv.vitam.functional.administration.common.exception.FileRulesReadException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialImportInProgressException;
import fr.gouv.vitam.functional.administration.common.server.ElasticsearchAccessAdminFactory;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminFactory;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminImpl;
import fr.gouv.vitam.functional.administration.core.accession.register.ReferentialAccessionRegisterImpl;
import fr.gouv.vitam.functional.administration.core.audit.ReferentialAuditService;
import fr.gouv.vitam.functional.administration.core.contract.AccessContractImpl;
import fr.gouv.vitam.functional.administration.core.format.ReferentialFormatFileImpl;
import fr.gouv.vitam.functional.administration.core.rules.RuleImportResultSet;
import fr.gouv.vitam.functional.administration.core.rules.RulesManagerFileImpl;
import fr.gouv.vitam.functional.administration.core.rules.VitamRuleService;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.parameters.Contexts;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.ProcessingEntry;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.engine.core.operation.OperationContextModel;
import fr.gouv.vitam.processing.engine.core.operation.OperationContextMonitor;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClient;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageUnavailableDataFromAsyncOfferClientException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.StringUtils;

@Path(value="/adminmanagement/v1")
@ApplicationPath(value="webresources")
@Tag(name="Functional-Administration")
public class AdminManagementResource
extends ApplicationStatusResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AdminManagementResource.class);
    private static final SingleVarNameAdapter DEFAULT_VARNAME_ADAPTER = new SingleVarNameAdapter();
    private static final String FUNCTIONAL_ADMINISTRATION_MODULE = "FUNCTIONAL_ADMINISTRATION_MODULE";
    private static final String ATTACHMENT_FILENAME = "attachment; filename=ErrorReport.json";
    private static final String SELECT_IS_A_MANDATORY_PARAMETER = "select is a mandatory parameter";
    private static final String AUDIT_URI = "/audit";
    private static final String AUDIT_RULE_URI = "/auditRule";
    private static final String REFERENTIAL_AUDIT_URI = "/audit/referential";
    private static final String OPERATIONS_PATH = "logbookoperations";
    private static final String OPTIONS_IS_MANDATORY_PARAMETER = "The json option is mandatory";
    private static final String ORIGINATING_AGENCY = "OriginatingAgency";
    private static final String ACCESS_CONTRACT = "AccessContract";
    private static final String AUDIT_TYPE = "auditType";
    private static final String OBJECT_ID = "objectId";
    private static final String AUDIT_ACTIONS = "auditActions";
    private final MongoDbAccessAdminImpl mongoAccess;
    private final AdminManagementConfiguration configuration;
    private VitamCounterService vitamCounterService;
    private final WorkspaceClientFactory workspaceClientFactory;
    private final ProcessingManagementClientFactory processingManagementClientFactory;
    private final MetaDataClientFactory metaDataClientFactory;
    private final StorageClientFactory storageClientFactory;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;
    private final VitamRuleService vitamRuleService;

    public AdminManagementResource(AdminManagementConfiguration configuration, OntologyLoader ontologyLoader, ElasticsearchFunctionalAdminIndexManager indexManager) {
        super((VitamStatusService)new BasicVitamStatusServiceImpl());
        this.configuration = configuration;
        DbConfigurationImpl adminConfiguration = configuration.isDbAuthentication() ? new DbConfigurationImpl(configuration.getMongoDbNodes(), configuration.getDbName(), true, configuration.getDbUserName(), configuration.getDbPassword()) : new DbConfigurationImpl(configuration.getMongoDbNodes(), configuration.getDbName());
        this.workspaceClientFactory = WorkspaceClientFactory.getInstance((WorkFlowExecutionContext)WorkFlowExecutionContext.VITAM);
        this.processingManagementClientFactory = ProcessingManagementClientFactory.getInstance();
        this.logbookOperationsClientFactory = LogbookOperationsClientFactory.getInstance();
        this.metaDataClientFactory = MetaDataClientFactory.getInstance();
        this.storageClientFactory = StorageClientFactory.getInstance();
        this.mongoAccess = MongoDbAccessAdminFactory.create((DbConfiguration)adminConfiguration, (OntologyLoader)ontologyLoader, (ElasticsearchFunctionalAdminIndexManager)indexManager);
        this.vitamRuleService = new VitamRuleService(configuration.getListMinimumRuleDuration());
        WorkspaceClientFactory.changeMode((String)configuration.getWorkspaceUrl(), (WorkFlowExecutionContext)WorkFlowExecutionContext.VITAM);
        ProcessingManagementClientFactory.changeConfigurationUrl((String)configuration.getProcessingUrl());
        ElasticsearchAccessAdminFactory.create((AdminManagementConfiguration)configuration, (ElasticsearchFunctionalAdminIndexManager)indexManager);
        LOGGER.debug("init Admin Management Resource server");
    }

    MongoDbAccessAdminImpl getLogbookDbAccess() {
        return this.mongoAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="format/check")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    public Response checkFormat(InputStream xmlPronom) {
        ParametersChecker.checkParameter((String)"xmlPronom is a mandatory parameter", (Object[])new Object[]{xmlPronom});
        try {
            Response response;
            ReferentialFormatFileImpl formatManagement = new ReferentialFormatFileImpl(this.mongoAccess, this.vitamCounterService);
            try {
                formatManagement.checkFile(xmlPronom);
                response = Response.status((Response.Status)Response.Status.OK).build();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        formatManagement.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    Response response2 = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
                    return response2;
                }
            }
            formatManagement.close();
            return response;
        }
        finally {
            StreamUtils.closeSilently((InputStream)xmlPronom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="format/import")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    public Response importFormat(@Context HttpHeaders headers, InputStream xmlPronom) {
        ParametersChecker.checkParameter((String)"xmlPronom is a mandatory parameter", (Object[])new Object[]{xmlPronom});
        String filename = headers.getHeaderString("X-Filename");
        try {
            Response response;
            ReferentialFormatFileImpl formatManagement = new ReferentialFormatFileImpl(this.mongoAccess, this.vitamCounterService);
            try {
                formatManagement.importFile(xmlPronom, filename);
                response = Response.status((Response.Status)Response.Status.CREATED).entity((Object)Response.Status.CREATED.getReasonPhrase()).build();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        formatManagement.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    Response response2 = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
                    return response2;
                }
                catch (DatabaseConflictException e) {
                    LOGGER.error((Throwable)e);
                    Response response3 = Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e.getMessage()).build();
                    return response3;
                }
                catch (VitamException e) {
                    LOGGER.error((Throwable)e);
                    Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)Response.Status.INTERNAL_SERVER_ERROR).build();
                    return response4;
                }
            }
            formatManagement.close();
            return response;
        }
        finally {
            StreamUtils.closeSilently((InputStream)xmlPronom);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="format/{id_format:.+}")
    @Produces(value={"application/json"})
    public Response findFileFormatByID(@PathParam(value="id_format") String formatId, @Context Request request) {
        ParametersChecker.checkParameter((String)"formatId is a mandatory parameter", (String[])new String[]{formatId});
        try (ReferentialFormatFileImpl formatManagement = new ReferentialFormatFileImpl(this.mongoAccess, this.vitamCounterService);){
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)formatId));
            FileFormat fileFormat = formatManagement.findDocumentById(formatId);
            if (fileFormat == null) {
                LOGGER.error("NO DATA for the specified formatId '" + formatId + "'");
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.getErrorEntity(Response.Status.NOT_FOUND, "Format not found")).build();
                return response;
            }
            CacheControl cacheControl = new CacheControl();
            cacheControl.setMaxAge(VitamConfiguration.getCacheControlDelay());
            cacheControl.setPrivate(false);
            EntityTag etag = new EntityTag(Integer.toString(fileFormat.hashCode()));
            Response.ResponseBuilder builder = request.evaluatePreconditions(etag);
            if (builder == null) {
                Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)new RequestResponseOK().addResult((Object)JsonHandler.toJsonNode((Object)fileFormat)).setHttpCode(Response.Status.OK.getStatusCode())).tag(etag).cacheControl(cacheControl).build();
                return response;
            }
            Response response = builder.cacheControl(cacheControl).tag(etag).build();
            return response;
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage())).build();
        }
    }

    @Path(value="format/document")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response findFormats(JsonNode select) {
        Response response;
        ParametersChecker.checkParameter((String)SELECT_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{select});
        ReferentialFormatFileImpl formatManagement = new ReferentialFormatFileImpl(this.mongoAccess, this.vitamCounterService);
        try {
            SanityChecker.checkJsonAll((JsonNode)select);
            RequestResponseOK fileFormatList = formatManagement.findDocuments(select).setQuery(select);
            response = Response.status((Response.Status)Response.Status.OK).entity((Object)fileFormatList).build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    formatManagement.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (InvalidParseOperationException e) {
                LOGGER.error((Throwable)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorEntity(Response.Status.BAD_REQUEST, e.getMessage())).build();
            }
            catch (ReferentialException e) {
                LOGGER.error((Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage())).build();
            }
        }
        formatManagement.close();
        return response;
    }

    @Path(value="rules/check")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/octet-stream"})
    public Response checkRulesFile(InputStream rulesStream) {
        ParametersChecker.checkParameter((String)"rulesStream is a mandatory parameter", (Object[])new Object[]{rulesStream});
        RulesManagerFileImpl rulesManagerFileImpl = new RulesManagerFileImpl(this.mongoAccess, this.vitamCounterService, this.vitamRuleService, this.configuration.getRuleAuditThreadPoolSize().intValue());
        try {
            Map rulesFromFile = rulesManagerFileImpl.getRulesFromCSV(rulesStream);
            RuleImportResultSet ruleImportResultSet = rulesManagerFileImpl.checkFile(rulesFromFile);
            StatusCode statusCode = ruleImportResultSet.getUsedUpdateRulesForUpdateUnit().isEmpty() ? StatusCode.OK : StatusCode.WARNING;
            InputStream errorReportInputStream = rulesManagerFileImpl.generateReportContent(Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), ruleImportResultSet.getUsedRulesToUpdate(), ruleImportResultSet.getUnusedRulesToDelete(), ruleImportResultSet.getRulesToUpdate(), ruleImportResultSet.getRulesToInsert(), statusCode, null);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/octet-stream");
            headers.put("Content-Disposition", ATTACHMENT_FILENAME);
            return new VitamAsyncInputStreamResponse(errorReportInputStream, Response.Status.OK, headers);
        }
        catch (FileRulesReadException e) {
            LOGGER.error("Format / syntax error while checking file ", (Throwable)e);
            return this.handleGenerateReport(rulesManagerFileImpl, e.getErrorsMap(), Collections.emptyList(), Collections.emptyList());
        }
        catch (FileRulesDeleteException e) {
            LOGGER.error("Consistency error - Cannot delete used rule ", (Throwable)e);
            return this.handleGenerateReport(rulesManagerFileImpl, Collections.emptyMap(), e.getUsedDeletedRules(), Collections.emptyList());
        }
        catch (FileRulesIllegalDurationModeUpdateException e) {
            LOGGER.error("Consistency error - Cannot switch used rle duration mode", (Throwable)e);
            return this.handleGenerateReport(rulesManagerFileImpl, Collections.emptyMap(), Collections.emptyList(), e.getUsedRulesWithDurationModeUpdate());
        }
        catch (Exception e) {
            LOGGER.error("Error while checking file ", (Throwable)e);
            return this.handleGenerateReport(rulesManagerFileImpl, Collections.emptyMap(), Collections.emptyList(), Collections.emptyList());
        }
    }

    private Response handleGenerateReport(RulesManagerFileImpl rulesManagerFileImpl, Map<Integer, List<ErrorReport>> errors, List<FileRulesModel> usedDeletedRules, List<FileRulesModel> usedUpdatedRulesWithIllegalDurationModeSwitch) {
        InputStream errorReportInputStream = rulesManagerFileImpl.generateReportContent(errors, usedDeletedRules, usedUpdatedRulesWithIllegalDurationModeSwitch, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), StatusCode.KO, null);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/octet-stream");
        headers.put("Content-Disposition", ATTACHMENT_FILENAME);
        return new VitamAsyncInputStreamResponse(errorReportInputStream, Response.Status.BAD_REQUEST, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="rules/import")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    public Response importRulesFile(@Context HttpHeaders headers, InputStream rulesStream) {
        ParametersChecker.checkParameter((String)"rulesStream is a mandatory parameter", (Object[])new Object[]{rulesStream});
        String filename = headers.getHeaderString("X-Filename");
        try {
            RulesManagerFileImpl rulesFileManagement = new RulesManagerFileImpl(this.mongoAccess, this.vitamCounterService, this.vitamRuleService, this.configuration.getRuleAuditThreadPoolSize().intValue());
            rulesFileManagement.importFile(rulesStream, filename);
            Response response = Response.status((Response.Status)Response.Status.CREATED).entity((Object)Response.Status.CREATED.getReasonPhrase()).build();
            return response;
        }
        catch (ReferentialImportInProgressException e) {
            LOGGER.warn((Throwable)e);
            Response response = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)e.getMessage()).build();
            return response;
        }
        catch (FileRulesCsvException | FileRulesException e) {
            LOGGER.error(e);
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
            return response;
        }
        catch (ReferentialException e) {
            LOGGER.error((Throwable)e);
            Response response = Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e.getMessage()).build();
            return response;
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()).build();
            return response;
        }
        finally {
            StreamUtils.closeSilently((InputStream)rulesStream);
        }
    }

    @GET
    @Path(value="rules/{id_rule}")
    @Produces(value={"application/json"})
    public Response findRuleByID(@PathParam(value="id_rule") String ruleId, @Context Request request) {
        ParametersChecker.checkParameter((String)"ruleId is a mandatory parameter", (String[])new String[]{ruleId});
        try {
            RulesManagerFileImpl rulesFileManagement = new RulesManagerFileImpl(this.mongoAccess, this.vitamCounterService, this.vitamRuleService, this.configuration.getRuleAuditThreadPoolSize().intValue());
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)ruleId));
            FileRules fileRules = rulesFileManagement.findDocumentById(ruleId);
            if (fileRules == null) {
                LOGGER.error("NO DATA for the specified rule Value or More than one records exists '" + ruleId + "'");
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.getErrorEntity(Response.Status.NOT_FOUND, "Rule not found")).build();
            }
            CacheControl cacheControl = new CacheControl();
            cacheControl.setMaxAge(VitamConfiguration.getCacheControlDelay());
            cacheControl.setPrivate(false);
            EntityTag etag = new EntityTag(Integer.toString(fileRules.hashCode()));
            Response.ResponseBuilder builder = request.evaluatePreconditions(etag);
            if (builder == null) {
                return Response.status((Response.Status)Response.Status.OK).entity((Object)new RequestResponseOK().addResult((Object)JsonHandler.toJsonNode((Object)fileRules)).setHttpCode(Response.Status.OK.getStatusCode())).tag(etag).cacheControl(cacheControl).build();
            }
            return builder.cacheControl(cacheControl).tag(etag).build();
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage())).build();
        }
    }

    @Path(value="rules/document")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response findDocumentRules(JsonNode select) {
        ParametersChecker.checkParameter((String)SELECT_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{select});
        try {
            RulesManagerFileImpl rulesFileManagement = new RulesManagerFileImpl(this.mongoAccess, this.vitamCounterService, this.vitamRuleService, this.configuration.getRuleAuditThreadPoolSize().intValue());
            SanityChecker.checkJsonAll((JsonNode)select);
            RequestResponseOK filerulesList = rulesFileManagement.findDocuments(select).setQuery(select);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)filerulesList).build();
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorEntity(Response.Status.BAD_REQUEST, e.getMessage())).build();
        }
        catch (ReferentialException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage())).build();
        }
    }

    @Path(value="accession-register")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createAccessionRegister(AccessionRegisterDetailModel accessionRegister) {
        Response response;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("register ID / Originating Agency: " + accessionRegister.getId() + " / " + accessionRegister.getOriginatingAgency());
        }
        ParametersChecker.checkParameter((String)"Accession Register is a mandatory parameter", (Object[])new Object[]{accessionRegister});
        ReferentialAccessionRegisterImpl accessionRegisterManagement = new ReferentialAccessionRegisterImpl(this.mongoAccess, this.vitamCounterService, this.metaDataClientFactory, this.configuration);
        try {
            accessionRegisterManagement.createOrUpdateAccessionRegister(accessionRegister);
            response = Response.status((Response.Status)Response.Status.CREATED).build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    accessionRegisterManagement.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (BadRequestException e) {
                LOGGER.error((Throwable)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorEntity(Response.Status.BAD_REQUEST, e.getMessage())).build();
            }
            catch (ReferentialException e) {
                LOGGER.error((Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage())).build();
            }
        }
        accessionRegisterManagement.close();
        return response;
    }

    @Path(value="accession-register/document")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response findDocumentFundsRegister(JsonNode select) {
        RequestResponseOK<AccessionRegisterSummary> fileFundRegisters;
        ParametersChecker.checkParameter((String)SELECT_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{select});
        try {
            fileFundRegisters = this.findFundRegisters(select);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorEntity(Response.Status.BAD_REQUEST, e.getMessage())).build();
        }
        catch (AccessUnauthorizedException e) {
            LOGGER.error("Access contract does not allow ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.getErrorEntity(Response.Status.UNAUTHORIZED, e.getMessage())).build();
        }
        catch (InvalidCreateOperationException | ReferentialException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage())).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity(fileFundRegisters).build();
    }

    private RequestResponseOK<AccessionRegisterSummary> findFundRegisters(JsonNode select) throws InvalidParseOperationException, AccessUnauthorizedException, InvalidCreateOperationException, ReferentialException {
        try (ReferentialAccessionRegisterImpl accessionRegisterManagement = new ReferentialAccessionRegisterImpl(this.mongoAccess, this.vitamCounterService, this.metaDataClientFactory, this.configuration);){
            RequestResponseOK fileFundRegisters;
            SanityChecker.checkJsonAll((JsonNode)select);
            if (StringUtils.isBlank((CharSequence)VitamThreadUtils.getVitamSession().getContractId())) {
                throw new AccessUnauthorizedException("No contract chosen");
            }
            AccessContractModel contract = this.getContractDetails(VitamThreadUtils.getVitamSession().getContractId());
            if (contract == null) {
                throw new AccessUnauthorizedException("Contract Not Found");
            }
            boolean isEveryOriginatingAgency = contract.getEveryOriginatingAgency();
            Set prodServices = contract.getOriginatingAgencies();
            SelectParserSingle parser = new SelectParserSingle((VarNameAdapter)DEFAULT_VARNAME_ADAPTER);
            parser.parse(select);
            if (!isEveryOriginatingAgency) {
                parser.addCondition((Query)QueryHelper.in((String)ORIGINATING_AGENCY, (String[])prodServices.toArray(new String[0])));
            }
            RequestResponseOK requestResponseOK = fileFundRegisters = accessionRegisterManagement.findDocuments((JsonNode)parser.getRequest().getFinalSelect()).setQuery(select);
            return requestResponseOK;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Path(value="accession-register/detail/{id}")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response findDetailAccessionRegister(@PathParam(value="id") String originatingAgency, JsonNode select) {
        ParametersChecker.checkParameter((String)SELECT_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{select});
        try (ReferentialAccessionRegisterImpl accessionRegisterManagement = new ReferentialAccessionRegisterImpl(this.mongoAccess, this.vitamCounterService, this.metaDataClientFactory, this.configuration);){
            SanityChecker.checkJsonAll((JsonNode)select);
            SanityChecker.checkParameter((String[])new String[]{originatingAgency});
            SelectParserSingle parser = new SelectParserSingle((VarNameAdapter)DEFAULT_VARNAME_ADAPTER);
            parser.parse(select);
            AccessContractModel contract = this.getContractDetails(VitamThreadUtils.getVitamSession().getContractId());
            if (contract == null) {
                throw new AccessUnauthorizedException("Contract Not Found");
            }
            Boolean isEveryOriginatingAgency = contract.getEveryOriginatingAgency();
            Set prodServices = contract.getOriginatingAgencies();
            if (!isEveryOriginatingAgency.booleanValue() && !prodServices.contains(originatingAgency)) {
                Response response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.getErrorEntity(Response.Status.UNAUTHORIZED, "Unauthorized")).build();
                return response;
            }
            if (!isEveryOriginatingAgency.booleanValue()) {
                parser.addCondition(QueryHelper.in((String)ORIGINATING_AGENCY, (String[])prodServices.toArray(new String[0])).setDepthLimit(0));
            }
            parser.addCondition((Query)QueryHelper.eq((String)ORIGINATING_AGENCY, (String)URLDecoder.decode(originatingAgency, StandardCharsets.UTF_8)));
            RequestResponseOK accessionRegisterDetails = accessionRegisterManagement.findDetail((JsonNode)parser.getRequest().getFinalSelect()).setQuery(select);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)accessionRegisterDetails).build();
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorEntity(Response.Status.BAD_REQUEST, e.getMessage())).build();
        }
        catch (InvalidCreateOperationException | AccessUnauthorizedException | ReferentialException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage())).build();
        }
    }

    @Path(value="accession-register/detail")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response findDetailAccessionRegister(JsonNode select) {
        RequestResponseOK accessionRegisterDetails;
        ParametersChecker.checkParameter((String)SELECT_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{select});
        try (ReferentialAccessionRegisterImpl accessionRegisterManagement = new ReferentialAccessionRegisterImpl(this.mongoAccess, this.vitamCounterService, this.metaDataClientFactory, this.configuration);){
            SanityChecker.checkJsonAll((JsonNode)select);
            SelectParserSingle parser = new SelectParserSingle((VarNameAdapter)DEFAULT_VARNAME_ADAPTER);
            parser.parse(select);
            accessionRegisterDetails = accessionRegisterManagement.findDetail((JsonNode)parser.getRequest().getFinalSelect()).setQuery(select);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorEntity(Response.Status.BAD_REQUEST, e.getMessage())).build();
        }
        catch (ReferentialException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage())).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)accessionRegisterDetails).build();
    }

    @Path(value="/audit/referential")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response launchReferentialAudit(AuditReferentialOptions referentialAuditOptions) {
        int tenant = VitamThreadUtils.getVitamSession().getTenantId();
        ReferentialAuditService referentialAuditService = new ReferentialAuditService(this.storageClientFactory, this.vitamCounterService);
        try {
            referentialAuditService.runAudit(referentialAuditOptions.getCollectionName(), tenant);
        }
        catch (InvalidParseOperationException | StorageNotFoundClientException | StorageServerClientException | StorageUnavailableDataFromAsyncOfferClientException | StorageNotFoundException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getLocalizedMessage())).build();
        }
        catch (BadRequestException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorEntity(Response.Status.BAD_REQUEST, e.getLocalizedMessage())).build();
        }
        catch (AuditVitamException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)this.getErrorEntity(Response.Status.CONFLICT, e.getLocalizedMessage())).build();
        }
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)new RequestResponseOK()).build();
    }

    @Path(value="/auditRule")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response launchRuleAudit(List<Integer> tenants) {
        Response response = this.checkMultiTenantRequest(tenants);
        if (response != null) {
            return response;
        }
        try {
            RulesManagerFileImpl rulesManagerFileImpl = new RulesManagerFileImpl(this.mongoAccess, this.vitamCounterService, this.vitamRuleService, this.configuration.getRuleAuditThreadPoolSize().intValue());
            rulesManagerFileImpl.checkRuleConformity(tenants);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getLocalizedMessage())).build();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Path(value="/audit")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response launchAudit(AuditOptions options, @HeaderParam(value="Check-Access-Contract") boolean checkAccessContract) {
        ParametersChecker.checkParameter((String)OPTIONS_IS_MANDATORY_PARAMETER, (Object[])new Object[]{options});
        try (ProcessingManagementClient processingClient = this.processingManagementClientFactory.getClient();){
            Response response;
            block23: {
                WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();
                try {
                    int tenantId = VitamThreadUtils.getVitamSession().getTenantId();
                    String operationId = VitamThreadUtils.getVitamSession().getRequestId();
                    AccessContractModel contract = null;
                    if (checkAccessContract && (contract = this.getContractDetails(VitamThreadUtils.getVitamSession().getContractId())) == null) {
                        throw new AccessUnauthorizedException("Contract Not Found");
                    }
                    this.validateAuditOptions(options, tenantId);
                    ProcessingEntry entry = new ProcessingEntry(operationId, Contexts.AUDIT_WORKFLOW.name());
                    entry.getExtraParams().put(AUDIT_TYPE, options.getAuditType());
                    entry.getExtraParams().put(OBJECT_ID, options.getObjectId());
                    entry.getExtraParams().put(AUDIT_ACTIONS, options.getAuditActions());
                    workspaceClient.createContainer(operationId);
                    this.createAuditLogbookOperation(operationId, contract);
                    SelectMultiQuery selectQuery = new SelectMultiQuery();
                    if ("tenant".equals(options.getAuditType())) {
                        selectQuery.setQuery((Query)QueryHelper.eq((String)BuilderToken.PROJECTIONARGS.TENANT.exactToken(), (String)options.getObjectId()));
                        LOGGER.warn("this audit type is no longer supported for audit action. Use dsl query instead");
                    } else if ("originatingagency".equals(options.getAuditType())) {
                        selectQuery.setQuery((Query)QueryHelper.in((String)BuilderToken.PROJECTIONARGS.ORIGINATING_AGENCY.exactToken(), (String[])new String[]{options.getObjectId()}));
                        LOGGER.warn("this audit type is no longer supported for audit action. Use dsl query instead");
                    } else if ("dsl".equals(options.getAuditType())) {
                        SelectParserMultiple parser = new SelectParserMultiple();
                        parser.parse(options.getQuery().deepCopy());
                        selectQuery = parser.getRequest();
                    }
                    if (checkAccessContract) {
                        JsonNode restrictedQuery = AccessContractRestrictionHelper.applyAccessContractRestrictionForObjectGroupForSelect((JsonNode)selectQuery.getFinalSelect(), (AccessContractModel)contract);
                        workspaceClient.putObject(operationId, "query.json", JsonHandler.writeToInpustream((Object)restrictedQuery));
                    } else {
                        workspaceClient.putObject(operationId, "scheduler_audit", JsonHandler.writeToInpustream((Object)JsonHandler.createObjectNode()));
                        workspaceClient.putObject(operationId, "query.json", JsonHandler.writeToInpustream((Object)selectQuery.getFinalSelect()));
                    }
                    workspaceClient.putObject(operationId, "operation_context.json", JsonHandler.writeToInpustream((Object)OperationContextModel.get((Object)options)));
                    OperationContextMonitor.compressInWorkspace((WorkspaceClientFactory)this.workspaceClientFactory, (String)operationId, (LogbookTypeProcess)Contexts.AUDIT_WORKFLOW.getLogbookTypeProcess(), (String[])new String[]{"operation_context.json"});
                    processingClient.initVitamProcess(entry);
                    processingClient.updateOperationActionProcess(ProcessAction.RESUME.getValue(), operationId);
                    response = Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)new RequestResponseOK().setHttpCode(Response.Status.ACCEPTED.getStatusCode())).build();
                    if (workspaceClient == null) break block23;
                }
                catch (Throwable throwable) {
                    if (workspaceClient != null) {
                        try {
                            workspaceClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                workspaceClient.close();
            }
            return response;
        }
        catch (BadRequestException exp) {
            LOGGER.error((Throwable)exp);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.getErrorEntity(Response.Status.PRECONDITION_FAILED, exp.getMessage())).build();
        }
        catch (Exception exp) {
            LOGGER.error((Throwable)exp);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, exp.getLocalizedMessage())).build();
        }
    }

    @POST
    @Path(value="accession-register/symbolic")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createAccessionRegisterSymbolic(List<Integer> tenants) {
        Response response;
        Response response2 = this.checkMultiTenantRequest(tenants);
        if (response2 != null) {
            return response2;
        }
        ReferentialAccessionRegisterImpl service = new ReferentialAccessionRegisterImpl(this.mongoAccess, this.vitamCounterService, this.metaDataClientFactory, this.configuration);
        try {
            service.createAccessionRegisterSymbolic(tenants);
            response = Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    service.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getLocalizedMessage())).build();
            }
        }
        service.close();
        return response;
    }

    @GET
    @Path(value="accession-register/symbolic")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAccessionRegisterSymbolic(JsonNode queryDsl) {
        Response response;
        ReferentialAccessionRegisterImpl service = new ReferentialAccessionRegisterImpl(this.mongoAccess, this.vitamCounterService, this.metaDataClientFactory, this.configuration);
        try {
            SanityChecker.checkJsonAll((JsonNode)queryDsl);
            SelectParserSingle parser = new SelectParserSingle((VarNameAdapter)DEFAULT_VARNAME_ADAPTER);
            parser.parse(queryDsl);
            AccessContractModel contract = this.getContractDetails(VitamThreadUtils.getVitamSession().getContractId());
            if (contract == null || contract.getEveryOriginatingAgency() == null) {
                throw new AccessUnauthorizedException("Contract Not Found or EveryOriginatingAgency flag is null");
            }
            if (!contract.getEveryOriginatingAgency().booleanValue()) {
                parser.addCondition(QueryHelper.in((String)ORIGINATING_AGENCY, (String[])((String[])contract.getOriginatingAgencies().toArray(String[]::new))).setDepthLimit(0));
            }
            RequestResponseOK entity = service.findAccessionRegisterSymbolic(queryDsl);
            response = Response.status((Response.Status)Response.Status.OK).entity((Object)entity).build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    service.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getLocalizedMessage())).build();
            }
        }
        service.close();
        return response;
    }

    @Path(value="/forcepause")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response forcePause(ProcessPause info) {
        Response response;
        block8: {
            ParametersChecker.checkParameter((String)"Json ProcessPause is a mandatory parameter", (Object[])new Object[]{info});
            ProcessingManagementClient processingClient = this.processingManagementClientFactory.getClient();
            try {
                RequestResponse requestResponse = processingClient.forcePause(info);
                response = Response.status((int)requestResponse.getStatus()).entity((Object)requestResponse).build();
                if (processingClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (processingClient != null) {
                        try {
                            processingClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ProcessingException e) {
                    LOGGER.error((Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getLocalizedMessage())).build();
                }
            }
            processingClient.close();
        }
        return response;
    }

    @Path(value="/removeforcepause")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response removeForcePause(ProcessPause info) {
        Response response;
        block8: {
            ParametersChecker.checkParameter((String)"Json ProcessPause is a mandatory parameter", (Object[])new Object[]{info});
            ProcessingManagementClient processingClient = this.processingManagementClientFactory.getClient();
            try {
                RequestResponse requestResponse = processingClient.removeForcePause(info);
                response = Response.status((int)requestResponse.getStatus()).entity((Object)requestResponse).build();
                if (processingClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (processingClient != null) {
                        try {
                            processingClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ProcessingException e) {
                    LOGGER.error((Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getLocalizedMessage())).build();
                }
            }
            processingClient.close();
        }
        return response;
    }

    private void validateAuditOptions(AuditOptions options, int tenantId) throws InvalidCreateOperationException, InvalidParseOperationException, AccessUnauthorizedException, ReferentialException, BadRequestException {
        Object errorMessage = null;
        if (options.getAuditType() == null) {
            errorMessage = "The field auditType is mandatory";
        } else if (options.getAuditActions() == null) {
            errorMessage = "The field auditActions is mandatory";
        } else {
            switch (options.getAuditType()) {
                case "tenant": {
                    if (StringUtils.isBlank((CharSequence)options.getObjectId())) {
                        errorMessage = "The field objectId is mandatory with auditType " + options.getAuditType();
                        break;
                    }
                    if (options.getObjectId().equals(String.valueOf(tenantId))) break;
                    errorMessage = "Invalid tenant parameter";
                    break;
                }
                case "originatingagency": {
                    if (StringUtils.isBlank((CharSequence)options.getObjectId())) {
                        errorMessage = "The field objectId is mandatory with auditType " + options.getAuditType();
                        break;
                    }
                    Select selectRequest = new Select();
                    selectRequest.setQuery((Query)QueryHelper.eq((String)ORIGINATING_AGENCY, (String)options.getObjectId()));
                    RequestResponseOK<AccessionRegisterSummary> fileFundRegisters = this.findFundRegisters((JsonNode)selectRequest.getFinalSelect());
                    if (fileFundRegisters.getResults().size() != 0) break;
                    errorMessage = "Invalid originating agency parameter";
                    break;
                }
                case "dsl": {
                    if (options.getQuery() != null) break;
                    errorMessage = "The field query is mandatory with auditType " + options.getAuditType();
                    break;
                }
                default: {
                    errorMessage = "Invalid audit type parameter";
                }
            }
        }
        if (errorMessage != null) {
            throw new BadRequestException((String)errorMessage);
        }
    }

    private AccessContractModel getContractDetails(String contractId) throws InvalidCreateOperationException, ReferentialException, InvalidParseOperationException {
        try (AccessContractImpl accessContract = new AccessContractImpl(this.mongoAccess, this.vitamCounterService);){
            RequestResponseOK accessContractModelList = accessContract.findContracts(AdminManagementResource.getQueryDsl(contractId)).setQuery((JsonNode)JsonHandler.createObjectNode());
            AccessContractModel accessContractModel = (AccessContractModel)Iterables.getOnlyElement((Iterable)accessContractModelList.getResults(), null);
            return accessContractModel;
        }
    }

    private static JsonNode getQueryDsl(String headerAccessContratId) throws InvalidCreateOperationException {
        Select select = new Select();
        BooleanQuery query = QueryHelper.and().add(new Query[]{QueryHelper.eq((String)"Identifier", (String)headerAccessContratId), QueryHelper.eq((String)"Status", (String)ActivationStatus.ACTIVE.name())});
        select.setQuery((Query)query);
        return select.getFinalSelect();
    }

    public void setVitamCounterService(VitamCounterService vitamCounterService) {
        this.vitamCounterService = vitamCounterService;
    }

    private void createAuditLogbookOperation(String operationId, AccessContractModel contract) throws LogbookClientBadRequestException, LogbookClientAlreadyExistsException, LogbookClientServerException, InvalidGuidOperationException {
        GUID objectId = GUIDReader.getGUID((String)operationId);
        try (LogbookOperationsClient logbookClient = this.logbookOperationsClientFactory.getClient();){
            LogbookOperationParameters initParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)objectId, (String)Contexts.AUDIT_WORKFLOW.getEventType(), (GUID)objectId, (LogbookTypeProcess)LogbookTypeProcess.AUDIT, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)Contexts.AUDIT_WORKFLOW.getEventType(), (StatusCode)StatusCode.STARTED), (GUID)objectId);
            if (contract != null) {
                ObjectNode rightsStatementIdentifier = JsonHandler.createObjectNode();
                rightsStatementIdentifier.put(ACCESS_CONTRACT, contract.getIdentifier());
                initParameters.putParameterValue(LogbookParameterName.rightsStatementIdentifier, rightsStatementIdentifier.toString());
            }
            logbookClient.create(new LogbookOperationParameters[]{initParameters});
        }
    }

    @POST
    @Path(value="logbookoperations")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addExternalOperation(LogbookOperationParameters operation) {
        Response response;
        block18: {
            LogbookOperationsClient logbookClient = this.logbookOperationsClientFactory.getClient();
            try {
                if (!LogbookTypeProcess.EXTERNAL_LOGBOOK.equals((Object)operation.getTypeProcess())) {
                    throw new IllegalArgumentException("This type of process is not correct :" + String.valueOf(operation.getTypeProcess()));
                }
                if (operation.getParameterValue(LogbookParameterName.eventType) == null || !operation.getParameterValue(LogbookParameterName.eventType).startsWith("EXT_")) {
                    throw new IllegalArgumentException("This type of event is not correct :" + operation.getParameterValue(LogbookParameterName.eventType));
                }
                VitamSession vitamSession = VitamThreadUtils.getVitamSession();
                String contextId = vitamSession.getContextId();
                String personalCertificate = vitamSession.getPersonalCertificate();
                GUID eip = GUIDReader.getGUID((String)vitamSession.getRequestId());
                LogbookOperationParameters masterOperation = LogbookParameterHelper.newLogbookOperationParameters();
                masterOperation.setTypeProcess(LogbookTypeProcess.EXTERNAL_LOGBOOK).setStatus(StatusCode.OK).putParameterValue(LogbookParameterName.eventIdentifier, eip.getId()).putParameterValue(LogbookParameterName.eventIdentifierProcess, eip.getId()).putParameterValue(LogbookParameterName.eventIdentifierRequest, eip.getId()).putParameterValue(LogbookParameterName.objectIdentifier, eip.getId()).putParameterValue(LogbookParameterName.eventType, operation.getParameterValue(LogbookParameterName.eventType)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)LogbookTypeProcess.EXTERNAL_LOGBOOK.name(), (StatusCode)StatusCode.OK)).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)operation.getParameterValue(LogbookParameterName.eventType), (StatusCode)StatusCode.STARTED)).putParameterValue(LogbookParameterName.agentIdentifierApplication, contextId).putParameterValue(LogbookParameterName.agentIdentifierPersonae, personalCertificate).putParameterValue(LogbookParameterName.eventDateTime, LocalDateUtil.nowFormatted());
                if (operation.getParameterValue(LogbookParameterName.agentIdentifierApplicationSession) != null) {
                    masterOperation.putParameterValue(LogbookParameterName.agentIdentifierApplicationSession, operation.getParameterValue(LogbookParameterName.agentIdentifierApplicationSession));
                }
                if (operation.getParameterValue(LogbookParameterName.agIdExt) != null) {
                    JsonHandler.validate((String)operation.getParameterValue(LogbookParameterName.agIdExt));
                    masterOperation.putParameterValue(LogbookParameterName.agIdExt, operation.getParameterValue(LogbookParameterName.agIdExt));
                }
                if (operation.getParameterValue(LogbookParameterName.objectIdentifierIncome) != null) {
                    masterOperation.putParameterValue(LogbookParameterName.objectIdentifierIncome, operation.getParameterValue(LogbookParameterName.objectIdentifierIncome));
                }
                masterOperation.setEvents(operation.getEvents());
                logbookClient.create(new LogbookOperationParameters[]{masterOperation});
                if (masterOperation.getEvents() != null && masterOperation.getEvents().size() > 0) {
                    for (LogbookParameters param : masterOperation.getEvents()) {
                        param.putParameterValue(LogbookParameterName.eventIdentifier, eip.getId());
                        param.putParameterValue(LogbookParameterName.eventIdentifierProcess, eip.getId());
                        logbookClient.update(new LogbookOperationParameters[]{(LogbookOperationParameters)param});
                    }
                }
                response = Response.status((Response.Status)Response.Status.CREATED).entity((Object)new RequestResponseOK().setHttpCode(Response.Status.CREATED.getStatusCode())).build();
                if (logbookClient == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (logbookClient != null) {
                        try {
                            logbookClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidGuidOperationException | InvalidParseOperationException | LogbookClientBadRequestException | IllegalArgumentException e) {
                    LOGGER.error(e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorEntity(Response.Status.BAD_REQUEST, e.getMessage())).build();
                }
                catch (LogbookClientAlreadyExistsException e) {
                    LOGGER.error((Throwable)e);
                    return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)this.getErrorEntity(Response.Status.CONFLICT, e.getMessage())).build();
                }
                catch (LogbookClientServerException e) {
                    LOGGER.error((Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage())).build();
                }
                catch (LogbookClientNotFoundException e) {
                    LOGGER.error((Throwable)e);
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.getErrorEntity(Response.Status.NOT_FOUND, e.getMessage())).build();
                }
            }
            logbookClient.close();
        }
        return response;
    }

    private VitamError getErrorEntity(Response.Status status, String message) {
        String aMessage = message != null && !message.trim().isEmpty() ? message : (status.getReasonPhrase() != null ? status.getReasonPhrase() : status.name());
        return new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(FUNCTIONAL_ADMINISTRATION_MODULE).setState(status.name()).setMessage(status.getReasonPhrase()).setDescription(aMessage);
    }

    private Response checkMultiTenantRequest(List<Integer> tenants) {
        Integer tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        if (tenantId == null) {
            LOGGER.error("Missing TenantId");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!VitamConfiguration.getAdminTenant().equals(tenantId)) {
            LOGGER.error("Expecting admin tenant " + VitamConfiguration.getAdminTenant() + ", found: " + tenantId);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (CollectionUtils.isEmpty(tenants)) {
            LOGGER.error("Expecting non empty list of tenants");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (tenants.contains(null)) {
            LOGGER.error("Null tenant");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (new HashSet<Integer>(tenants).size() != tenants.size()) {
            LOGGER.error("Duplicate tenants");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        SetUtils.SetView unknownTenants = SetUtils.difference(new HashSet<Integer>(tenants), new HashSet(VitamConfiguration.getTenants()));
        if (!unknownTenants.isEmpty()) {
            LOGGER.error("Unknown tenants " + String.valueOf(unknownTenants));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return null;
    }
}

