/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.thread;

import fr.gouv.vitam.collect.common.exception.CollectInternalException;
import fr.gouv.vitam.collect.internal.core.configuration.CollectInternalConfiguration;
import fr.gouv.vitam.collect.internal.core.service.TransactionService;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.ExecutorUtils;
import fr.gouv.vitam.common.thread.VitamThreadFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ManageStatusThread
implements Runnable {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ManageStatusThread.class);
    private final TransactionService transactionService;
    private final int threadPoolSize;

    public ManageStatusThread(CollectInternalConfiguration collectInternalConfiguration, TransactionService transactionService) {
        this.transactionService = transactionService;
        Executors.newScheduledThreadPool(1, (ThreadFactory)VitamThreadFactory.getInstance()).scheduleAtFixedRate(this, Math.min(5, collectInternalConfiguration.getStatusTransactionThreadFrequency()), collectInternalConfiguration.getStatusTransactionThreadFrequency(), TimeUnit.MINUTES);
        this.threadPoolSize = Math.min(collectInternalConfiguration.getTransactionStatusThreadPoolSize(), VitamConfiguration.getTenants().size());
    }

    @Override
    public void run() {
        try {
            this.process();
        }
        catch (CollectInternalException e) {
            LOGGER.error("Error when executing threads:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() throws CollectInternalException {
        Thread.currentThread().setName(ManageStatusThread.class.getName());
        VitamThreadUtils.getVitamSession().setRequestId(GUIDFactory.newRequestIdGUID((int)VitamConfiguration.getAdminTenant()));
        List tenants = VitamConfiguration.getTenants();
        ThreadPoolExecutor executorService = ExecutorUtils.createScalableBatchExecutorService((int)this.threadPoolSize);
        ArrayList<CompletableFuture<Void>> completableFuturesList = new ArrayList<CompletableFuture<Void>>();
        try {
            for (Integer tenant : tenants) {
                CompletableFuture<Void> traceabilityCompletableFuture = CompletableFuture.runAsync(() -> {
                    Thread.currentThread().setName(ManageStatusThread.class.getName() + "-" + tenant);
                    VitamThreadUtils.getVitamSession().setTenantId(tenant);
                    try {
                        this.transactionService.manageTransactionsStatus();
                    }
                    catch (Exception e) {
                        LOGGER.error("Error when managing status transaction:", (Throwable)e);
                    }
                }, executorService);
                completableFuturesList.add(traceabilityCompletableFuture);
            }
            CompletableFuture<Void> combinedFuture = CompletableFuture.allOf(completableFuturesList.toArray(new CompletableFuture[0]));
            combinedFuture.join();
        }
        finally {
            executorService.shutdown();
        }
    }
}

