/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.collect.common.dto.CriteriaProjectDto;
import fr.gouv.vitam.collect.common.dto.ProjectDto;
import fr.gouv.vitam.collect.common.dto.TransactionDto;
import fr.gouv.vitam.collect.common.exception.CollectInternalException;
import fr.gouv.vitam.collect.common.exception.CollectInternalInvalidRequestException;
import fr.gouv.vitam.collect.common.exception.CollectRequestResponse;
import fr.gouv.vitam.collect.internal.core.common.TransactionModel;
import fr.gouv.vitam.collect.internal.core.service.FluxService;
import fr.gouv.vitam.collect.internal.core.service.MetadataService;
import fr.gouv.vitam.collect.internal.core.service.ProjectService;
import fr.gouv.vitam.collect.internal.core.service.TransactionService;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.security.SanityChecker;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/collect-internal/v1/projects")
public class ProjectInternalResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ProjectInternalResource.class);
    private static final String YOU_MUST_SUPPLY_PROJECTS_DATAS = "You must supply projects datas!";
    public static final String PROJECT_NOT_FOUND = "Unable to find project Id or invalid status";
    private static final String ERROR_GETTING_UNITS_BY_PROJECT_ID_MSG = "Error when getting units by project ID in metadata : {}";
    private static final String EMPTY_QUERY_IS_IMPOSSIBLE = "Empty query is impossible";
    public static final String VIRTUAL_TX = "VIRTUAL_TX_";
    private final ProjectService projectService;
    private final FluxService fluxService;
    private final TransactionService transactionService;
    private final MetadataService metadataService;

    public ProjectInternalResource(ProjectService projectService, FluxService fluxService, TransactionService transactionService, MetadataService metadataService) {
        this.projectService = projectService;
        this.fluxService = fluxService;
        this.transactionService = transactionService;
        this.metadataService = metadataService;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getProjects() {
        try {
            List listProjects = this.projectService.searchProject(null);
            return CollectRequestResponse.toResponseOK((Object)listProjects);
        }
        catch (CollectInternalException | IllegalArgumentException e) {
            LOGGER.error("Error when fetching projects by tenant Id :", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response searchProject(CriteriaProjectDto criteriaProjectDto) {
        try {
            ParametersChecker.checkParameter((String)"You must supply criteria of Project!", (Object[])new Object[]{criteriaProjectDto});
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)criteriaProjectDto));
            List listProjects = this.projectService.searchProject(criteriaProjectDto);
            return CollectRequestResponse.toResponseOK((Object)listProjects);
        }
        catch (CollectInternalException | InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error("Error when trying to parse :", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response initProject(ProjectDto projectDto) {
        try {
            ParametersChecker.checkParameter((String)YOU_MUST_SUPPLY_PROJECTS_DATAS, (Object[])new Object[]{projectDto});
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)projectDto));
            ProjectDto createdProject = this.projectService.createProject(projectDto);
            return CollectRequestResponse.toResponseOK((Object)createdProject);
        }
        catch (CollectInternalException e) {
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error("Error when trying to parse :", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateProject(ProjectDto projectDto) {
        try {
            ParametersChecker.checkParameter((String)YOU_MUST_SUPPLY_PROJECTS_DATAS, (Object[])new Object[]{projectDto});
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)projectDto));
            Optional projectOpt = this.projectService.findProject(projectDto.getId());
            if (projectOpt.isEmpty()) {
                LOGGER.error(PROJECT_NOT_FOUND);
                return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)PROJECT_NOT_FOUND);
            }
            Integer tenantId = ParameterHelper.getTenantParameter();
            projectDto.setTenant(tenantId);
            projectDto.setCreationDate(((ProjectDto)projectOpt.get()).getCreationDate());
            ProjectDto updatedProject = this.projectService.updateProject(projectDto);
            return CollectRequestResponse.toResponseOK((Object)updatedProject);
        }
        catch (CollectInternalException | InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error("Error when trying to parse :", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{projectId}")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getProjectById(@PathParam(value="projectId") String projectId) {
        try {
            SanityChecker.checkParameter((String[])new String[]{projectId});
            Optional projectOpt = this.projectService.findProject(projectId);
            if (projectOpt.isEmpty()) {
                LOGGER.error(PROJECT_NOT_FOUND);
                return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)PROJECT_NOT_FOUND);
            }
            return CollectRequestResponse.toResponseOK(projectOpt.get());
        }
        catch (CollectInternalException e) {
            LOGGER.error("Error when fetching project by Id :", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error("Error when fetching project by Id :", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{projectId}")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteProjectById(@PathParam(value="projectId") String projectId) {
        try {
            SanityChecker.checkParameter((String[])new String[]{projectId});
            Optional projectOpt = this.projectService.findProject(projectId);
            if (projectOpt.isEmpty()) {
                LOGGER.error(PROJECT_NOT_FOUND);
                return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)PROJECT_NOT_FOUND);
            }
            Optional transactionModel = this.transactionService.findLastTransactionByProjectId(projectId);
            if (transactionModel.isPresent()) {
                this.transactionService.deleteTransaction(((TransactionModel)transactionModel.get()).getId());
            }
            this.projectService.deleteProjectById(projectId);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (CollectInternalException e) {
            LOGGER.error("Error when delete project by Id :", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error("Error when delete project by Id :", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{projectId}/units")
    @GET
    @Produces(value={"application/json"})
    @Deprecated
    public Response getUnitsByProjectId(@PathParam(value="projectId") String projectId, JsonNode queryDsl) {
        try {
            SanityChecker.checkParameter((String[])new String[]{projectId});
            SanityChecker.checkJsonAll((JsonNode)queryDsl);
            this.checkEmptyQuery(queryDsl);
            Optional transaction = this.transactionService.findLastTransactionByProjectId(projectId);
            if (transaction.isEmpty()) {
                throw new CollectInternalException("Could not find transaction");
            }
            List units = this.metadataService.selectUnitsByTransactionId(queryDsl, ((TransactionModel)transaction.get()).getId()).getResults();
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new RequestResponseOK().addAllResults(units)).build();
        }
        catch (CollectInternalException e) {
            LOGGER.error(ERROR_GETTING_UNITS_BY_PROJECT_ID_MSG, (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error(ERROR_GETTING_UNITS_BY_PROJECT_ID_MSG, e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (BadRequestException e) {
            LOGGER.error(EMPTY_QUERY_IS_IMPOSSIBLE, (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)VitamCode.GLOBAL_EMPTY_QUERY.getStatus(), (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{projectId}/transactions")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAllTransactions(@PathParam(value="projectId") String projectId) {
        try {
            SanityChecker.checkParameter((String[])new String[]{projectId});
            List results = this.transactionService.findTransactionsByProjectId(projectId);
            return CollectRequestResponse.toResponseOK((Object)results);
        }
        catch (CollectInternalException e) {
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error("Error when trying to parse :", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{projectId}/transactions")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response initTransaction(TransactionDto transactionDto, @PathParam(value="projectId") String projectId) {
        try {
            ParametersChecker.checkParameter((String)"You must supply transaction datas!", (Object[])new Object[]{transactionDto});
            SanityChecker.checkParameter((String[])new String[]{projectId});
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)transactionDto));
            Integer tenantId = ParameterHelper.getTenantParameter();
            String requestId = GUIDFactory.newRequestIdGUID((int)tenantId).getId();
            transactionDto.setId(requestId);
            transactionDto.setTenant(tenantId);
            Optional projectOpt = this.projectService.findProject(projectId);
            if (projectOpt.isEmpty()) {
                LOGGER.error(PROJECT_NOT_FOUND);
                return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)PROJECT_NOT_FOUND);
            }
            this.transactionService.createTransaction(transactionDto, (ProjectDto)projectOpt.get());
            return CollectRequestResponse.toResponseOK((Object)transactionDto);
        }
        catch (CollectInternalException e) {
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error("Error when trying to parse :", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{projectId}/upload")
    @POST
    @Consumes(value={"application/zip"})
    @Produces(value={"application/json"})
    public Response uploadZipToProject(@PathParam(value="projectId") String projectId, InputStream inputStreamObject, @HeaderParam(value="X-Encoding") @Nullable String encoding) {
        try {
            ParametersChecker.checkParameter((String)"You must supply a ZIP input stream body!", (Object[])new Object[]{inputStreamObject});
            SanityChecker.checkParameter((String[])new String[]{projectId});
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error("An error occurs when try to upload the ZIP:", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        try {
            Optional projectOpt = this.projectService.findProject(projectId);
            if (projectOpt.isEmpty()) {
                LOGGER.error(PROJECT_NOT_FOUND);
                return CollectRequestResponse.toVitamError((Response.Status)Response.Status.NOT_FOUND, (String)PROJECT_NOT_FOUND);
            }
            String virtualTransactionId = VIRTUAL_TX + projectId;
            this.fluxService.processStream(inputStreamObject, projectId, virtualTransactionId, encoding, null);
            return Response.ok((Object)new RequestResponseOK().addResult((Object)virtualTransactionId)).build();
        }
        catch (CollectInternalInvalidRequestException | IllegalArgumentException e) {
            LOGGER.error("An error occurs when try to upload the ZIP:", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (CollectInternalException e) {
            LOGGER.error("An error occurs when try to upload the ZIP:", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    private void checkEmptyQuery(JsonNode queryDsl) throws InvalidParseOperationException, BadRequestException {
        SelectParserMultiple parser = new SelectParserMultiple();
        parser.parse(queryDsl.deepCopy());
        if (parser.getRequest().getNbQueries() == 0 && parser.getRequest().getRoots().isEmpty()) {
            throw new BadRequestException("Query cant be empty");
        }
    }
}

