/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.transformers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.schibsted.spt.data.jslt.Expression;
import com.schibsted.spt.data.jslt.JsltException;
import com.schibsted.spt.data.jslt.Parser;
import fr.gouv.vitam.collect.internal.core.exceptions.CollectInvalidJsltTransformerException;
import fr.gouv.vitam.collect.internal.core.exceptions.CollectJsltTransformationFailedException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;

public class JsltTransformer {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(JsltTransformer.class);
    private final Expression compiledExpression;

    public JsltTransformer(String jsltTemplate) throws CollectInvalidJsltTransformerException {
        this.compiledExpression = JsltTransformer.compile(jsltTemplate);
    }

    public ObjectNode transform(JsonNode inputJson) throws CollectJsltTransformationFailedException {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Transforming: '{}'", (Object)JsonHandler.unprettyPrint((Object)inputJson));
            }
            JsonNode result = this.compiledExpression.apply(inputJson);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Transformation result: '{}'", (Object)JsonHandler.unprettyPrint((Object)result));
            }
            if (!result.isObject()) {
                throw new CollectJsltTransformationFailedException("Invalid JSLT transformation. Expected JSON object result, got " + String.valueOf(result.getNodeType()));
            }
            return (ObjectNode)result;
        }
        catch (JsltException e) {
            throw new CollectJsltTransformationFailedException("An error occurred during JSLT transformation: " + e.getMessage(), e);
        }
    }

    private static Expression compile(String jsltTemplate) throws CollectInvalidJsltTransformerException {
        if (StringUtils.isBlank((CharSequence)jsltTemplate)) {
            throw new IllegalArgumentException("Jslt template cannot be empty");
        }
        LOGGER.debug("Compiling JSLT transformation '{}'", (Object)jsltTemplate);
        try {
            return new Parser((Reader)new StringReader(jsltTemplate)).withSource("<inline>").withObjectFilter(JsltTransformer::emptyObjectFilter).withFunctions(Collections.emptyList()).compile();
        }
        catch (JsltException e) {
            throw new CollectInvalidJsltTransformerException("Invalid JSLT template: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new CollectInvalidJsltTransformerException("An unexpected error occurred while validating JSLT: " + e.getMessage(), e);
        }
    }

    public static void validate(String jsltTemplate) throws CollectInvalidJsltTransformerException {
        if (StringUtils.isBlank((CharSequence)jsltTemplate)) {
            return;
        }
        JsltTransformer.compile(jsltTemplate);
    }

    private static boolean emptyObjectFilter(JsonNode value) {
        return !(value.isObject() && value.isEmpty() || value.isArray() && value.isEmpty());
    }
}

