/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.service;

import fr.gouv.vitam.collect.common.dto.CriteriaProjectDto;
import fr.gouv.vitam.collect.common.dto.ProjectDto;
import fr.gouv.vitam.collect.common.enums.TransactionStatus;
import fr.gouv.vitam.collect.common.exception.CollectInternalException;
import fr.gouv.vitam.collect.internal.core.common.ProjectModel;
import fr.gouv.vitam.collect.internal.core.common.ProjectStatus;
import fr.gouv.vitam.collect.internal.core.helpers.CollectHelper;
import fr.gouv.vitam.collect.internal.core.repository.ProjectRepository;
import fr.gouv.vitam.collect.internal.core.transformers.JsltTransformer;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ProjectService {
    private final ProjectRepository projectRepository;

    public ProjectService(ProjectRepository projectRepository) {
        this.projectRepository = projectRepository;
    }

    public ProjectDto createProject(ProjectDto projectDto) throws CollectInternalException {
        String creationDate = LocalDateUtil.nowFormatted();
        JsltTransformer.validate(projectDto.getTransformationRules());
        ProjectModel projectModel = new ProjectModel(GUIDFactory.newGUID().getId(), projectDto.getName(), CollectHelper.mapProjectDtoToManifestContext(projectDto), ProjectStatus.OPEN, creationDate, creationDate, projectDto.getUnitUp(), projectDto.getUnitUps(), ParameterHelper.getTenantParameter(), projectDto.getAutomaticIngest(), projectDto.getTransformationRules());
        this.projectRepository.createProject(projectModel);
        return CollectHelper.convertProjectModeltoProjectDto(projectModel);
    }

    public Optional<ProjectDto> findProject(String id) throws CollectInternalException {
        return this.projectRepository.findProjectById(id).map(CollectHelper::convertProjectModeltoProjectDto);
    }

    public ProjectDto updateProject(ProjectDto projectDto) throws CollectInternalException {
        projectDto.setStatus(projectDto.getStatus() != null ? projectDto.getStatus() : TransactionStatus.OPEN.name());
        String lastUpdate = LocalDateUtil.nowFormatted();
        JsltTransformer.validate(projectDto.getTransformationRules());
        ProjectModel projectModel = new ProjectModel(projectDto.getId(), projectDto.getName(), CollectHelper.mapProjectDtoToManifestContext(projectDto), ProjectStatus.valueOf(projectDto.getStatus()), projectDto.getCreationDate(), lastUpdate, projectDto.getUnitUp(), projectDto.getUnitUps(), projectDto.getTenant(), projectDto.getAutomaticIngest(), projectDto.getTransformationRules());
        this.projectRepository.updateProject(projectModel);
        return CollectHelper.convertProjectModeltoProjectDto(projectModel);
    }

    public List<ProjectDto> searchProject(CriteriaProjectDto criteriaProjectDto) throws CollectInternalException {
        List<ProjectModel> listProjects = this.projectRepository.searchProject(criteriaProjectDto, ParameterHelper.getTenantParameter());
        return listProjects.stream().map(CollectHelper::convertProjectModeltoProjectDto).collect(Collectors.toList());
    }

    public void deleteProjectById(String id) {
        this.projectRepository.deleteProject(id);
    }
}

