/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import fr.gouv.vitam.collect.common.dto.BulkAtomicUpdateResult;
import fr.gouv.vitam.collect.common.dto.MetadataUnitUp;
import fr.gouv.vitam.collect.common.exception.CollectInternalException;
import fr.gouv.vitam.collect.common.exception.CollectInternalInvalidRequestException;
import fr.gouv.vitam.collect.common.exception.CollectInternalServerSideException;
import fr.gouv.vitam.collect.internal.core.common.CollectJsonMetadataLine;
import fr.gouv.vitam.collect.internal.core.common.ProjectModel;
import fr.gouv.vitam.collect.internal.core.common.TransactionModel;
import fr.gouv.vitam.collect.internal.core.csv.CsvHelper;
import fr.gouv.vitam.collect.internal.core.csv.SedaSchemaInfoResolver;
import fr.gouv.vitam.collect.internal.core.helpers.JsonHelper;
import fr.gouv.vitam.collect.internal.core.helpers.MetadataHelper;
import fr.gouv.vitam.collect.internal.core.helpers.TempWorkspace;
import fr.gouv.vitam.collect.internal.core.jsonl.JsonlMetadataFileValidator;
import fr.gouv.vitam.collect.internal.core.repository.MetadataRepository;
import fr.gouv.vitam.collect.internal.core.repository.ProjectRepository;
import fr.gouv.vitam.collect.internal.core.service.BulkAtomicUpdateMetadataService;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.CompareQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.SetAction;
import fr.gouv.vitam.common.database.builder.query.action.UnsetAction;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.mapping.mapper.VitamObjectMapper;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.UnitType;
import fr.gouv.vitam.common.model.unit.ArchiveUnitModel;
import fr.gouv.vitam.common.model.unit.LevelType;
import fr.gouv.vitam.common.model.unit.ManagementModel;
import fr.gouv.vitam.common.model.unit.UpdateOperationModel;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.worker.core.distribution.JsonLineGenericIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class MetadataService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MetadataService.class);
    private static final String SYSTEM_ID_FIELD_PATH = VitamFieldsHelper.management() + ".UpdateOperation.SystemId";
    public static final int BULK_SIZE = 1000;
    private final MetadataRepository metadataRepository;
    private final ProjectRepository projectRepository;
    private final BulkAtomicUpdateMetadataService bulkAtomicUpdateMetadataService;
    private final AdminManagementClientFactory adminManagementClientFactory;

    public MetadataService(MetadataRepository metadataRepository, ProjectRepository projectRepository, BulkAtomicUpdateMetadataService bulkAtomicUpdateMetadataService, AdminManagementClientFactory adminManagementClientFactory) {
        this.metadataRepository = metadataRepository;
        this.projectRepository = projectRepository;
        this.bulkAtomicUpdateMetadataService = bulkAtomicUpdateMetadataService;
        this.adminManagementClientFactory = adminManagementClientFactory;
    }

    public JsonNode selectUnitById(String unitId) throws CollectInternalException {
        return this.metadataRepository.selectUnitById(unitId);
    }

    public JsonNode selectObjectGroupById(String objectGroupId) throws CollectInternalException {
        return this.metadataRepository.selectObjectGroupById(objectGroupId, true);
    }

    public JsonNode saveArchiveUnit(JsonNode unit, TransactionModel transactionModel) throws CollectInternalException, InvalidParseOperationException {
        ArchiveUnitModel unitModel = (ArchiveUnitModel)VitamObjectMapper.getDeserializationObjectMapper().convertValue((Object)unit, ArchiveUnitModel.class);
        String unitId = GUIDFactory.newUnitGUID((int)VitamThreadUtils.getVitamSession().getTenantId()).getId();
        unitModel.setId(unitId);
        unitModel.setOpi(transactionModel.getId());
        unitModel.setUnitType(UnitType.INGEST);
        Optional<ProjectModel> project = this.projectRepository.findProjectById(transactionModel.getProjectId());
        if (project.isEmpty()) {
            throw new CollectInternalException("Cannot find project");
        }
        ProjectModel projectModel = project.get();
        Map<String, String> attachmentUnitsBySystemId = this.prepareAttachmentUnits(projectModel, transactionModel.getId());
        if (unitModel.getUnitups() == null || unitModel.getUnitups().isEmpty()) {
            if (projectModel.getUnitUp() != null) {
                unitModel.setUnitups(List.of(attachmentUnitsBySystemId.get(projectModel.getUnitUp())));
            }
            if (projectModel.getUnitUps() != null) {
                Set<String> unitUpSet = MetadataHelper.findUnitParent(((ObjectNode)unit).put(VitamFieldsHelper.id(), unitId), projectModel.getUnitUps(), attachmentUnitsBySystemId);
                if (!attachmentUnitsBySystemId.isEmpty()) {
                    unitModel.setUnitups(new ArrayList<String>(unitUpSet));
                }
            }
        }
        if (StringUtils.isEmpty((CharSequence)unitModel.getOriginatingAgency()) && projectModel.getManifestContext() != null && StringUtils.isNotEmpty((CharSequence)projectModel.getManifestContext().getOriginatingAgencyIdentifier())) {
            unitModel.setOriginatingAgency(projectModel.getManifestContext().getOriginatingAgencyIdentifier());
        }
        JsonNode jsonNode = (JsonNode)VitamObjectMapper.getSerializationObjectMapper().convertValue((Object)unitModel, JsonNode.class);
        this.insertSimpleUnit(jsonNode);
        this.updateSimpleUnit(transactionModel.getId(), jsonNode, unitId);
        return jsonNode;
    }

    private void updateSimpleUnit(String transactionId, JsonNode jsonNode, String unitId) throws CollectInternalException, InvalidParseOperationException {
        try {
            UpdateMultiQuery query = new UpdateMultiQuery();
            query.addRoots(new String[]{unitId});
            Map<String, JsonNode> metadataMap = JsonHelper.jsonToMap(jsonNode);
            query.addActions(new Action[]{new SetAction(metadataMap)});
            this.metadataRepository.updateUnitById(query, transactionId, unitId);
        }
        catch (InvalidCreateOperationException e) {
            throw new CollectInternalException((Throwable)e);
        }
    }

    private void insertSimpleUnit(JsonNode jsonNode) throws CollectInternalException {
        ObjectNode objectNode = JsonHandler.createObjectNode();
        objectNode.set(VitamFieldsHelper.id(), jsonNode.get(VitamFieldsHelper.id()));
        objectNode.set(VitamFieldsHelper.unitups(), jsonNode.get(VitamFieldsHelper.unitups()));
        objectNode.set("Title", jsonNode.get("Title"));
        this.metadataRepository.saveArchiveUnit(objectNode);
    }

    public void updateUnitsWithMetadataCsv(TransactionModel transaction, InputStream is) throws CollectInternalException {
        String requestId = VitamThreadUtils.getVitamSession().getRequestId();
        File file = PropertiesUtils.fileFromTmpFolder((String)("metadata_" + requestId + ".jsonl"));
        SedaSchemaInfoResolver sedaSchemaInfoResolver = new SedaSchemaInfoResolver(this.adminManagementClientFactory);
        try {
            CsvHelper.convertCsvToJsonlMetadataFile(sedaSchemaInfoResolver, is, file, false, false);
            try (FileInputStream jsonlMetadataInputStream = new FileInputStream(file);){
                this.updateUnitsWithJsonlMetadataFile(transaction.getId(), jsonlMetadataInputStream);
            }
        }
        catch (IOException e) {
            throw new CollectInternalException((Throwable)e);
        }
        finally {
            FileUtils.deleteQuietly((File)file);
        }
    }

    public void updateUnitsWithJsonlMetadata(TransactionModel transaction, InputStream metadataJsonlInputStream) throws CollectInternalException {
        try (TempWorkspace tempWorkspace = new TempWorkspace();){
            File jsonlMetadataFile = tempWorkspace.writeToFile("metadata.jsonl", metadataJsonlInputStream);
            JsonlMetadataFileValidator jsonlMetadataFileValidator = new JsonlMetadataFileValidator();
            jsonlMetadataFileValidator.validate(jsonlMetadataFile, false, false);
            try (FileInputStream sanityStream = new FileInputStream(jsonlMetadataFile);){
                this.updateUnitsWithJsonlMetadataFile(transaction.getId(), sanityStream);
            }
        }
        catch (IOException e) {
            throw new CollectInternalServerSideException((Throwable)e);
        }
    }

    public RequestResponseOK<JsonNode> selectUnitsByTransactionId(JsonNode queryDsl, String transactionId) throws CollectInternalException {
        return this.metadataRepository.selectUnits(queryDsl, transactionId);
    }

    void updateUnitsWithJsonlMetadataFile(String transactionId, InputStream is) throws CollectInternalException {
        try (JsonLineGenericIterator metadata = new JsonLineGenericIterator(is, CollectJsonMetadataLine.TYPE_REFERENCE);){
            UnmodifiableIterator iterator = Iterators.partition((Iterator)metadata, (int)1000);
            int nbOK = 0;
            int nbKO = 0;
            ArrayList<String> firstNErrorMessages = new ArrayList<String>();
            while (iterator.hasNext()) {
                List jsonlMetadataLinesBatch = (List)iterator.next();
                List<BulkAtomicUpdateResult> updateUnitsBatchResults = this.updateUnitsBatch(transactionId, jsonlMetadataLinesBatch);
                block11: for (BulkAtomicUpdateResult updateUnitsBatchResult : updateUnitsBatchResults) {
                    switch (updateUnitsBatchResult.getStatus()) {
                        case OK: {
                            ++nbOK;
                            LOGGER.debug("Update OK of unit " + updateUnitsBatchResult.getUpdatedUnitId());
                            continue block11;
                        }
                        case KO: {
                            LOGGER.debug("Update failed : " + updateUnitsBatchResult.getErrorDetails());
                            if (firstNErrorMessages.size() < 10) {
                                firstNErrorMessages.add(updateUnitsBatchResult.getErrorDetails());
                            }
                            ++nbKO;
                            continue block11;
                        }
                    }
                    throw new IllegalStateException("Unexpected value: " + String.valueOf(updateUnitsBatchResult.getStatus()));
                }
            }
            if (nbOK == 0 && nbKO == 0) {
                throw new CollectInternalException("no update data found !");
            }
            if (nbKO == 0) {
                LOGGER.info("Metadata update succeeded. Nb OK: " + nbOK);
                return;
            }
            boolean isTruncated = nbKO > firstNErrorMessages.size();
            throw new CollectInternalInvalidRequestException("Metadata update failed. Nb OK: " + nbOK + ", Nb KO: " + nbKO + ". Error messages" + (isTruncated ? " (truncated)" : "") + ":" + String.valueOf(firstNErrorMessages));
        }
    }

    private List<BulkAtomicUpdateResult> updateUnitsBatch(String transactionId, List<CollectJsonMetadataLine> jsonlMetadataLines) throws CollectInternalException {
        ArrayNode queries = JsonHandler.createArrayNode();
        for (CollectJsonMetadataLine jsonMetadataLine : jsonlMetadataLines) {
            queries.add((JsonNode)MetadataService.createUpdateQuery(jsonMetadataLine));
        }
        return this.bulkAtomicUpdateMetadataService.bulkAtomicUpdateUnits(transactionId, queries, true);
    }

    private static ObjectNode createUpdateQuery(CollectJsonMetadataLine jsonMetadataLine) throws CollectInternalServerSideException {
        try {
            UpdateMultiQuery updateMultiQuery = new UpdateMultiQuery();
            updateMultiQuery.addQueries(new Query[]{MetadataService.buildSelectorQuery(jsonMetadataLine)});
            HashMap fieldsToSet = new HashMap();
            ArrayList fieldsToUnset = new ArrayList();
            jsonMetadataLine.getUnitContent().fields().forEachRemaining(e -> {
                if (((JsonNode)e.getValue()).isNull()) {
                    fieldsToUnset.add((String)e.getKey());
                } else {
                    fieldsToSet.put((String)e.getKey(), (JsonNode)e.getValue());
                }
            });
            if (!fieldsToSet.isEmpty()) {
                updateMultiQuery.addActions(new Action[]{new SetAction(fieldsToSet)});
            }
            if (!fieldsToUnset.isEmpty()) {
                updateMultiQuery.addActions(new Action[]{new UnsetAction((String[])fieldsToUnset.toArray(String[]::new))});
            }
            return updateMultiQuery.getFinalUpdate();
        }
        catch (InvalidCreateOperationException e2) {
            throw new CollectInternalServerSideException("Cannot build query", (Throwable)e2);
        }
    }

    private static Query buildSelectorQuery(CollectJsonMetadataLine jsonMetadataLine) throws InvalidCreateOperationException {
        if (jsonMetadataLine.getFile() != null) {
            return QueryHelper.term((String)VitamFieldsHelper.uploadPath(), (String)jsonMetadataLine.getFile());
        }
        Map<String, ValueNode> selectorEntries = jsonMetadataLine.getSelector().getEntries();
        if (selectorEntries.size() == 1) {
            Map.Entry<String, ValueNode> selector = selectorEntries.entrySet().iterator().next();
            return MetadataService.getSelectorQuery(selector);
        }
        BooleanQuery andQuery = QueryHelper.and();
        for (Map.Entry<String, ValueNode> selector : selectorEntries.entrySet()) {
            andQuery.add(new Query[]{MetadataService.getSelectorQuery(selector)});
        }
        return andQuery;
    }

    private static CompareQuery getSelectorQuery(Map.Entry<String, ValueNode> selector) throws InvalidCreateOperationException {
        ValueNode value = selector.getValue();
        switch (selector.getValue().getNodeType()) {
            case STRING: {
                return QueryHelper.eq((String)selector.getKey(), (String)value.textValue());
            }
            case BOOLEAN: {
                return QueryHelper.eq((String)selector.getKey(), (boolean)value.booleanValue());
            }
            case NUMBER: {
                return QueryHelper.eq((String)selector.getKey(), (long)value.longValue());
            }
        }
        throw new IllegalStateException("Unexpected selector value type: " + String.valueOf(selector.getValue().getNodeType()));
    }

    private ArchiveUnitModel createAttachmentUnit(String transactionId, String title, String unitUp, String originatingAgency) {
        ArchiveUnitModel unit = MetadataHelper.createUnit(transactionId, LevelType.SERIES, null, title, null, originatingAgency);
        ManagementModel managementModel = new ManagementModel();
        UpdateOperationModel updateOperation = new UpdateOperationModel();
        updateOperation.setSystemId(unitUp);
        managementModel.setUpdateOperation(updateOperation);
        unit.setManagement(managementModel);
        return unit;
    }

    private Map<String, String> findAttachmentUnitIdsBySystemId(String transactionId, ProjectModel projectModel) throws InvalidCreateOperationException, CollectInternalException, InvalidParseOperationException {
        HashSet<String> unitsToFetchBySystemId = new HashSet<String>();
        if (projectModel.getUnitUp() != null) {
            unitsToFetchBySystemId.add(projectModel.getUnitUp());
        }
        if (projectModel.getUnitUps() != null) {
            projectModel.getUnitUps().forEach(unitUp -> unitsToFetchBySystemId.add(unitUp.getUnitUp()));
        }
        if (unitsToFetchBySystemId.isEmpty()) {
            return Collections.emptyMap();
        }
        SelectMultiQuery query = new SelectMultiQuery();
        query.addQueries(new Query[]{QueryHelper.in((String)SYSTEM_ID_FIELD_PATH, (String[])unitsToFetchBySystemId.toArray(new String[0]))});
        query.addUsedProjection(new String[]{VitamFieldsHelper.id(), SYSTEM_ID_FIELD_PATH});
        RequestResponseOK<JsonNode> units = this.metadataRepository.selectUnits((JsonNode)query.getFinalSelect(), transactionId);
        return units.getResults().stream().collect(Collectors.toMap(this::findSystemId, attachmentUnit -> attachmentUnit.get(VitamFieldsHelper.id()).asText()));
    }

    Map<String, String> prepareAttachmentUnits(ProjectModel projectModel, String transactionId) throws CollectInternalException {
        try {
            Map<String, String> attachmentUnitsBySystemId = this.findAttachmentUnitIdsBySystemId(transactionId, projectModel);
            String originatingAgency = null;
            if (projectModel.getManifestContext() != null && StringUtils.isNotEmpty((CharSequence)projectModel.getManifestContext().getOriginatingAgencyIdentifier())) {
                originatingAgency = projectModel.getManifestContext().getOriginatingAgencyIdentifier();
            }
            ArrayList<ArchiveUnitModel> unitsToCreate = new ArrayList<ArchiveUnitModel>();
            if (projectModel.getUnitUp() != null && !attachmentUnitsBySystemId.containsKey(projectModel.getUnitUp())) {
                ArchiveUnitModel unit2 = this.createAttachmentUnit(transactionId, "STATIC_ATTACHEMENT", projectModel.getUnitUp(), originatingAgency);
                unitsToCreate.add(unit2);
                attachmentUnitsBySystemId.put(projectModel.getUnitUp(), unit2.getId());
            }
            if (projectModel.getUnitUps() != null) {
                for (MetadataUnitUp unitUp : projectModel.getUnitUps()) {
                    if (attachmentUnitsBySystemId.containsKey(unitUp.getUnitUp())) continue;
                    String unitTitle = "DYNAMIC_ATTACHEMENT_" + unitUp.getUnitUp();
                    ArchiveUnitModel unit3 = this.createAttachmentUnit(transactionId, unitTitle, unitUp.getUnitUp(), originatingAgency);
                    unitsToCreate.add(unit3);
                    attachmentUnitsBySystemId.put(unitUp.getUnitUp(), unit3.getId());
                }
            }
            if (!unitsToCreate.isEmpty()) {
                ObjectMapper objectMapper = VitamObjectMapper.getSerializationObjectMapper();
                this.metadataRepository.saveArchiveUnits(unitsToCreate.stream().map(unit -> (ObjectNode)objectMapper.convertValue(unit, ObjectNode.class)).collect(Collectors.toList()));
            }
            return attachmentUnitsBySystemId;
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new CollectInternalException(e);
        }
    }

    private String findSystemId(JsonNode attachmentUnit) {
        JsonNode value = attachmentUnit;
        for (String field : SYSTEM_ID_FIELD_PATH.split("\\.")) {
            value = value.get(field);
        }
        return value.asText();
    }

    private void resetQuery(JsonNode result, JsonNode queryDsl) {
        if (result != null && result.has("$context")) {
            ((ObjectNode)result).set("$context", queryDsl);
        }
    }

    public JsonNode selectUnitsWithInheritedRules(String transactionId, JsonNode queryDsl) throws InvalidParseOperationException {
        LOGGER.debug("DEBUG: start selectUnitsWithInheritedRules {}", (Object)queryDsl);
        JsonNode result = this.metadataRepository.selectUnitsWithInheritedRules(queryDsl, transactionId);
        this.resetQuery(result, queryDsl);
        LOGGER.debug("DEBUG: end selectUnitsWithInheritedRules {}");
        return result;
    }
}

