/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.repository;

import com.google.common.annotations.VisibleForTesting;
import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.UpdateResult;
import fr.gouv.vitam.collect.common.enums.TransactionStatus;
import fr.gouv.vitam.collect.common.exception.CollectInternalException;
import fr.gouv.vitam.collect.internal.core.common.TransactionModel;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.database.server.mongodb.BsonHelper;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.bson.Document;
import org.bson.conversions.Bson;

public class TransactionRepository {
    public static final String TRANSACTION_COLLECTION = "Transaction";
    public static final String ID = "_id";
    public static final String VERSION = "_v";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TransactionRepository.class);
    public static final String TENANT_ID = "_tenant";
    public static final String CREATION_DATE = "context.CreationDate";
    public static final String SET = "$set";
    public static final String STATUS = "Status";
    public static final String LAST_UPDATE = "LastUpdate";
    private final MongoCollection<Document> transactionCollection;

    @VisibleForTesting
    public TransactionRepository(MongoDbAccess mongoDbAccess, String collectionName) {
        this.transactionCollection = mongoDbAccess.getMongoDatabase().getCollection(collectionName);
    }

    public TransactionRepository(MongoDbAccess mongoDbAccess) {
        this(mongoDbAccess, TRANSACTION_COLLECTION);
    }

    public void createTransaction(TransactionModel transactionModel) throws CollectInternalException {
        LOGGER.debug("Transaction to create: {}", (Object)transactionModel);
        try {
            transactionModel.setVersion(0);
            String transactionModelAsString = JsonHandler.writeAsString((Object)transactionModel);
            this.transactionCollection.insertOne((Object)Document.parse((String)transactionModelAsString));
        }
        catch (InvalidParseOperationException e) {
            throw new CollectInternalException("Error when creating transaction: " + String.valueOf((Object)e));
        }
    }

    public void replaceTransaction(TransactionModel transactionModel) throws CollectInternalException {
        LOGGER.debug("Transaction to replace: {}", (Object)transactionModel);
        try {
            int atomicVersion = transactionModel.getVersion();
            transactionModel.setVersion(atomicVersion + 1);
            String transactionModelAsString = JsonHandler.writeAsString((Object)transactionModel);
            Bson condition = Filters.and((Bson[])new Bson[]{Filters.eq((String)ID, (Object)transactionModel.getId()), Filters.eq((String)VERSION, (Object)atomicVersion)});
            UpdateResult result = this.transactionCollection.replaceOne(condition, (Object)Document.parse((String)transactionModelAsString));
            if (result.getModifiedCount() == 0L) {
                throw new CollectInternalException("concurrency problem: the transaction was modified by another service");
            }
        }
        catch (InvalidParseOperationException e) {
            throw new CollectInternalException("Error when replacing transaction: ", (Throwable)e);
        }
    }

    private UpdateOneModel<Document> getUpdateOneModel(TransactionModel transactionModel) {
        transactionModel.setLastUpdate(LocalDateUtil.nowFormatted());
        Document documentToUpdate = new Document().append(SET, (Object)new BasicDBObject().append(STATUS, (Object)transactionModel.getStatus().name()).append(VERSION, (Object)(transactionModel.getVersion() + 1)));
        return new UpdateOneModel(Filters.and((Bson[])new Bson[]{Filters.eq((String)ID, (Object)transactionModel.getId()), Filters.eq((String)VERSION, (Object)transactionModel.getVersion())}), (Bson)documentToUpdate, new UpdateOptions());
    }

    public void replaceTransactions(List<TransactionModel> transactionsModel) throws CollectInternalException {
        BulkWriteOptions options = new BulkWriteOptions().ordered(false);
        ArrayList<UpdateOneModel<Document>> listUpdate = new ArrayList<UpdateOneModel<Document>>();
        for (TransactionModel item : transactionsModel) {
            listUpdate.add(this.getUpdateOneModel(item));
        }
        this.transactionCollection.bulkWrite(listUpdate, options);
    }

    public Optional<TransactionModel> findTransaction(String id) throws CollectInternalException {
        LOGGER.debug("Transaction id to find : {}", (Object)id);
        try {
            Integer tenantId = VitamThreadUtils.getVitamSession().getTenantId();
            Bson query = Filters.and((Bson[])new Bson[]{Filters.eq((String)ID, (Object)id), Filters.eq((String)TENANT_ID, (Object)tenantId)});
            Document first = (Document)this.transactionCollection.find(query).first();
            if (first == null) {
                return Optional.empty();
            }
            return Optional.of((TransactionModel)BsonHelper.fromDocumentToObject((Document)first, TransactionModel.class));
        }
        catch (InvalidParseOperationException e) {
            throw new CollectInternalException("Error when searching transaction by id: " + String.valueOf((Object)e));
        }
    }

    public Optional<TransactionModel> findTransactionByQuery(Bson query) throws CollectInternalException {
        try {
            Document first = (Document)this.getIterableTransactionsByQuery(query).sort((Bson)new BasicDBObject(CREATION_DATE, (Object)-1)).first();
            if (first == null) {
                return Optional.empty();
            }
            return Optional.of((TransactionModel)BsonHelper.fromDocumentToObject((Document)first, TransactionModel.class));
        }
        catch (InvalidParseOperationException e) {
            throw new CollectInternalException("Error when searching transaction by project id: " + String.valueOf((Object)e));
        }
    }

    private FindIterable<Document> getIterableTransactionsByQuery(Bson query) {
        Integer tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        Bson finalQuery = Filters.and((Bson[])new Bson[]{query, Filters.eq((String)TENANT_ID, (Object)tenantId)});
        return this.transactionCollection.find(finalQuery);
    }

    public List<TransactionModel> findTransactionsByQuery(Bson query) throws CollectInternalException {
        ArrayList<TransactionModel> arrayList;
        block9: {
            ArrayList<TransactionModel> listTransactions = new ArrayList<TransactionModel>();
            MongoCursor transactions = this.getIterableTransactionsByQuery(query).cursor();
            try {
                while (transactions.hasNext()) {
                    Document doc = (Document)transactions.next();
                    listTransactions.add((TransactionModel)BsonHelper.fromDocumentToObject((Document)doc, TransactionModel.class));
                }
                arrayList = listTransactions;
                if (transactions == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (transactions != null) {
                        try {
                            transactions.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error("Error when fetching transactions: ", (Throwable)e);
                    throw new CollectInternalException("Error when fetching transactions : " + String.valueOf((Object)e));
                }
            }
            transactions.close();
        }
        return arrayList;
    }

    public List<TransactionModel> findTransactionsByQueryWithoutTenant(Bson query) throws CollectInternalException {
        ArrayList<TransactionModel> arrayList;
        block9: {
            ArrayList<TransactionModel> listTransactions = new ArrayList<TransactionModel>();
            MongoCursor transactions = this.transactionCollection.find(query).cursor();
            try {
                while (transactions.hasNext()) {
                    Document doc = (Document)transactions.next();
                    listTransactions.add((TransactionModel)BsonHelper.fromDocumentToObject((Document)doc, TransactionModel.class));
                }
                arrayList = listTransactions;
                if (transactions == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (transactions != null) {
                        try {
                            transactions.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error("Error when fetching transactions: ", (Throwable)e);
                    throw new CollectInternalException("Error when fetching transactions : " + String.valueOf((Object)e));
                }
            }
            transactions.close();
        }
        return arrayList;
    }

    public void deleteTransaction(String id) {
        LOGGER.debug("Transaction to delete Id: {}", (Object)id);
        this.transactionCollection.deleteOne(Filters.eq((String)ID, (Object)id));
        LOGGER.debug("Transaction deleted Id: {}", (Object)id);
    }

    public List<TransactionModel> getListTransactionToDeleteByTenant(Integer tenantId) throws CollectInternalException {
        LOGGER.debug("Transactions to delete : {}");
        try {
            Bson query = Filters.and((Bson[])new Bson[]{Filters.eq((String)TENANT_ID, (Object)tenantId), Filters.in((String)STATUS, (Object[])new String[]{"ACK_OK", "ACK_WARNING", "ABORTED"})});
            ArrayList<TransactionModel> listTransactionToDelete = new ArrayList<TransactionModel>();
            MongoCursor transactionCursor = this.transactionCollection.find(query).cursor();
            while (transactionCursor.hasNext()) {
                Document doc = (Document)transactionCursor.next();
                listTransactionToDelete.add((TransactionModel)BsonHelper.fromDocumentToObject((Document)doc, TransactionModel.class));
            }
            return listTransactionToDelete;
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error("Error when fetching transaction to delete: ", (Throwable)e);
            throw new CollectInternalException("Error when fetching transaction to delete : " + String.valueOf((Object)e));
        }
    }

    public boolean findOneAndReplace(TransactionStatus transactionStatus, TransactionModel transactionModel) throws InvalidParseOperationException {
        return this.findOneAndReplace(Collections.singletonList(Filters.eq((String)STATUS, (Object)transactionStatus.toString())), transactionModel);
    }

    public boolean findOneAndReplace(TransactionModel transactionModel) throws InvalidParseOperationException {
        return this.findOneAndReplace(new ArrayList<Bson>(), transactionModel);
    }

    public boolean findOneAndReplace(List<Bson> additionalFilters, TransactionModel transactionModel) throws InvalidParseOperationException {
        String transactionModelAsString;
        Document documentToUpdate;
        Bson filter;
        Document updatedDocument;
        Integer tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        int atomicVersion = transactionModel.getVersion();
        transactionModel.setVersion(atomicVersion + 1);
        ArrayList<Bson> filters = new ArrayList<Bson>();
        filters.add(Filters.eq((String)ID, (Object)transactionModel.getId()));
        filters.add(Filters.eq((String)TENANT_ID, (Object)tenantId));
        filters.add(Filters.eq((String)VERSION, (Object)atomicVersion));
        if (CollectionUtils.isNotEmpty(additionalFilters)) {
            filters.addAll(additionalFilters);
        }
        return (updatedDocument = (Document)this.transactionCollection.findOneAndReplace(filter = Filters.and(filters), (Object)(documentToUpdate = Document.parse((String)(transactionModelAsString = JsonHandler.writeAsString((Object)transactionModel)))))) != null;
    }
}

