/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.jsonl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import fr.gouv.vitam.collect.common.exception.CollectInternalException;
import fr.gouv.vitam.collect.common.exception.CollectInternalInvalidRequestException;
import fr.gouv.vitam.collect.common.exception.CollectInternalServerSideException;
import fr.gouv.vitam.collect.internal.core.common.CollectJsonMetadataLine;
import fr.gouv.vitam.collect.internal.core.common.CollectJsonMetadataSelector;
import fr.gouv.vitam.collect.internal.core.exceptions.CollectInvalidJsonlFormatException;
import fr.gouv.vitam.collect.internal.core.jsonl.JsonlErrorAccumulator;
import fr.gouv.vitam.collect.internal.core.jsonl.JsonlHelper;
import fr.gouv.vitam.common.collection.IteratorHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.unit.ArchiveUnitModel;
import fr.gouv.vitam.common.model.unit.RuleCategoryModel;
import fr.gouv.vitam.common.model.unit.RuleModel;
import fr.gouv.vitam.common.model.unit.UpdateOperationModel;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.worker.core.distribution.JsonLineGenericIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class JsonlMetadataFileValidator {
    private static final Set<String> ALLOWED_RESERVED_FIELD_NAMES = Set.of(VitamFieldsHelper.management(), VitamFieldsHelper.history());
    private static final TypeReference<ArchiveUnitModel> ARCHIVE_UNIT_MODEL_TYPE_REFERENCE = new TypeReference<ArchiveUnitModel>(){};

    public void validate(File jsonlMetadataFile, boolean isFirstUpload, boolean explicitAttachementMode) throws CollectInternalException {
        JsonlMetadataFileValidator.doSanityChecks(jsonlMetadataFile);
        try (JsonlErrorAccumulator errorAccumulator = new JsonlErrorAccumulator();
             FileInputStream inputStream = new FileInputStream(jsonlMetadataFile);
             JsonLineGenericIterator iterator = new JsonLineGenericIterator((InputStream)inputStream, CollectJsonMetadataLine.TYPE_REFERENCE);){
            int lineIndex = 0;
            while (iterator.hasNext()) {
                CollectJsonMetadataLine entry = (CollectJsonMetadataLine)iterator.next();
                try {
                    this.validateMetadataIdentificationInformation(entry, lineIndex, isFirstUpload);
                    this.validateUnitContent(entry, lineIndex, isFirstUpload, explicitAttachementMode);
                }
                catch (CollectInternalInvalidRequestException e) {
                    errorAccumulator.report(e.getMessage());
                }
                ++lineIndex;
            }
        }
        catch (IOException e) {
            throw new CollectInternalServerSideException("An internal error occurred during jsonl metadata file validation", (Throwable)e);
        }
    }

    private static void doSanityChecks(File jsonlMetadataFile) throws CollectInternalInvalidRequestException, CollectInternalServerSideException {
        if (jsonlMetadataFile.length() == 0L) {
            throw new CollectInternalInvalidRequestException("Empty jsonl file");
        }
        try {
            SanityChecker.checkJsonLines((File)jsonlMetadataFile);
        }
        catch (IOException e) {
            throw new CollectInternalServerSideException("An internal error occurred during jsonl metadata file processing", (Throwable)e);
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            throw new CollectInternalInvalidRequestException("Cannot validate json-lines request: " + e.getLocalizedMessage(), e);
        }
    }

    private void validateMetadataIdentificationInformation(CollectJsonMetadataLine entry, int lineIndex, boolean isFirstUpload) throws CollectInternalInvalidRequestException {
        if (entry.getFile() == null && entry.getSelector() == null) {
            throw new CollectInternalInvalidRequestException("Invalid entry at index: " + lineIndex + ". Missing metadata identification information.");
        }
        if (entry.getFile() != null && entry.getSelector() != null) {
            throw new CollectInternalInvalidRequestException("Invalid entry at index: " + lineIndex + ". Fields 'File' and 'Selector' are mutually exclusive.");
        }
        if (entry.getFile() != null) {
            this.validateFileIdentifier(entry.getFile(), lineIndex);
        }
        if (entry.getObjectFiles() != null) {
            this.validateObjectFiles(entry.getObjectFiles(), lineIndex, isFirstUpload);
        }
        if (entry.getSelector() != null) {
            this.validateSelector(entry.getSelector(), lineIndex, isFirstUpload);
        }
    }

    private void validateFileIdentifier(String fileValue, int lineIndex) throws CollectInternalInvalidRequestException {
        if (StringUtils.isBlank((CharSequence)fileValue)) {
            throw new CollectInternalInvalidRequestException("Invalid entry at index: " + lineIndex + ". Empty unit file path '" + fileValue + "'");
        }
        String path = FilenameUtils.normalize((String)fileValue);
        if (!FilenameUtils.equals((String)fileValue, (String)path)) {
            throw new CollectInternalInvalidRequestException("Invalid entry at index: " + lineIndex + ". Illegal unit file path '" + fileValue + "'");
        }
    }

    private void validateObjectFiles(String objectFilesPath, int lineIndex, boolean isFirstUpload) throws CollectInternalInvalidRequestException {
        if (!isFirstUpload) {
            throw new CollectInternalInvalidRequestException("Invalid entry at index: " + lineIndex + ". ObjectFiles field not allowed for update operations.");
        }
        if (StringUtils.isBlank((CharSequence)objectFilesPath)) {
            throw new CollectInternalInvalidRequestException("Invalid entry at index: " + lineIndex + ". Empty ObjectFiles path.");
        }
        String normalizedPath = FilenameUtils.normalize((String)objectFilesPath);
        if (!FilenameUtils.equals((String)objectFilesPath, (String)normalizedPath)) {
            throw new CollectInternalInvalidRequestException("Invalid entry at index: " + lineIndex + ". Illegal ObjectFiles path '" + objectFilesPath + "'.");
        }
    }

    private void validateSelector(CollectJsonMetadataSelector selectorValue, int lineIndex, boolean isFirstUpload) throws CollectInternalInvalidRequestException {
        if (selectorValue.getEntries().isEmpty()) {
            throw new CollectInternalInvalidRequestException("Invalid entry at index: " + lineIndex + ". Empty selectors");
        }
        for (Map.Entry<String, ValueNode> entry : selectorValue.getEntries().entrySet()) {
            this.validateSelectorKey(entry.getKey(), lineIndex, isFirstUpload);
            this.validateSelectorValue(entry.getKey(), entry.getValue(), lineIndex);
        }
    }

    private void validateSelectorKey(String key, int lineIndex, boolean isFirstUpload) throws CollectInternalInvalidRequestException {
        JsonlMetadataFileValidator.validateKeyNameFormat(key, lineIndex);
        if (isFirstUpload && !VitamFieldsHelper.uploadPath().equals(key)) {
            throw new CollectInternalInvalidRequestException("Invalid selector key '" + key + "' for upload operation at index: " + lineIndex + ". Only File field Or Selector." + VitamFieldsHelper.uploadPath() + " selector allowed for upload operations.");
        }
    }

    private static void validateKeyNameFormat(String key, int lineIndex) throws CollectInternalInvalidRequestException {
        String[] fieldNames;
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new CollectInternalInvalidRequestException("Invalid field name: '" + key + "'  at index: " + lineIndex);
        }
        for (String fieldName : fieldNames = StringUtils.split((String)key, (char)'.')) {
            if (!fieldName.isEmpty() && !StringUtils.containsWhitespace((CharSequence)fieldName) && !fieldName.startsWith("_") && !fieldName.startsWith("$")) continue;
            throw new CollectInternalInvalidRequestException("Invalid field name: '" + key + "'  at index: " + lineIndex);
        }
    }

    private void validateSelectorValue(String key, ValueNode value, int lineIndex) throws CollectInternalInvalidRequestException {
        switch (value.getNodeType()) {
            case BOOLEAN: 
            case NUMBER: 
            case STRING: {
                break;
            }
            case ARRAY: {
                throw new CollectInternalInvalidRequestException("Invalid unit metadata at index: " + lineIndex + ". Invalid selector value for '" + key + "'.. Arrays are not supported");
            }
            case NULL: {
                throw new CollectInternalInvalidRequestException("Invalid unit metadata at index: " + lineIndex + ". Invalid selector value for '" + key + "'.. Null value");
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf(value.getNodeType()));
            }
        }
    }

    private void validateUnitContent(CollectJsonMetadataLine entry, int lineIndex, boolean isFirstUpload, boolean explicitAttachementMode) throws CollectInternalInvalidRequestException {
        this.checkNonEmptyUnit(entry.getUnitContent(), lineIndex);
        JsonlMetadataFileValidator.validateReservedUnitFieldNames(entry.getUnitContent(), lineIndex);
        JsonlMetadataFileValidator.validateUnitFormat(entry, lineIndex, isFirstUpload, explicitAttachementMode);
    }

    private void checkNonEmptyUnit(ObjectNode unitContent, int lineIndex) throws CollectInternalInvalidRequestException {
        if (unitContent == null || unitContent.isEmpty()) {
            throw new CollectInternalInvalidRequestException("Invalid unit metadata at index: " + lineIndex + ". Empty metadata content");
        }
    }

    private static void validateReservedUnitFieldNames(ObjectNode unitContent, int lineIndex) throws CollectInternalInvalidRequestException {
        Iterator it = unitContent.fieldNames();
        while (it.hasNext()) {
            String fieldName = (String)it.next();
            if (StringUtils.containsWhitespace((CharSequence)fieldName) || fieldName.startsWith("$") || fieldName.startsWith("_")) {
                throw new CollectInternalInvalidRequestException("Invalid unit metadata at index: " + lineIndex + ". Illegal field name '" + fieldName + "'");
            }
            if (fieldName.startsWith("#") && !ALLOWED_RESERVED_FIELD_NAMES.contains(fieldName)) {
                throw new CollectInternalInvalidRequestException("Invalid unit metadata at index: " + lineIndex + ". Forbidden field name '" + fieldName + "'");
            }
            if (!fieldName.contains(".")) continue;
            throw new CollectInternalInvalidRequestException("Invalid unit metadata at index: " + lineIndex + ". Field name must be root-level field: '" + fieldName + "'");
        }
    }

    private static void validateUnitFormat(CollectJsonMetadataLine entry, int lineIndex, boolean isFirstUpload, boolean explicitAttachementMode) throws CollectInternalInvalidRequestException {
        ArchiveUnitModel archiveUnitModel;
        try {
            archiveUnitModel = (ArchiveUnitModel)JsonHandler.getFromStrictJsonNode((JsonNode)entry.getUnitContent(), ARCHIVE_UNIT_MODEL_TYPE_REFERENCE);
        }
        catch (InvalidParseOperationException e) {
            throw new CollectInternalInvalidRequestException("Invalid unit metadata at index: " + lineIndex + ". Unit format validation failed: " + e.getLocalizedMessage(), (Throwable)e);
        }
        JsonlMetadataFileValidator.validateUnitRulesEndDates(archiveUnitModel, lineIndex);
        JsonlMetadataFileValidator.validateUpdateOperation(entry, archiveUnitModel, lineIndex, isFirstUpload, explicitAttachementMode);
    }

    private static void validateUnitRulesEndDates(ArchiveUnitModel archiveUnitModel, int lineIndex) throws CollectInternalInvalidRequestException {
        if (archiveUnitModel.getManagement() != null) {
            JsonlMetadataFileValidator.validateRulesEndDates(archiveUnitModel.getManagement().getDissemination(), "Dissemination", lineIndex);
            JsonlMetadataFileValidator.validateRulesEndDates(archiveUnitModel.getManagement().getStorage(), "Storage", lineIndex);
            JsonlMetadataFileValidator.validateRulesEndDates(archiveUnitModel.getManagement().getAppraisal(), "Appraisal", lineIndex);
            JsonlMetadataFileValidator.validateRulesEndDates(archiveUnitModel.getManagement().getAccess(), "Access", lineIndex);
            JsonlMetadataFileValidator.validateRulesEndDates(archiveUnitModel.getManagement().getReuse(), "Reuse", lineIndex);
            JsonlMetadataFileValidator.validateRulesEndDates(archiveUnitModel.getManagement().getClassification(), "Classification", lineIndex);
            JsonlMetadataFileValidator.validateRulesEndDates(archiveUnitModel.getManagement().getHold(), "Hold", lineIndex);
        }
    }

    private static void validateRulesEndDates(RuleCategoryModel ruleCategoryModel, String ruleCategory, int lineIndex) throws CollectInternalInvalidRequestException {
        if (ruleCategoryModel == null || CollectionUtils.isEmpty((Collection)ruleCategoryModel.getRules())) {
            return;
        }
        for (RuleModel rule : ruleCategoryModel.getRules()) {
            if (rule.getEndDate() == null) continue;
            throw new CollectInternalInvalidRequestException("Invalid unit metadata at index: " + lineIndex + ". Unit " + ruleCategory + " Rules cannot contain 'EndDate' field.");
        }
    }

    private static void validateUpdateOperation(CollectJsonMetadataLine entry, ArchiveUnitModel archiveUnitModel, int lineIndex, boolean isFirstUpload, boolean explicitAttachementMode) throws CollectInternalInvalidRequestException {
        if (archiveUnitModel.getManagement() == null || archiveUnitModel.getManagement().getUpdateOperation() == null) {
            return;
        }
        if (explicitAttachementMode) {
            throw new CollectInternalInvalidRequestException("Cannot set '#management.UpdateOperation.*' fields when explicit HTTP header 'X-Attachement-Id' is set");
        }
        if (!isFirstUpload) {
            throw new CollectInternalInvalidRequestException(String.format("Invalid unit metadata at index: %d: '%s.*' fields not supported in update APIs.", lineIndex, "Management.UpdateOperation"));
        }
        JsonlMetadataFileValidator.restrictUploadOperationToTopLevelUnits(entry, lineIndex);
        UpdateOperationModel updateOperation = archiveUnitModel.getManagement().getUpdateOperation();
        JsonlMetadataFileValidator.validateUpdateOperationFields(updateOperation, lineIndex);
        JsonlMetadataFileValidator.checkIncompatibleFieldsWithUpdateOperationFields(entry.getUnitContent(), lineIndex);
    }

    private static void restrictUploadOperationToTopLevelUnits(CollectJsonMetadataLine entry, int lineIndex) throws CollectInvalidJsonlFormatException {
        boolean isTopLevelFolder;
        String uploadPath = JsonlHelper.getInitialUploadPath(entry);
        boolean bl = isTopLevelFolder = !uploadPath.contains(File.separator);
        if (!isTopLevelFolder) {
            throw new CollectInvalidJsonlFormatException("Invalid unit metadata at index: " + lineIndex + ". Only top-level (root) units can have '#management.UpdateOperation.*' fields.");
        }
    }

    private static void validateUpdateOperationFields(UpdateOperationModel updateOperation, int lineIndex) throws CollectInvalidJsonlFormatException {
        String metadataValue;
        String systemId = updateOperation.getSystemId();
        String metadataName = updateOperation.getArchiveUnitIdentifierKey() != null ? updateOperation.getArchiveUnitIdentifierKey().getMetadataName() : null;
        String string = metadataValue = updateOperation.getArchiveUnitIdentifierKey() != null ? updateOperation.getArchiveUnitIdentifierKey().getMetadataValue() : null;
        if (systemId == null && metadataName == null && metadataValue == null) {
            throw new CollectInvalidJsonlFormatException("Invalid unit metadata at index: " + lineIndex + ". Missing or empty '#management.UpdateOperation' field.");
        }
        if (metadataName != null && metadataValue == null) {
            throw new CollectInvalidJsonlFormatException("Invalid unit metadata at index: " + lineIndex + ". Missing or empty '#management.UpdateOperation.ArchiveUnitIdentifierKey.MetadataValue' field.");
        }
        if (metadataName == null && metadataValue != null) {
            throw new CollectInvalidJsonlFormatException("Invalid unit metadata at index: " + lineIndex + ". Missing or empty '#management.UpdateOperation.ArchiveUnitIdentifierKey.MetadataName' field.");
        }
        if (systemId != null && metadataName != null) {
            throw new CollectInvalidJsonlFormatException("Invalid unit metadata at index: " + lineIndex + ". Both '#management.UpdateOperation.SystemId' and '#management.UpdateOperation.ArchiveUnitIdentifierKey.MetadataName' headers are set.");
        }
    }

    private static void checkIncompatibleFieldsWithUpdateOperationFields(ObjectNode unitContent, int lineIndex) throws CollectInvalidJsonlFormatException {
        Iterator iterator = IteratorUtils.asIterable((Iterator)unitContent.fieldNames()).iterator();
        block10: while (iterator.hasNext()) {
            String fieldName;
            switch (fieldName = (String)iterator.next()) {
                case "Title": 
                case "Title_": 
                case "DescriptionLevel": {
                    continue block10;
                }
                case "#management": {
                    ObjectNode managementNode = (ObjectNode)unitContent.get("#management");
                    Optional<String> anyOtherManagementField = IteratorHelper.toStream((Iterator)managementNode.fieldNames()).filter(mgtFieldName -> !mgtFieldName.equals("UpdateOperation")).findFirst();
                    if (!anyOtherManagementField.isPresent()) continue block10;
                    throw new CollectInvalidJsonlFormatException("Invalid unit metadata at index: " + lineIndex + ". Cannot set other metadata field '#management." + anyOtherManagementField.get() + "' when '#management.UpdateOperation' header is defined.");
                }
            }
            throw new CollectInvalidJsonlFormatException("Invalid unit metadata at index: " + lineIndex + ". Cannot set other metadata field '" + fieldName + "' when '#management.UpdateOperation' header is defined.");
        }
    }
}

