/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.helpers.builders;

import fr.gouv.vitam.collect.internal.core.helpers.builders.DbVersionsModelBuilder;
import fr.gouv.vitam.common.model.administration.DataObjectVersionType;
import fr.gouv.vitam.common.model.objectgroup.DbQualifiersModel;
import fr.gouv.vitam.common.model.objectgroup.DbVersionsModel;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class DbQualifiersModelBuilder {
    private DataObjectVersionType usage;
    private int nbc;
    private List<DbVersionsModel> versions;

    public DbQualifiersModelBuilder withUsage(DataObjectVersionType usage) {
        this.usage = usage;
        return this;
    }

    public DbQualifiersModelBuilder withNbc(int nbc) {
        this.nbc = nbc;
        return this;
    }

    public DbQualifiersModelBuilder withVersion(String versionId, String fileName, DataObjectVersionType usage, int version) {
        this.versions = Collections.singletonList(new DbVersionsModelBuilder().build(versionId, fileName, usage, version));
        return this;
    }

    public DbQualifiersModel build() {
        Objects.requireNonNull(this.usage, "Usage can't be null");
        Objects.requireNonNull(this.versions, "Versions can't be null");
        DbQualifiersModel qualifier = new DbQualifiersModel();
        qualifier.setQualifier(this.usage.getName());
        qualifier.setVersions(this.versions);
        qualifier.setNbc(this.nbc);
        return qualifier;
    }
}

