/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.helpers;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.collect.internal.core.common.TransactionModel;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.model.export.ExportRequest;
import fr.gouv.vitam.common.model.export.ExportRequestParameters;
import fr.gouv.vitam.common.model.export.ExportType;

public class SipHelper {
    public static final String COLLECT_REQUESTER_IDENTIFIER = "Vitam-Collect";

    private SipHelper() throws IllegalAccessException {
        throw new IllegalAccessException("Utility class!");
    }

    public static ExportRequestParameters buildExportRequestParameters(TransactionModel transactionModel) {
        ExportRequestParameters exportRequestParameters = new ExportRequestParameters();
        exportRequestParameters.setMessageRequestIdentifier(GUIDFactory.newGUID().getId());
        exportRequestParameters.setArchivalAgencyIdentifier(transactionModel.getManifestContext().getArchivalAgencyIdentifier());
        exportRequestParameters.setRequesterIdentifier(COLLECT_REQUESTER_IDENTIFIER);
        exportRequestParameters.setComment(transactionModel.getManifestContext().getComment());
        exportRequestParameters.setArchivalAgreement(transactionModel.getManifestContext() != null ? transactionModel.getManifestContext().getArchivalAgreement() : null);
        exportRequestParameters.setTransferringAgency(transactionModel.getManifestContext().getTransferringAgencyIdentifier());
        return exportRequestParameters;
    }

    public static ExportRequest buildExportRequest(TransactionModel transactionModel, ExportRequestParameters exportRequestParameters) throws InvalidCreateOperationException {
        SelectMultiQuery exportSelect = new SelectMultiQuery();
        exportSelect.setQuery((Query)QueryHelper.eq((String)VitamFieldsHelper.initialOperation(), (String)transactionModel.getId()));
        exportSelect.setScrollFilter("START", 60000, 10000);
        ExportRequest exportRequest = new ExportRequest();
        exportRequest.setDslRequest((JsonNode)exportSelect.getFinalSelect());
        exportRequest.setExportWithLogBookLFC(false);
        exportRequest.setExportWithoutObjects(false);
        exportRequest.setExportType(ExportType.MinimalArchiveDeliveryRequestReply);
        exportRequest.setExportRequestParameters(exportRequestParameters);
        return exportRequest;
    }
}

