/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.csv;

import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;

public class CsvMetadataUtils {
    public static final int MAX_HEADER_NAME_LENGTH = 255;
    public static final char SEPARATOR_CHAR = '.';
    public static final String SEPARATOR = ".";
    public static final String HASH_PREFIX = "#";
    public static final String CONTENT = "Content";
    public static final String CONTENT_SEPARATOR = "Content.";
    public static final String MANAGEMENT = "Management";
    public static final String MANAGEMENT_SEPARATOR = "Management.";
    public static final String MANAGEMENT_FIELD = "#management";
    public static final String ARCHIVE_UNIT_PROFILE = "ArchiveUnitProfile";
    public static final Pattern STARTS_WITH_DIGIT_PATTERN = Pattern.compile("^[0-9].*$");
    public static final Pattern ARRAY_INDEX_PATTERN = Pattern.compile("^(0|[1-9][0-9]*)$");
    public static final String CONTENT_TITLE = "Content.Title";
    public static final Pattern CONTENT_TITLE_VALID_HEADER_NAME_PATTERN = Pattern.compile("^Content\\.Title(\\.(0|[1-9][0-9]*))?(\\.attr)?$");
    public static final String CONTENT_DESCRIPTION = "Content.Description";
    public static final Pattern CONTENT_DESCRIPTION_VALID_HEADER_NAME_PATTERN = Pattern.compile("^Content\\.Description(\\.(0|[1-9][0-9]*))?(\\.attr)?$");
    public static final String CONTENT_DESCRIPTION_LEVEL = "Content.DescriptionLevel";
    public static final String DESCRIPTION_LEVEL_API_FIELD = "DescriptionLevel";
    public static final Set<String> SEDA_EXTENSION_POINTS = Set.of("Content", "Content.SigningInformation.Extended", "Content.OriginatingAgency.OrganizationDescriptiveMetadata", "Content.SubmissionAgency.OrganizationDescriptiveMetadata");
    public static final String CONTENT_SIGNATURE_REFERENCED_OBJECT_SIGNED_OBJECT_DIGEST = "Content.Signature.ReferencedObject.SignedObjectDigest";
    public static final String CONTENT_SIGNATURE_REFERENCED_OBJECT_SIGNED_OBJECT_DIGEST_MESSAGE_DIGEST = "Content.Signature.ReferencedObject.SignedObjectDigest.MessageDigest";
    public static final String CONTENT_SIGNATURE_REFERENCED_OBJECT_SIGNED_OBJECT_DIGEST_ATTR = "Content.Signature.ReferencedObject.SignedObjectDigest.attr";
    public static final String CONTENT_SIGNATURE_REFERENCED_OBJECT_SIGNED_OBJECT_DIGEST_ALGORITHM = "Content.Signature.ReferencedObject.SignedObjectDigest.Algorithm";
    public static final Pattern CONTENT_SIGNATURE_REFERENCED_OBJECT_SIGNED_OBJECT_DIGEST_ATTR_PATTERN = Pattern.compile("Content.Signature(\\.(0|[1-9][0-9]*))?.ReferencedObject.SignedObjectDigest.attr");
    public static final String SIGNED_OBJECT_DIGEST_MESSAGE_DIGEST_SUFFIX = "SignedObjectDigest.MessageDigest";
    public static final String ALGORITHM_SUFFIX = "Algorithm";
    public static final String END_DATE_FIELD = "EndDate";
    public static final Set<String> SEDA_MANAGEMENT_SPECIAL_ARRAY_FIELDS = Set.of("Management.AccessRule.Rule", "Management.AccessRule.StartDate", "Management.AppraisalRule.Rule", "Management.AppraisalRule.StartDate", "Management.ClassificationRule.Rule", "Management.ClassificationRule.StartDate", "Management.DisseminationRule.Rule", "Management.DisseminationRule.StartDate", "Management.HoldRule.Rule", "Management.HoldRule.StartDate", "Management.HoldRule.HoldEndDate", "Management.HoldRule.HoldOwner", "Management.HoldRule.HoldReassessingDate", "Management.HoldRule.HoldReason", "Management.HoldRule.PreventRearrangement", "Management.ReuseRule.Rule", "Management.ReuseRule.StartDate", "Management.StorageRule.Rule", "Management.StorageRule.StartDate");
    public static final Set<String> SEDA_MANAGEMENT_SPECIAL_RULE_PROPERTY_ARRAY_FIELDS = Set.of("Management.AccessRule.StartDate", "Management.AppraisalRule.StartDate", "Management.ClassificationRule.StartDate", "Management.DisseminationRule.StartDate", "Management.HoldRule.StartDate", "Management.HoldRule.HoldEndDate", "Management.HoldRule.HoldOwner", "Management.HoldRule.HoldReassessingDate", "Management.HoldRule.HoldReason", "Management.HoldRule.PreventRearrangement", "Management.ReuseRule.StartDate", "Management.StorageRule.StartDate");
    public static final String MANAGEMENT_UPDATE_OPERATION = "Management.UpdateOperation";
    public static final String MANAGEMENT_UPDATE_OPERATION_API_PATH = "#management.UpdateOperation";
    public static final String MANAGEMENT_UPDATE_OPERATION_SYSTEM_ID = "Management.UpdateOperation.SystemId";
    public static final String MANAGEMENT_UPDATE_OPERATION_SYSTEM_ID_API_PATH = "#management.UpdateOperation.SystemId";
    public static final String MANAGEMENT_UPDATE_OPERATION_ARCHIVE_UNIT_IDENTIFIER_KEY = "Management.UpdateOperation.ArchiveUnitIdentifierKey";
    public static final String MANAGEMENT_UPDATE_OPERATION_ARCHIVE_UNIT_IDENTIFIER_KEY_API_PATH = "#management.UpdateOperation.ArchiveUnitIdentifierKey";
    public static final String MANAGEMENT_UPDATE_OPERATION_ARCHIVE_UNIT_IDENTIFIER_KEY_METADATA_NAME = "Management.UpdateOperation.ArchiveUnitIdentifierKey.MetadataName";
    public static final String MANAGEMENT_UPDATE_OPERATION_ARCHIVE_UNIT_IDENTIFIER_KEY_METADATA_NAME_API_PATH = "#management.UpdateOperation.ArchiveUnitIdentifierKey.MetadataName";
    public static final String MANAGEMENT_UPDATE_OPERATION_ARCHIVE_UNIT_IDENTIFIER_KEY_METADATA_VALUE = "Management.UpdateOperation.ArchiveUnitIdentifierKey.MetadataValue";
    public static final String MANAGEMENT_UPDATE_OPERATION_ARCHIVE_UNIT_IDENTIFIER_KEY_METADATA_VALUE_API_PATH = "#management.UpdateOperation.ArchiveUnitIdentifierKey.MetadataValue";
    public static final String UPDATE_OPERATION_API_FIELD = "UpdateOperation";
    public static final String SYSTEM_ID_API_FIELD = "SystemId";
    public static final String ARCHIVE_UNIT_IDENTIFIER_KEY_API_FIELD = "ArchiveUnitIdentifierKey";
    public static final String METADATA_NAME_API_FIELD = "MetadataName";
    public static final String METADATA_VALUE_API_FIELD = "MetadataValue";
    public static final Pattern LANG_ATTR_VALUE_PATTERN = Pattern.compile("^xml:lang=\"(.+)\"$");
    public static final Pattern ALGORITHM_ATTR_VALUE_PATTERN = Pattern.compile("^algorithm=\"(.+)\"$");
    public static final String ATTR_HEADER_NAME = "attr";
    public static final String ATTR_HEADER_NAME_SUFFIX = ".attr";
    public static final String FILE_HEADER = "File";
    public static final String OBJECT_FIlES_HEADER = "ObjectFiles";
    public static final String API_FIELD_TITLE = "Title";
    public static final String API_FIELD_TITLE_ = "Title_";
    public static final String API_FIELD_DESCRIPTION = "Description";
    public static final String API_FIELD_DESCRIPTION_ = "Description_";
    public static final String RULE_FIELD_NAME = "Rule";
    public static final String RULES_PREFIX = "Rules";
    public static final String RULES_SEPARATOR_PREFIX = "Rules.";
    public static final String IMPLICIT_0_ARRAY_INDEX = "0";
    public static final Set<String> FORBIDDEN_CONTENT_SEDA_PATHS = Collections.singleton("Content.ArchiveUnitProfile");

    public static String buildPath(String basePath, String subPath) {
        if (basePath == null && subPath == null) {
            return null;
        }
        if (basePath == null) {
            return subPath;
        }
        if (subPath == null) {
            return basePath;
        }
        return basePath + SEPARATOR + subPath;
    }

    public static boolean isFileField(String headerName) {
        return headerName.equals(FILE_HEADER);
    }

    public static boolean IsObjectFilesField(String headerName) {
        return headerName.equals(OBJECT_FIlES_HEADER);
    }

    public static boolean isContentField(String headerName) {
        return headerName.startsWith(CONTENT_SEPARATOR) && headerName.length() > CONTENT_SEPARATOR.length();
    }

    public static boolean isManagementField(String headerName) {
        return headerName.startsWith(MANAGEMENT_SEPARATOR) && headerName.length() > MANAGEMENT_SEPARATOR.length() || CsvMetadataUtils.equalsOrStartsWith(headerName, ARCHIVE_UNIT_PROFILE);
    }

    public static boolean isManagementUpdateOperationField(String headerName) {
        return CsvMetadataUtils.equalsOrStartsWith(headerName, MANAGEMENT_UPDATE_OPERATION);
    }

    public static boolean isContentTitleField(String headerName) {
        return CsvMetadataUtils.equalsOrStartsWith(headerName, CONTENT_TITLE);
    }

    public static boolean isContentDescriptionField(String headerName) {
        return CsvMetadataUtils.equalsOrStartsWith(headerName, CONTENT_DESCRIPTION);
    }

    public static boolean matchesPattern(String value, Pattern pattern) {
        return pattern.matcher(value).matches();
    }

    public static boolean equalsOrStartsWith(String str, String prefix) {
        return str.equals(prefix) || str.startsWith(prefix + SEPARATOR);
    }
}

