/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.csv;

import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.collect.internal.core.common.CollectJsonMetadataLine;
import fr.gouv.vitam.collect.internal.core.csv.CsvErrorAccumulator;
import fr.gouv.vitam.collect.internal.core.csv.CsvToJsonConverter;
import fr.gouv.vitam.collect.internal.core.csv.SedaSchemaInfoResolver;
import fr.gouv.vitam.collect.internal.core.exceptions.CollectInvalidCsvFormatException;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class CsvHelper {
    private static final int MAX_PATH_LENGTH = 255;

    private CsvHelper() {
    }

    public static void convertCsvToJsonlMetadataFile(SedaSchemaInfoResolver sedaSchemaInfoResolver, InputStream is, File metadataFile, boolean isFirstUpload, boolean explicitAttachementMode) throws IOException, CollectInvalidCsvFormatException {
        try (CSVParser parser = CsvHelper.createParser(is);
             JsonLineWriter writer = new JsonLineWriter((OutputStream)new FileOutputStream(metadataFile, true), true);){
            List headerNames = parser.getHeaderNames();
            CsvToJsonConverter csvToJsonConverter = new CsvToJsonConverter(sedaSchemaInfoResolver, headerNames, isFirstUpload);
            try (CsvErrorAccumulator csvErrorAccumulator = new CsvErrorAccumulator();){
                for (CSVRecord record : parser) {
                    Optional<CollectJsonMetadataLine> collectJsonMetadataLine = CsvHelper.processRecord(record, headerNames, isFirstUpload, explicitAttachementMode, csvErrorAccumulator, parser, csvToJsonConverter);
                    if (!collectJsonMetadataLine.isPresent()) continue;
                    writer.addEntry((Object)collectJsonMetadataLine.get());
                }
            }
        }
    }

    private static Optional<CollectJsonMetadataLine> processRecord(CSVRecord record, List<String> headerNames, boolean isFirstUpload, boolean explicitAttachementMode, CsvErrorAccumulator csvErrorAccumulator, CSVParser parser, CsvToJsonConverter csvToJsonConverter) throws CollectInvalidCsvFormatException {
        String objectFilesPath;
        long csvRecordNumberIncludingHeader = record.getRecordNumber() + 1L;
        if (CsvHelper.hasInconsistentRecordColumns(record, headerNames, csvErrorAccumulator, csvRecordNumberIncludingHeader)) {
            return Optional.empty();
        }
        String uploadPath = FilenameUtils.separatorsToUnix((String)record.get("File"));
        if (CsvHelper.hasMissingUploadPath(csvErrorAccumulator, uploadPath, csvRecordNumberIncludingHeader) || CsvHelper.hasIllegalUploadPath(csvErrorAccumulator, uploadPath, csvRecordNumberIncludingHeader)) {
            return Optional.empty();
        }
        String string = objectFilesPath = parser.getHeaderMap().containsKey("ObjectFiles") && StringUtils.isNotEmpty((CharSequence)record.get("ObjectFiles")) ? FilenameUtils.separatorsToUnix((String)record.get("ObjectFiles")) : null;
        if (objectFilesPath != null) {
            if (CsvHelper.isForbiddenObjectFilesForUpdateMode(isFirstUpload, csvErrorAccumulator, csvRecordNumberIncludingHeader, uploadPath)) {
                return Optional.empty();
            }
            if (CsvHelper.hasIllegalObjectFilesField(csvErrorAccumulator, objectFilesPath, csvRecordNumberIncludingHeader, uploadPath)) {
                return Optional.empty();
            }
        }
        return CsvHelper.tryConvertCsvToJsonl(record, csvErrorAccumulator, csvToJsonConverter, uploadPath, objectFilesPath, explicitAttachementMode, csvRecordNumberIncludingHeader);
    }

    private static boolean hasInconsistentRecordColumns(CSVRecord record, List<String> headerNames, CsvErrorAccumulator csvErrorAccumulator, long csvRecordNumberIncludingHeader) throws CollectInvalidCsvFormatException {
        if (record.isConsistent()) {
            return false;
        }
        csvErrorAccumulator.report("Invalid CSV record at line %d: Nb columns (%d) must match nb headers (%d)".formatted(csvRecordNumberIncludingHeader, record.size(), headerNames.size()));
        return true;
    }

    private static boolean hasMissingUploadPath(CsvErrorAccumulator csvErrorAccumulator, String uploadPath, long csvRecordNumberIncludingHeader) throws CollectInvalidCsvFormatException {
        if (StringUtils.isNotBlank((CharSequence)uploadPath)) {
            return false;
        }
        csvErrorAccumulator.report("Invalid CSV record at line " + csvRecordNumberIncludingHeader + ": Empty File");
        return true;
    }

    private static boolean hasIllegalUploadPath(CsvErrorAccumulator csvErrorAccumulator, String uploadPath, long csvRecordNumberIncludingHeader) throws CollectInvalidCsvFormatException {
        String normalizedUploadPath = FilenameUtils.normalize((String)uploadPath);
        if (FilenameUtils.equals((String)uploadPath, (String)normalizedUploadPath)) {
            return false;
        }
        csvErrorAccumulator.report("Invalid CSV record at line %d: Illegal '%s' value '%s'".formatted(csvRecordNumberIncludingHeader, "File", CsvHelper.sanitizeStringForLog(uploadPath, 255)));
        return true;
    }

    private static boolean isForbiddenObjectFilesForUpdateMode(boolean isFirstUpload, CsvErrorAccumulator csvErrorAccumulator, long csvRecordNumberIncludingHeader, String uploadPath) throws CollectInvalidCsvFormatException {
        if (isFirstUpload) {
            return false;
        }
        csvErrorAccumulator.report(String.format("Invalid CSV record at line %d (File=\"%s\"): %s field not supported for update operations", csvRecordNumberIncludingHeader, CsvHelper.sanitizeStringForLog(uploadPath, 255), "ObjectFiles"));
        return true;
    }

    private static boolean hasIllegalObjectFilesField(CsvErrorAccumulator csvErrorAccumulator, String objectFilesPath, long csvRecordNumberIncludingHeader, String uploadPath) throws CollectInvalidCsvFormatException {
        String normalizedObjectFilesPath = FilenameUtils.normalize((String)objectFilesPath);
        if (FilenameUtils.equals((String)objectFilesPath, (String)normalizedObjectFilesPath)) {
            return false;
        }
        csvErrorAccumulator.report(String.format("Invalid CSV record at line %d (File=\"%s\"): %s", csvRecordNumberIncludingHeader, CsvHelper.sanitizeStringForLog(uploadPath, 255), "Invalid 'ObjectFiles' value '" + CsvHelper.sanitizeStringForLog(objectFilesPath, 255) + "'"));
        return true;
    }

    private static Optional<CollectJsonMetadataLine> tryConvertCsvToJsonl(CSVRecord record, CsvErrorAccumulator csvErrorAccumulator, CsvToJsonConverter csvToJsonConverter, String uploadPath, String objectFilesPath, boolean explicitAttachementMode, long csvRecordNumberIncludingHeader) throws CollectInvalidCsvFormatException {
        try {
            boolean isTopLevelFolder = !uploadPath.contains(File.separator);
            ObjectNode unitJson = csvToJsonConverter.convertCsvRecordToJson(record, isTopLevelFolder, explicitAttachementMode);
            return Optional.of(new CollectJsonMetadataLine(uploadPath, objectFilesPath, null, unitJson));
        }
        catch (CollectInvalidCsvFormatException e) {
            csvErrorAccumulator.report(String.format("Invalid CSV record at line %d (File=\"%s\"): %s", csvRecordNumberIncludingHeader, CsvHelper.sanitizeStringForLog(uploadPath, 255), e.getMessage()));
            return Optional.empty();
        }
    }

    public static CSVParser createParser(InputStream is) throws IOException {
        InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);
        return new CSVParser((Reader)reader, CSVFormat.Builder.create((CSVFormat)CSVFormat.DEFAULT).setHeader(new String[0]).setTrim(true).setIgnoreEmptyLines(false).setDelimiter(';').build());
    }

    public static String sanitizeStringForLog(String uploadPath, int maxLength) {
        return StringUtils.abbreviate((String)StringEscapeUtils.escapeJava((String)uploadPath), (int)maxLength);
    }
}

