/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.thread;

import fr.gouv.vitam.common.thread.RunWithCustomExecutor;
import java.lang.annotation.Annotation;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.junit.ClassRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RunWithCustomExecutorRule
implements TestRule,
ClassRule {
    private final ExecutorService executor;

    public RunWithCustomExecutorRule(ExecutorService executor) {
        this.executor = executor;
    }

    public Statement apply(Statement base, Description description) {
        RunWithCustomExecutor annotation = (RunWithCustomExecutor)description.getAnnotation(RunWithCustomExecutor.class);
        if (annotation != null) {
            return new RunInVitamThreadStatement(base, annotation.timeout());
        }
        return base;
    }

    public Class<? extends Annotation> annotationType() {
        return RunWithCustomExecutor.class;
    }

    public int order() {
        return -1;
    }

    private class RunInVitamThreadStatement
    extends Statement {
        private final Statement baseStatement;
        private final long timeout;

        public RunInVitamThreadStatement(Statement base, long timeout) {
            this.baseStatement = base;
            this.timeout = timeout;
        }

        public void evaluate() throws Throwable {
            try {
                CompletableFuture<Void> run = CompletableFuture.runAsync(() -> {
                    try {
                        this.baseStatement.evaluate();
                    }
                    catch (Throwable e) {
                        throw new CompletionException(e);
                    }
                }, RunWithCustomExecutorRule.this.executor);
                if (this.timeout != 0L) {
                    run.get(this.timeout, TimeUnit.MILLISECONDS);
                } else {
                    run.get();
                }
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }
    }
}

