/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.elasticsearch;

import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;

public class ElasticsearchTestHelper {
    public static final String UNIT_MAPPING_ES_FROM_ANSIBLE = "deployment/environments/files/elasticsearch-mappings/unit-es-mapping.json";
    public static final String OG_MAPPING_ES_FROM_ANSIBLE = "deployment/environments/files/elasticsearch-mappings/og-es-mapping.json";
    public static final String ES_SETTINGS_FROM_ANSIBLE = "/deployment/ansible-vitam/roles/vitam/files/elasticsearch-settings/elasticsearch-configuration.json";

    public static String loadUnitMapping() {
        return ElasticsearchTestHelper.loadMapping(UNIT_MAPPING_ES_FROM_ANSIBLE);
    }

    public static String loadObjectGroupMapping() {
        return ElasticsearchTestHelper.loadMapping(OG_MAPPING_ES_FROM_ANSIBLE);
    }

    public static String loadElasticSearchSettings() {
        return ElasticsearchTestHelper.loadMapping(ES_SETTINGS_FROM_ANSIBLE);
    }

    private static String loadMapping(String path) {
        String dir = Paths.get("", new String[0]).toAbsolutePath().toString();
        String userDir = StringUtils.substringBeforeLast((String)dir, (String)"sources/");
        return Paths.get(userDir, path).toString();
    }
}

