/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.Conflicts;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import co.elastic.clients.elasticsearch.core.DeleteByQueryRequest;
import co.elastic.clients.elasticsearch.core.DeleteByQueryResponse;
import co.elastic.clients.elasticsearch.indices.Alias;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import co.elastic.clients.elasticsearch.indices.CreateIndexResponse;
import co.elastic.clients.elasticsearch.indices.ExistsRequest;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.instrumentation.Instrumentation;
import co.elastic.clients.transport.instrumentation.NoopInstrumentation;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import com.google.common.collect.Sets;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.junit.rules.ExternalResource;

public class ElasticsearchRule
extends ExternalResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ElasticsearchRule.class);
    public static final int PORT = 9200;
    public static String HOST = "localhost";
    public static final String VITAM_CLUSTER = "elasticsearch-data";
    private boolean clientClosed = false;
    private final ElasticsearchClient client;
    private Set<String> indexesToBePurged = new HashSet<String>();

    public ElasticsearchRule(String ... indexesToBePurged) {
        RestClient restClient = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(HOST, 9200)}).build();
        RestClientTransport transport = new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper(), null, (Instrumentation)NoopInstrumentation.INSTANCE);
        this.client = new ElasticsearchClient((ElasticsearchTransport)transport);
        if (null != indexesToBePurged) {
            this.indexesToBePurged = Sets.newHashSet((Object[])indexesToBePurged);
        }
    }

    protected void after() {
        if (!this.clientClosed) {
            this.purge(this.client, this.indexesToBePurged);
        }
    }

    private void purge(ElasticsearchClient client, Collection<String> indexesToBePurged) {
        for (String indexName : indexesToBePurged) {
            this.purge(client, indexName);
        }
    }

    public void purge(ElasticsearchClient client, String indexName) {
        this.handlePurge(client, indexName, QueryBuilders.matchAll().build()._toQuery());
    }

    public void handlePurge(ElasticsearchClient client, String index, Query query) {
        try {
            DeleteByQueryRequest request = new DeleteByQueryRequest.Builder().index(index, new String[0]).conflicts(Conflicts.Proceed).query(query).scrollSize(Long.valueOf(VitamConfiguration.getMaxElasticsearchBulk())).scroll(ElasticsearchRule.timeOfMilliseconds(VitamConfiguration.getElasticSearchScrollTimeoutInMilliseconds())).timeout(ElasticsearchRule.timeOfMilliseconds(VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds())).refresh(Boolean.valueOf(true)).waitForCompletion(Boolean.valueOf(true)).build();
            DeleteByQueryResponse bulkResponse = client.deleteByQuery(request);
            LOGGER.debug("Purge : {}", (Object)bulkResponse);
            List searchFailures = bulkResponse.failures();
            if (CollectionUtils.isNotEmpty((Collection)searchFailures)) {
                throw new RuntimeException("ES purge errors : in search phase " + String.valueOf(bulkResponse));
            }
            LOGGER.info("Deleted : " + bulkResponse.deleted());
        }
        catch (ElasticsearchException e) {
            if (e.status() == Response.Status.NOT_FOUND.getStatusCode()) {
                return;
            }
            throw new RuntimeException("Purge Exception", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Purge Exception", e);
        }
    }

    public boolean existsIndex(String indexName) throws IOException {
        ExistsRequest existsRequest = new ExistsRequest.Builder().index(indexName.toLowerCase(), new String[0]).includeDefaults(Boolean.valueOf(false)).expandWildcards(ExpandWildcard.Open, new ExpandWildcard[0]).allowNoIndices(Boolean.valueOf(false)).build();
        return this.client.indices().exists(existsRequest).value();
    }

    public boolean createIndex(String aliasName, String indexName, String mapping) throws IOException {
        boolean existsIndex = this.existsIndex(indexName);
        if (Boolean.TRUE.equals(existsIndex)) {
            LOGGER.debug("Index (" + indexName + ") already exists");
            return true;
        }
        CreateIndexRequest request = new CreateIndexRequest.Builder().index(indexName).mappings(((TypeMapping.Builder)new TypeMapping.Builder().withJson((InputStream)new ByteArrayInputStream(mapping.getBytes(StandardCharsets.UTF_8)))).build()).aliases(Map.of(aliasName, new Alias.Builder().build())).timeout(ElasticsearchRule.timeOfMilliseconds(VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds())).masterTimeout(ElasticsearchRule.timeOfMinutes(1)).settings(new IndexSettings.Builder().numberOfShards("1").numberOfReplicas("0").build()).build();
        CreateIndexResponse response = this.getClient().indices().create(request);
        boolean acknowledged = response.acknowledged();
        boolean shardsAcknowledged = response.shardsAcknowledged();
        LOGGER.debug("Alias (" + aliasName + ") and index (" + indexName + ") create response acknowledged (" + acknowledged + ") and shardsAcknowledged (" + shardsAcknowledged + ") ");
        return acknowledged && shardsAcknowledged;
    }

    public final void purgeIndex(ElasticsearchClient client, String indexName) {
        this.purge(client, indexName);
    }

    public void deleteIndexesWithoutClose() {
        for (String indexName : this.indexesToBePurged) {
            this.purgeIndex(this.client, indexName);
        }
        this.indexesToBePurged = new HashSet<String>();
    }

    public void purgeIndices() {
        for (String indexName : this.indexesToBePurged) {
            this.purgeIndex(this.client, indexName);
        }
        this.indexesToBePurged = new HashSet<String>();
        this.close();
    }

    public ElasticsearchRule addIndexToBePurged(String indexName) {
        this.indexesToBePurged.add(indexName);
        return this;
    }

    public void handleAfter() {
        this.after();
    }

    public void handleAfter(Set<String> indexesToBePurged) {
        this.purge(this.client, indexesToBePurged);
    }

    public static String getClusterName() {
        return VITAM_CLUSTER;
    }

    public static int getPort() {
        return 9200;
    }

    public static String getHost() {
        return HOST;
    }

    public ElasticsearchClient getClient() {
        return this.client;
    }

    public void close() {
        try {
            ((ElasticsearchTransport)this.client._transport()).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.clientClosed = true;
    }

    private static Time timeOfMilliseconds(int duration) {
        return (Time)new Time.Builder().time(duration + "ms").build();
    }

    private static Time timeOfMinutes(int duration) {
        return (Time)new Time.Builder().time(duration + "m").build();
    }
}

