/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.client;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.client.VitamClientFactory;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.client.configuration.ClientConfigurationImpl;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.processing.WorkFlowExecutionContext;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientMock;
import fr.gouv.vitam.metadata.client.MetaDataClientRest;
import java.io.File;
import java.io.IOException;
import java.net.URI;

public class MetaDataClientFactory
extends VitamClientFactory<MetaDataClient> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MetaDataClientFactory.class);
    private static final String CONFIGURATION_FILENAME = "metadata-client.conf";
    private static final MetaDataClientFactory META_DATA_CLIENT_FACTORY = new MetaDataClientFactory("/metadata/v1");
    private static final MetaDataClientFactory META_DATA_COLLECT_CLIENT_FACTORY = new MetaDataClientFactory("/metadata-collect/v1");

    private MetaDataClientFactory(String resourcePath) {
        super(MetaDataClientFactory.changeConfigurationFile(CONFIGURATION_FILENAME), resourcePath, false);
    }

    public static MetaDataClientFactory getInstance() {
        return MetaDataClientFactory.getInstance(WorkFlowExecutionContext.VITAM);
    }

    public static MetaDataClientFactory getInstance(WorkFlowExecutionContext executionContext) {
        return switch (executionContext) {
            default -> throw new IncompatibleClassChangeError();
            case WorkFlowExecutionContext.VITAM -> META_DATA_CLIENT_FACTORY;
            case WorkFlowExecutionContext.COLLECT -> META_DATA_COLLECT_CLIENT_FACTORY;
        };
    }

    public MetaDataClient getClient() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Actually only one client implementation exists, so ignore client type value");
        }
        return switch (this.getVitamClientType()) {
            case VitamClientFactoryInterface.VitamClientType.MOCK -> new MetaDataClientMock();
            case VitamClientFactoryInterface.VitamClientType.PRODUCTION -> new MetaDataClientRest((VitamClientFactoryInterface<MetaDataClient>)this);
            default -> throw new IllegalArgumentException("metadata type unknown");
        };
    }

    static ClientConfiguration changeConfigurationFile(String configurationPath) {
        ClientConfiguration configuration = null;
        try {
            configuration = (ClientConfiguration)PropertiesUtils.readYaml((File)PropertiesUtils.findFile((String)configurationPath), ClientConfigurationImpl.class);
        }
        catch (IOException fnf) {
            LOGGER.debug("Error when retrieving configuration file {}, using mock", (Object)configurationPath, (Object)fnf);
        }
        if (configuration == null) {
            LOGGER.error("Error when retrieving configuration file {}, using mock", (Object)configurationPath);
        }
        return configuration;
    }

    public static void changeMode(ClientConfiguration configuration) {
        for (WorkFlowExecutionContext executionContext : WorkFlowExecutionContext.values()) {
            MetaDataClientFactory.getInstance(executionContext).initialisation(configuration, MetaDataClientFactory.getInstance(executionContext).getResourcePath());
        }
    }

    public static void changeMode(String serviceUrl, WorkFlowExecutionContext executionContext) {
        ParametersChecker.checkParameter((String)"Server Url can not be null", (String[])new String[]{serviceUrl});
        URI uri = URI.create(serviceUrl);
        ClientConfigurationImpl configuration = new ClientConfigurationImpl(uri.getHost(), uri.getPort());
        MetaDataClientFactory.changeMode((ClientConfiguration)configuration, executionContext);
    }

    public static void changeMode(ClientConfiguration configuration, WorkFlowExecutionContext executionContext) {
        MetaDataClientFactory instance = MetaDataClientFactory.getInstance(executionContext);
        instance.initialisation(configuration, instance.getResourcePath());
    }
}

