/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.format.identification.siegfried;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.BaseXx;
import fr.gouv.vitam.common.client.DefaultClient;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamRequestBuilder;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.format.identification.exception.FormatIdentifierNotFoundException;
import fr.gouv.vitam.common.format.identification.exception.FormatIdentifierTechnicalException;
import fr.gouv.vitam.common.format.identification.siegfried.SiegfriedClient;
import fr.gouv.vitam.common.format.identification.siegfried.SiegfriedClientFactory;
import fr.gouv.vitam.common.format.identification.siegfried.SiegfriedQueryParams;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import java.nio.file.Path;
import javax.ws.rs.core.Response;

public class SiegfriedClientRest
extends DefaultClient
implements SiegfriedClient {
    SiegfriedClientRest(SiegfriedClientFactory factory) {
        super((VitamClientFactoryInterface)factory);
    }

    @Override
    public RequestResponse<JsonNode> analysePath(Path filePath) throws FormatIdentifierTechnicalException, FormatIdentifierNotFoundException {
        RequestResponseOK requestResponseOK;
        block8: {
            String encodedFilePath = BaseXx.getBase64UrlWithPadding((byte[])filePath.toString().getBytes());
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/" + encodedFilePath).withQueryParam(SiegfriedQueryParams.FORMAT.getParameter(), SiegfriedQueryParams.FORMAT.getValue()).withQueryParam(SiegfriedQueryParams.BASE64.getParameter(), SiegfriedQueryParams.BASE64.getValue()).withQueryParam(SiegfriedQueryParams.SCAN_ENTRIES_WITHIN_ZIP.getParameter(), SiegfriedQueryParams.SCAN_ENTRIES_WITHIN_ZIP.getValue()).withJsonAccept();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponseOK = new RequestResponseOK().addResult(response.readEntity(JsonNode.class));
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new FormatIdentifierTechnicalException(e);
                }
            }
            response.close();
        }
        return requestResponseOK;
    }

    @Override
    public RequestResponse<JsonNode> status(Path filePath) throws FormatIdentifierTechnicalException, FormatIdentifierNotFoundException {
        return this.analysePath(filePath);
    }

    private void check(Response response) throws FormatIdentifierNotFoundException, FormatIdentifierTechnicalException {
        Response.Status status = response.getStatusInfo().toEnum();
        if (Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) {
            return;
        }
        String message = String.format("Error with the response, get status: '%d' and reason '%s'.", response.getStatus(), Response.Status.fromStatusCode((int)response.getStatus()).getReasonPhrase());
        if (Response.Status.NOT_FOUND.equals((Object)status)) {
            throw new FormatIdentifierNotFoundException(message);
        }
        throw new FormatIdentifierTechnicalException(message);
    }
}

