/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.builder.request.multiple;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.builder.facet.Facet;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.configuration.GlobalDatas;
import fr.gouv.vitam.common.database.builder.request.multiple.RequestMultiple;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import java.util.ArrayList;
import java.util.List;

public class SelectMultiQuery
extends RequestMultiple {
    protected List<Facet> facets = new ArrayList<Facet>();
    protected Long threshold;

    public final SelectMultiQuery resetFacets() {
        if (this.facets != null) {
            this.facets.clear();
        }
        return this;
    }

    public final SelectMultiQuery resetLimitFilter() {
        this.selectResetLimitFilter();
        return this;
    }

    public final SelectMultiQuery resetOrderByFilter() {
        this.selectResetOrderByFilter();
        return this;
    }

    public final SelectMultiQuery resetUsedProjection() {
        this.selectResetUsedProjection();
        return this;
    }

    public final SelectMultiQuery resetUsageProjection() {
        if (this.projection != null) {
            this.projection.remove(BuilderToken.PROJECTION.USAGE.exactToken());
        }
        return this;
    }

    @Override
    public final SelectMultiQuery reset() {
        super.reset();
        this.resetFacets();
        this.resetUsageProjection();
        this.selectReset();
        return this;
    }

    public final SelectMultiQuery setLimitFilter(long offset, long limit) {
        this.selectSetLimitFilter(offset, limit);
        return this;
    }

    public final SelectMultiQuery setLimitFilter(JsonNode filterContent) {
        this.selectSetLimitFilter(filterContent);
        return this;
    }

    public final SelectMultiQuery trackTotalHits(boolean trackTotalHits) {
        if (this.filter == null) {
            this.filter = JsonHandler.createObjectNode();
        }
        if (trackTotalHits) {
            this.filter.put(BuilderToken.SELECTFILTER.TRACK_TOTAL_HITS.exactToken(), true);
        } else {
            this.filter.remove(BuilderToken.SELECTFILTER.TRACK_TOTAL_HITS.exactToken());
        }
        return this;
    }

    public final SelectMultiQuery parseLimitFilter(String filter) throws InvalidParseOperationException {
        this.selectParseLimitFilter(filter);
        return this;
    }

    public final SelectMultiQuery addOrderByAscFilter(String ... variableNames) throws InvalidParseOperationException {
        this.selectAddOrderByAscFilter(variableNames);
        return this;
    }

    public final SelectMultiQuery addOrderByDescFilter(String ... variableNames) throws InvalidParseOperationException {
        this.selectAddOrderByDescFilter(variableNames);
        return this;
    }

    public final SelectMultiQuery addOrderByFilter(JsonNode filterContent) throws InvalidParseOperationException {
        this.selectAddOrderByFilter(filterContent);
        return this;
    }

    public final SelectMultiQuery parseOrderByFilter(String filter) throws InvalidParseOperationException {
        this.selectParseOrderByFilter(filter);
        return this;
    }

    @Override
    public final SelectMultiQuery setFilter(JsonNode filterContent) throws InvalidParseOperationException {
        super.setFilter(filterContent);
        this.selectSetFilter(filterContent);
        return this;
    }

    public final SelectMultiQuery addUsedProjection(String ... variableNames) throws InvalidParseOperationException {
        this.selectAddUsedProjection(variableNames);
        return this;
    }

    public final SelectMultiQuery addUnusedProjection(String ... variableNames) throws InvalidParseOperationException {
        this.selectAddUnusedProjection(variableNames);
        return this;
    }

    public final SelectMultiQuery addProjection(JsonNode projectionContent) {
        this.selectAddProjection(projectionContent);
        return this;
    }

    public final SelectMultiQuery parseProjection(String projection) throws InvalidParseOperationException {
        this.selectParseProjection(projection);
        return this;
    }

    public final SelectMultiQuery setUsageProjection(String usage) throws InvalidParseOperationException {
        GlobalDatas.sanityParameterCheck(usage);
        if (this.projection == null) {
            this.projection = JsonHandler.createObjectNode();
        }
        if (usage == null || usage.trim().isEmpty()) {
            return this;
        }
        this.projection.put(BuilderToken.PROJECTION.USAGE.exactToken(), usage.trim());
        return this;
    }

    public final SelectMultiQuery setUsageProjection(JsonNode projectionContent) throws InvalidParseOperationException {
        this.resetUsageProjection();
        if (projectionContent.has(BuilderToken.PROJECTION.USAGE.exactToken())) {
            this.setUsageProjection(projectionContent.get(BuilderToken.PROJECTION.USAGE.exactToken()).asText());
        }
        return this;
    }

    @Override
    protected final SelectMultiQuery selectSetProjection(JsonNode projectionContent) throws InvalidParseOperationException {
        super.selectSetProjection(projectionContent);
        this.setUsageProjection(projectionContent);
        return this;
    }

    public final SelectMultiQuery setProjection(JsonNode projectionContent) throws InvalidParseOperationException {
        this.selectSetProjection(projectionContent);
        return this;
    }

    public final ObjectNode getFinalSelect() {
        ObjectNode node = this.selectGetFinalSelect();
        this.addFacetsToNode(node);
        this.addThresholdToNode(node);
        return node;
    }

    public final ObjectNode getFinalSelectById() {
        ObjectNode objectNode = this.selectGetFinalSelect();
        objectNode.remove(BuilderToken.GLOBAL.ROOTS.exactToken());
        objectNode.remove(BuilderToken.GLOBAL.QUERY.exactToken());
        objectNode.remove(BuilderToken.GLOBAL.FILTER.exactToken());
        objectNode.remove(BuilderToken.GLOBAL.FACETS.exactToken());
        return objectNode;
    }

    protected void addFacetsToNode(ObjectNode node) {
        if (this.facets != null && !this.facets.isEmpty()) {
            ArrayNode array = JsonHandler.createArrayNode();
            for (Facet facet : this.facets) {
                array.add((JsonNode)facet.getCurrentFacet());
            }
            node.set(BuilderToken.GLOBAL.FACETS.exactToken(), (JsonNode)array);
        } else {
            node.putArray(BuilderToken.GLOBAL.FACETS.exactToken());
        }
    }

    private void addThresholdToNode(ObjectNode node) {
        if (this.threshold != null) {
            node.put(BuilderToken.GLOBAL.THRESOLD.exactToken(), this.threshold);
        }
    }

    @Override
    public final boolean getAllProjection() {
        return this.selectGetAllProjection();
    }

    @Override
    public final ObjectNode getProjection() {
        return this.selectGetProjection();
    }

    @Override
    public final List<Facet> getFacets() {
        return this.facets;
    }

    public final SelectMultiQuery addFacets(Facet ... facets) {
        for (Facet facet : facets) {
            ParametersChecker.checkParameter((String)"Facet is a mandatory parameter", (Object[])new Object[]{facet});
            this.facets.add(facet);
        }
        return this;
    }

    public SelectMultiQuery setFacet(Facet facet) {
        ParametersChecker.checkParameter((String)"Facet is a mandatory parameter", (Object[])new Object[]{facet});
        this.facets = new ArrayList<Facet>();
        this.facets.add(facet);
        return this;
    }

    public final SelectMultiQuery setScrollFilter(String scrollId, int scrollTimeout, int limit) {
        this.selectSetScrollFilter(scrollId, scrollTimeout, limit);
        return this;
    }

    @Override
    public Long getThreshold() {
        return this.threshold;
    }

    @Override
    public void setThreshold(Long threshold) {
        this.threshold = threshold;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("QUERY: ").append(super.toString());
        builder.append("\n\tProjection: ").append(this.projection);
        builder.append("\n\tFacets: ");
        for (Facet subrequest : this.getFacets()) {
            builder.append("\n").append(subrequest);
        }
        builder.append("\n\tThreshold: ").append(this.threshold);
        return builder.toString();
    }
}

