/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.builder.facet;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.facet.Facet;
import fr.gouv.vitam.common.database.builder.facet.RangeFacetValue;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import java.util.List;

public class DateRangeFacet
extends Facet {
    public DateRangeFacet(String name, String field, String nestdPath, String dateFormat, List<RangeFacetValue> ranges) throws InvalidCreateOperationException {
        super(name);
        this.populateFacet(name, field, nestdPath, dateFormat, ranges);
    }

    public DateRangeFacet(String name, String field, String dateFormat, List<RangeFacetValue> ranges) throws InvalidCreateOperationException {
        super(name);
        this.populateFacet(name, field, null, dateFormat, ranges);
    }

    private void populateFacet(String name, String field, String nestdPath, String dateFormat, List<RangeFacetValue> ranges) throws InvalidCreateOperationException {
        this.setName(name);
        this.currentTokenFACET = BuilderToken.FACET.DATE_RANGE;
        if (name == null || name.isEmpty()) {
            throw new InvalidCreateOperationException("name value is requested");
        }
        if (field == null || field.isEmpty()) {
            throw new InvalidCreateOperationException("field value is requested");
        }
        if (dateFormat == null || dateFormat.isEmpty()) {
            throw new InvalidCreateOperationException("dateFormat value is requested");
        }
        if (ranges == null || ranges.size() <= 0) {
            throw new InvalidCreateOperationException("Ranges must be > 0 ");
        }
        ObjectNode facetNode = JsonHandler.createObjectNode();
        facetNode.put(BuilderToken.FACETARGS.FIELD.exactToken(), field);
        if (nestdPath != null) {
            facetNode.put(BuilderToken.FACETARGS.SUBOBJECT.exactToken(), nestdPath);
        }
        facetNode.put(BuilderToken.FACETARGS.FORMAT.exactToken(), dateFormat);
        ArrayNode rangesNode = JsonHandler.createArrayNode();
        for (RangeFacetValue item : ranges) {
            ObjectNode rangeNode = JsonHandler.createObjectNode();
            if ((item.getFrom() == null || item.getFrom().isEmpty()) && (item.getTo() == null || item.getTo().isEmpty())) {
                throw new InvalidCreateOperationException("Either a 'from' or a 'to' value are requested");
            }
            rangeNode.put(BuilderToken.FACETARGS.FROM.exactToken(), item.getFrom());
            rangeNode.put(BuilderToken.FACETARGS.TO.exactToken(), item.getTo());
            rangesNode.add((JsonNode)rangeNode);
        }
        facetNode.set(BuilderToken.FACETARGS.RANGES.exactToken(), (JsonNode)rangesNode);
        this.currentFacet = facetNode;
    }
}

