/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.manifest.naming;

import fr.gouv.vitam.common.manifest.naming.ExtensionHelper;
import fr.gouv.vitam.common.manifest.naming.FileNameCleaner;
import fr.gouv.vitam.common.manifest.naming.FilenameResolver;
import fr.gouv.vitam.common.manifest.naming.GuidFilenameResolver;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class OriginalFilenameResolver
implements FilenameResolver {
    private static final String CONTENT_PREFIX = "Content/";
    private static final String PATH_SEPARATOR = "/";
    private static final int MAX_FILE_NAME_SIZE_LIMIT = 150;
    private final Set<String> resolvedPaths = new HashSet<String>();

    @Override
    public String resolve(String basePath, String objectId, String uri, String filename) {
        String fullPath = this.resolveFullPath(basePath, objectId, uri, filename);
        if (!this.resolvedPaths.add(fullPath)) {
            throw new IllegalStateException("Duplicate path '" + fullPath + "' for object with ID: " + objectId);
        }
        return fullPath;
    }

    private String resolveFullPath(String basePath, String objectId, String uri, String filename) {
        if (StringUtils.isEmpty((CharSequence)filename)) {
            return GuidFilenameResolver.INSTANCE.resolve(basePath, objectId, uri, filename);
        }
        String normalizedFilename = FileNameCleaner.cleanFileName(filename);
        String fullPath = OriginalFilenameResolver.getFullPath(basePath, normalizedFilename);
        if (!this.resolvedPaths.contains(fullPath) && normalizedFilename.length() < 150) {
            return fullPath;
        }
        return OriginalFilenameResolver.getFullPath(basePath, OriginalFilenameResolver.truncateAndAddSuffix(normalizedFilename, objectId));
    }

    private static String truncateAndAddSuffix(String filename, String objectId) {
        int maxLength = Math.min(150, filename.length() + 1 + objectId.length());
        String extension = ExtensionHelper.getExtension(filename);
        if (StringUtils.isNotEmpty((CharSequence)extension)) {
            return filename.substring(0, maxLength - extension.length() - 1 - objectId.length() - 1) + "_" + objectId + "." + extension;
        }
        return filename.substring(0, maxLength - objectId.length() - 1) + "_" + objectId;
    }

    private static String getFullPath(String basePath, String objectPath) {
        if (basePath.isEmpty()) {
            return CONTENT_PREFIX + objectPath;
        }
        return CONTENT_PREFIX + basePath + PATH_SEPARATOR + objectPath;
    }
}

