/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.manifest.naming;

import fr.gouv.vitam.common.security.SafeFileChecker;
import org.apache.commons.lang3.StringUtils;

public class FileNameCleaner {
    private FileNameCleaner() {
    }

    public static String cleanFileName(String fileName) {
        String stripped = StringUtils.stripAccents((String)fileName);
        stripped = stripped.replaceAll("[^a-zA-Z0-9.\\-_@]", "_");
        stripped = stripped.replaceAll("(^\\.+)|(\\.+$)", "");
        if ((stripped = stripped.replaceAll("\\.{2,}", ".")).isEmpty()) {
            stripped = "_";
        }
        if (SafeFileChecker.FILENAME_PATTERN.matcher(stripped).matches()) {
            return stripped;
        }
        throw new IllegalArgumentException("Cleaned filename is still invalid: " + stripped);
    }
}

