/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.server.DbRequestResult;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import fr.gouv.vitam.common.model.administration.OntologyType;
import fr.gouv.vitam.common.model.administration.schema.SchemaInputModel;
import fr.gouv.vitam.common.model.administration.schema.SchemaModel;
import fr.gouv.vitam.common.model.administration.schema.SchemaResponse;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.exception.schema.SchemaImportValidationException;
import fr.gouv.vitam.functional.administration.common.schema.ErrorReportSchema;
import fr.gouv.vitam.functional.administration.common.schema.Schema;
import fr.gouv.vitam.functional.administration.common.schema.SchemaErrorCode;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessReferential;
import fr.gouv.vitam.functional.administration.core.schema.SchemaCommonService;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class SchemaValidationService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SchemaValidationService.class);
    private static final Pattern PATH_PATTERN = Pattern.compile("^[a-zA-Z0-9]+(\\.[a-zA-Z0-9]+)*$");
    private final MongoDbAccessReferential mongoDbAccessReferential;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;

    public SchemaValidationService(MongoDbAccessReferential mongoDbAccessReferential, LogbookOperationsClientFactory logbookOperationsClientFactory) {
        this.mongoDbAccessReferential = mongoDbAccessReferential;
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
    }

    public void validateExternalSchemaInputs(List<SchemaInputModel> externalSchemaInputList, List<SchemaResponse> currentUnitSchemaList, Map<String, OntologyModel> ontologyEltsMapByIdentifier, Map<String, List<ErrorReportSchema>> importErrors) throws VitamException, InvalidCreateOperationException {
        this.validateExternalSchemaInputsConsistency(externalSchemaInputList, importErrors);
        Map<String, SchemaInputModel> externalSchemaInputsMapByPath = externalSchemaInputList.stream().collect(Collectors.toMap(SchemaInputModel::getPath, schemaModel -> schemaModel));
        Map<String, SchemaResponse> currentUnitSchemaMapByPath = currentUnitSchemaList.stream().collect(Collectors.toMap(schemaModel -> schemaModel.getPath().toLowerCase(), schemaModel -> schemaModel));
        Integer currentTenant = ParameterHelper.getTenantParameter();
        if (currentTenant.equals(VitamConfiguration.getAdminTenant())) {
            this.checkExistingPathsAllTenantSchemaForAdminTenant(externalSchemaInputsMapByPath, importErrors);
        }
        this.checkExistingPathsInCurrentSchema(currentUnitSchemaMapByPath, externalSchemaInputsMapByPath, importErrors);
        this.checkFullPathsReturnNotfound(currentUnitSchemaMapByPath, externalSchemaInputsMapByPath, importErrors);
        this.checkPathsWithOntology(externalSchemaInputsMapByPath, ontologyEltsMapByIdentifier, importErrors);
    }

    private void checkExistingPathsAllTenantSchemaForAdminTenant(Map<String, SchemaInputModel> externalSchemaInputsMapByPath, Map<String, List<ErrorReportSchema>> importErrors) throws VitamException, InvalidCreateOperationException {
        LOGGER.debug("Checking if paths already in schema of all tenants ");
        Set<Integer> tenants = VitamConfiguration.getTenants().stream().collect(Collectors.toSet());
        RequestResponseOK<SchemaModel> schemasResponse = this.findExternalSchema(SchemaCommonService.buildDslQueryForExtractingSchema(tenants, Collections.emptyList()));
        List unitSchemaForAllTenants = schemasResponse.getResults();
        Map<String, SchemaModel> currentUnitSchemaForAllTenantsMapByPath = unitSchemaForAllTenants.stream().collect(Collectors.toMap(SchemaModel::getPath, schemaModel -> schemaModel));
        List existingPathsInCurrentSchema = externalSchemaInputsMapByPath.keySet().stream().filter(externalSchemaPath -> currentUnitSchemaForAllTenantsMapByPath.containsKey(externalSchemaPath)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(existingPathsInCurrentSchema)) {
            LOGGER.error("Paths already in current schema for the current or other tenants");
            existingPathsInCurrentSchema.stream().forEach(schemaPath -> this.addError((String)schemaPath, new ErrorReportSchema(SchemaErrorCode.IMPORT_SCHEMA_PATH_ALREADY_IN_SCHEMA, (SchemaInputModel)externalSchemaInputsMapByPath.get(schemaPath), "Paths already in current schema for the current or other tenants"), importErrors));
            String message = String.format("Paths already in current schema for the current or other tenants = %s", existingPathsInCurrentSchema.stream().collect(Collectors.joining(", ")));
            throw new SchemaImportValidationException(message);
        }
    }

    private void checkExistingPathsInCurrentSchema(Map<String, SchemaResponse> currentUnitSchemaMapByPath, Map<String, SchemaInputModel> externalSchemaInputsMapByPath, Map<String, List<ErrorReportSchema>> importErrors) throws VitamException {
        List existingPathsInCurrentSchema;
        LOGGER.debug("Checking paths already in current schema");
        Integer currentTenant = ParameterHelper.getTenantParameter();
        if (currentTenant.equals(VitamConfiguration.getAdminTenant())) {
            List list = VitamConfiguration.getTenants();
        }
        if (!CollectionUtils.isEmpty(existingPathsInCurrentSchema = externalSchemaInputsMapByPath.keySet().stream().filter(externalSchemaPath -> currentUnitSchemaMapByPath.containsKey(externalSchemaPath.toLowerCase())).collect(Collectors.toList()))) {
            LOGGER.error("Paths already in current schema");
            existingPathsInCurrentSchema.stream().forEach(schemaPath -> this.addError((String)schemaPath, new ErrorReportSchema(SchemaErrorCode.IMPORT_SCHEMA_PATH_ALREADY_IN_SCHEMA, (SchemaInputModel)externalSchemaInputsMapByPath.get(schemaPath), "Path already in current schema"), importErrors));
            String message = String.format("Paths already in current schema = %s", existingPathsInCurrentSchema.stream().collect(Collectors.joining(", ")));
            throw new SchemaImportValidationException(message);
        }
    }

    private void validateExternalSchemaInputsConsistency(List<SchemaInputModel> externalSchemaInputList, Map<String, List<ErrorReportSchema>> importErrors) throws SchemaImportValidationException {
        LOGGER.debug("Validating external schema inputs consistency ");
        if (CollectionUtils.isEmpty(externalSchemaInputList)) {
            LOGGER.error("Empty schema list");
            throw new SchemaImportValidationException("Empty schema list");
        }
        HashMap<String, List> schemaInputsWithErrorsByAttribute = new HashMap<String, List>();
        for (SchemaInputModel schemaInputModel : externalSchemaInputList) {
            String description;
            String shortName;
            Matcher matcher = PATH_PATTERN.matcher(schemaInputModel.getPath());
            if (!matcher.find()) {
                schemaInputsWithErrorsByAttribute.computeIfAbsent("Path", k -> new ArrayList()).add(schemaInputModel);
            }
            if (StringUtils.isEmpty((CharSequence)(shortName = schemaInputModel.getShortName()))) {
                schemaInputsWithErrorsByAttribute.computeIfAbsent("ShortName", k -> new ArrayList()).add(schemaInputModel);
            }
            if (!StringUtils.isEmpty((CharSequence)(description = schemaInputModel.getDescription()))) continue;
            schemaInputsWithErrorsByAttribute.computeIfAbsent("Description", k -> new ArrayList()).add(schemaInputModel);
        }
        if (!schemaInputsWithErrorsByAttribute.isEmpty()) {
            LOGGER.error("Some inputs have validation errors");
            ArrayList<String> errorMessages = new ArrayList<String>();
            for (String attribute : schemaInputsWithErrorsByAttribute.keySet()) {
                boolean isPath = "Path".equals(attribute);
                List schemaInputModels = (List)schemaInputsWithErrorsByAttribute.get(attribute);
                for (SchemaInputModel inputSchema : schemaInputModels) {
                    this.addError(inputSchema.getPath(), new ErrorReportSchema(isPath ? SchemaErrorCode.IMPORT_SCHEMA_WRONG_PATH_FORMAT : SchemaErrorCode.IMPORT_SCHEMA_MISSING_INFORMATION, inputSchema, "Wrong attribute " + attribute), importErrors);
                }
                String paths = schemaInputModels.stream().map(SchemaInputModel::getPath).collect(Collectors.joining(", "));
                errorMessages.add(String.format("%s (%s)", attribute, paths));
            }
            String string = String.format("Some inputs have validation errors: %s", String.join((CharSequence)", ", errorMessages));
            throw new SchemaImportValidationException(string);
        }
    }

    private void checkFullPathsReturnNotfound(Map<String, SchemaResponse> currentUnitSchemaMapByPath, Map<String, SchemaInputModel> externalSchemaInputsMapByPath, Map<String, List<ErrorReportSchema>> importErrors) throws VitamException {
        LOGGER.debug("Checking parents paths ");
        ArrayList<String> pathsWithErrors = new ArrayList<String>();
        for (Map.Entry<String, SchemaInputModel> schemaModelEntry : externalSchemaInputsMapByPath.entrySet()) {
            this.checkExistingParentPath(currentUnitSchemaMapByPath, externalSchemaInputsMapByPath, schemaModelEntry.getKey(), pathsWithErrors);
        }
        if (!CollectionUtils.isEmpty(pathsWithErrors)) {
            LOGGER.error("Some paths with missing parents ");
            pathsWithErrors.stream().forEach(schemaPath -> this.addError((String)schemaPath, new ErrorReportSchema(SchemaErrorCode.IMPORT_SCHEMA_PATH_PARENT_MISSED, (SchemaInputModel)externalSchemaInputsMapByPath.get(schemaPath), "Paths with missing parents"), importErrors));
            String message = String.format("Paths with missing parents = %s", pathsWithErrors.stream().collect(Collectors.joining(", ")));
            throw new SchemaImportValidationException(message);
        }
    }

    private void checkSchemaPathsAreDeclaredAsOntologies(Map<String, SchemaInputModel> externalSchemaInputsByPath, Map<String, OntologyModel> ontologyByIdentifier, Map<String, List<ErrorReportSchema>> importErrors) throws SchemaImportValidationException {
        String baseMessage;
        List<String> leavesNotFoundInOntology = externalSchemaInputsByPath.values().stream().filter(SchemaInputModel::notObject).map(schemaModel -> SchemaCommonService.extractLeafFromPath(schemaModel.getPath())).collect(Collectors.toSet()).stream().filter(leaf -> !ontologyByIdentifier.containsKey(leaf)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(leavesNotFoundInOntology)) {
            return;
        }
        Map ontologyIdentifiersByLowerCase = ontologyByIdentifier.keySet().stream().collect(Collectors.groupingBy(String::toLowerCase, Collectors.toList()));
        HashSet wrongIdentifiers = new HashSet();
        HashMap<String, List> maybeWrongIdentifiers = new HashMap<String, List>();
        leavesNotFoundInOntology.forEach(leafNotFound -> {
            if (ontologyIdentifiersByLowerCase.containsKey(leafNotFound.toLowerCase())) {
                maybeWrongIdentifiers.put((String)leafNotFound, (List)ontologyIdentifiersByLowerCase.get(leafNotFound.toLowerCase()));
            } else {
                wrongIdentifiers.add(leafNotFound);
            }
        });
        if (CollectionUtils.isNotEmpty(wrongIdentifiers)) {
            baseMessage = "Path leaf not found in ontology";
            wrongIdentifiers.forEach(identifier -> this.addError((String)identifier, new ErrorReportSchema(SchemaErrorCode.IMPORT_SCHEMA_LEAF_NOT_FOUND, (SchemaInputModel)externalSchemaInputsByPath.get(identifier), "Path leaf not found in ontology"), importErrors));
        }
        if (MapUtils.isNotEmpty(maybeWrongIdentifiers)) {
            baseMessage = "Path leaf not found in ontology but it may be a mistake: ";
            maybeWrongIdentifiers.forEach((identifier, relatedIdentifiers) -> this.addError((String)identifier, new ErrorReportSchema(SchemaErrorCode.IMPORT_SCHEMA_LEAF_NOT_FOUND, (SchemaInputModel)externalSchemaInputsByPath.get(identifier), "Path leaf not found in ontology but it may be a mistake: " + String.join((CharSequence)", ", relatedIdentifiers)), importErrors));
        }
        List wrongIdentifiersMessages = wrongIdentifiers.stream().toList();
        List maybeWrongIdentifiersMessages = maybeWrongIdentifiers.entrySet().stream().map(entry -> (String)entry.getKey() + " (existing relative: " + String.join((CharSequence)", ", (Iterable)entry.getValue()) + ")").collect(Collectors.toList());
        String computedMessage = "Path leaf not found in ontology: " + String.join((CharSequence)", ", ListUtils.union(wrongIdentifiersMessages, maybeWrongIdentifiersMessages));
        LOGGER.error(computedMessage);
        throw new SchemaImportValidationException(computedMessage);
    }

    private void checkSchemaObjectPathsAreNotDeclaredAsOntologies(Map<String, SchemaInputModel> externalSchemaInputsMapByPath, Map<String, OntologyModel> ontologyEltsMapByIdentifier, Map<String, List<ErrorReportSchema>> importErrors) throws SchemaImportValidationException {
        String separator = ".";
        List<String> pathsWithOntologyConflicts = externalSchemaInputsMapByPath.values().stream().map(inputElement -> {
            String path = inputElement.isObject() != false ? inputElement.getPath() : StringUtils.substringBeforeLast((String)inputElement.getPath(), (String)".");
            return StringUtils.splitByWholeSeparator((String)path, (String)".");
        }).flatMap(Arrays::stream).collect(Collectors.toCollection(HashSet::new)).stream().filter(subPathElement -> {
            boolean isLeaf = ontologyEltsMapByIdentifier.containsKey(subPathElement);
            SchemaInputModel schemaInputModel = (SchemaInputModel)externalSchemaInputsMapByPath.get(subPathElement);
            if (schemaInputModel == null) {
                return isLeaf;
            }
            return isLeaf && schemaInputModel.isObject() != false;
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(pathsWithOntologyConflicts)) {
            String baseMessage = "Paths leafs declared as objects but already in ontology";
            this.checkErrors(pathsWithOntologyConflicts, "Paths leafs declared as objects but already in ontology", SchemaErrorCode.IMPORT_SCHEMA_PATH_OBJECT_IN_ONTOLOGY, externalSchemaInputsMapByPath, importErrors);
        }
    }

    private void checkSchemaDoesntMatchOntologyOfTypeGeoPoint(Map<String, SchemaInputModel> externalSchemaInputsMapByPath, Map<String, OntologyModel> ontologyEltsMapByIdentifier, Map<String, List<ErrorReportSchema>> importErrors) throws SchemaImportValidationException {
        List<String> pathsMatchingOntologyOfTypeGeoPoint = externalSchemaInputsMapByPath.values().stream().filter(schemaModelElt -> !Boolean.TRUE.equals(schemaModelElt.isObject())).map(schemaModelElt -> SchemaCommonService.extractLeafFromPath(schemaModelElt.getPath())).collect(Collectors.toSet()).stream().filter(leaf -> Optional.ofNullable((OntologyModel)ontologyEltsMapByIdentifier.get(leaf)).map(ontologyModel -> OntologyType.GEO_POINT.equals((Object)ontologyModel.getType())).orElse(false)).toList();
        if (CollectionUtils.isNotEmpty(pathsMatchingOntologyOfTypeGeoPoint)) {
            String baseMessage = "Path matches an ontology of type GEO_POINT";
            this.checkErrors(pathsMatchingOntologyOfTypeGeoPoint, "Path matches an ontology of type GEO_POINT", SchemaErrorCode.IMPORT_SCHEMA_LEAF_WRONG_TYPE, externalSchemaInputsMapByPath, importErrors);
        }
    }

    private void checkErrors(List<String> errorPaths, String baseMessage, SchemaErrorCode errorCode, Map<String, SchemaInputModel> externalSchemaInputsMapByPath, Map<String, List<ErrorReportSchema>> importErrors) throws SchemaImportValidationException {
        errorPaths.forEach(schemaPath -> this.addError((String)schemaPath, new ErrorReportSchema(errorCode, (SchemaInputModel)externalSchemaInputsMapByPath.get(schemaPath), baseMessage), importErrors));
        String conflictingPaths = String.join((CharSequence)", ", errorPaths);
        String message = String.format("%s = %s", baseMessage, conflictingPaths);
        LOGGER.error(message);
        throw new SchemaImportValidationException(message);
    }

    private void checkPathsWithOntology(Map<String, SchemaInputModel> externalSchemaInputsMapByPath, Map<String, OntologyModel> ontologyEltsMapByIdentifier, Map<String, List<ErrorReportSchema>> importErrors) throws VitamException {
        this.checkSchemaPathsAreDeclaredAsOntologies(externalSchemaInputsMapByPath, ontologyEltsMapByIdentifier, importErrors);
        this.checkSchemaObjectPathsAreNotDeclaredAsOntologies(externalSchemaInputsMapByPath, ontologyEltsMapByIdentifier, importErrors);
        this.checkSchemaDoesntMatchOntologyOfTypeGeoPoint(externalSchemaInputsMapByPath, ontologyEltsMapByIdentifier, importErrors);
    }

    private void checkExistingParentPath(Map<String, SchemaResponse> currentUnitSchemaMapByPath, Map<String, SchemaInputModel> externalInputSchemaMapByPath, String schemaPath, List<String> pathsWithErrors) {
        LOGGER.debug("Checking parent paths of {}  ", (Object)schemaPath);
        if (currentUnitSchemaMapByPath.containsKey(schemaPath.toLowerCase())) {
            return;
        }
        if (externalInputSchemaMapByPath.containsKey(schemaPath)) {
            if (schemaPath.contains(".")) {
                this.checkExistingParentPath(currentUnitSchemaMapByPath, externalInputSchemaMapByPath, StringUtils.substringBeforeLast((String)schemaPath, (String)"."), pathsWithErrors);
            }
        } else {
            pathsWithErrors.add(schemaPath);
        }
    }

    private RequestResponseOK<SchemaModel> findExternalSchema(JsonNode queryDsl) throws ReferentialException, InvalidParseOperationException {
        try (DbRequestResult result = this.mongoDbAccessReferential.findDocumentsWithoutRestrictionOnCurrentTenant(queryDsl, FunctionalAdminCollections.SCHEMA);){
            RequestResponseOK requestResponseOK = result.getRequestResponseOK(queryDsl, Schema.class, SchemaModel.class);
            return requestResponseOK;
        }
    }

    public void logValidationError(GUID operationGuid, String eventType, String errorsDetails) throws VitamException {
        LOGGER.error("Validation errors on the input file {}", (Object)errorsDetails);
        GUID eipId = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipId, (String)eventType, (GUID)operationGuid, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.KO, (String)VitamLogbookMessages.getCodeOp((String)eventType, (StatusCode)StatusCode.KO), (GUID)operationGuid);
        this.logbookMessageError(null, errorsDetails, logbookParameters);
        try (LogbookOperationsClient logbookOperationsClient = this.logbookOperationsClientFactory.getClient();){
            logbookOperationsClient.update(new LogbookOperationParameters[]{logbookParameters});
        }
    }

    private void logbookMessageError(String objectId, String errorsDetails, LogbookOperationParameters logbookParameters) {
        if (null != errorsDetails && !errorsDetails.isEmpty()) {
            try {
                ObjectNode object = JsonHandler.createObjectNode();
                object.put("schemaCheck", errorsDetails);
                String wellFormedJson = SanityChecker.sanitizeJson((JsonNode)object);
                logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, wellFormedJson);
            }
            catch (InvalidParseOperationException invalidParseOperationException) {
                // empty catch block
            }
        }
        if (null != objectId && !objectId.isEmpty()) {
            logbookParameters.putParameterValue(LogbookParameterName.objectIdentifier, objectId);
        }
    }

    public void startLogBook(GUID operationGuid, String eventType) throws LogbookClientBadRequestException, LogbookClientAlreadyExistsException, LogbookClientServerException {
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)operationGuid, (String)eventType, (GUID)operationGuid, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)eventType, (StatusCode)StatusCode.STARTED), (GUID)operationGuid);
        try (LogbookOperationsClient logbookOperationsClient = this.logbookOperationsClientFactory.getClient();){
            logbookOperationsClient.create(new LogbookOperationParameters[]{logbookParameters});
        }
    }

    public void logError(GUID operationGuid, String eventType, String objectId, String errorsDetails) throws VitamException {
        GUID eipId = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipId, (String)eventType, (GUID)operationGuid, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.KO, (String)VitamLogbookMessages.getCodeOp((String)eventType, (StatusCode)StatusCode.KO), (GUID)operationGuid);
        this.logbookMessageError(objectId, errorsDetails, logbookParameters);
        try (LogbookOperationsClient logbookOperationsClient = this.logbookOperationsClientFactory.getClient();){
            logbookOperationsClient.update(new LogbookOperationParameters[]{logbookParameters});
        }
    }

    public void logSuccessLogBook(GUID operationGuid, String eventType) throws VitamException {
        GUID eipId = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipId, (String)eventType, (GUID)operationGuid, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.OK, (String)VitamLogbookMessages.getCodeOp((String)eventType, (StatusCode)StatusCode.OK), (GUID)operationGuid);
        try (LogbookOperationsClient logbookOperationsClient = this.logbookOperationsClientFactory.getClient();){
            logbookOperationsClient.update(new LogbookOperationParameters[]{logbookParameters});
        }
    }

    public void addError(String path, ErrorReportSchema error, Map<String, List<ErrorReportSchema>> errors) {
        List<ErrorReportSchema> lineErrors = errors.get(path);
        if (lineErrors == null) {
            lineErrors = new ArrayList<ErrorReportSchema>();
        }
        lineErrors.add(error);
        errors.put(path, lineErrors);
    }
}

