/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.profile;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.administration.ProfileSedaVersion;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ProfileSax2Handler
extends DefaultHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ProfileSax2Handler.class);
    private ProfileSedaVersion sedaVersion = null;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        boolean isGrammarNode = qName.contains("grammar");
        boolean isSchemaNode = qName.contains("schema");
        if (!isGrammarNode && !isSchemaNode) {
            return;
        }
        String sedaVersion = this.extractVersion(attributes.getValue("xmlns"), attributes.getValue("xmlns:seda"), attributes.getValue("ns"));
        if (sedaVersion != null) {
            try {
                this.sedaVersion = ProfileSedaVersion.forVersion((String)sedaVersion);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Invalid Seda version {}, fallback to default.", (Object)sedaVersion);
                this.sedaVersion = ProfileSedaVersion.DEFAULT;
            }
        }
    }

    private String extractVersion(String ... namespaces) {
        for (String namespace : namespaces) {
            String[] parts;
            if (namespace == null || (parts = namespace.split(":")).length <= 0) continue;
            return parts[parts.length - 1].substring(1);
        }
        return null;
    }

    public ProfileSedaVersion getSedaVersion() {
        return this.sedaVersion;
    }
}

