/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.profile;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.mongodb.client.model.Filters;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.ProfileFormat;
import fr.gouv.vitam.common.model.administration.ProfileSedaVersion;
import fr.gouv.vitam.common.model.administration.ProfileStatus;
import fr.gouv.vitam.common.model.administration.profile.ProfileModel;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.xml.RngValidator;
import fr.gouv.vitam.common.xml.SecureXMLFactoryUtils;
import fr.gouv.vitam.common.xml.XsdValidator;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.core.profile.ProfileValidator;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.bson.conversions.Bson;
import org.xml.sax.SAXException;

public class ProfileManager {
    public static final String EMPTY_REQUIRED_FIELD = "STP_IMPORT_PROFILE_JSON.EMPTY_REQUIRED_FIELD.KO";
    public static final String WRONG_FIELD_FORMAT = "STP_IMPORT_PROFILE_JSON.TO_BE_DEFINED.KO";
    public static final String DUPLICATE_IN_DATABASE = "STP_IMPORT_PROFILE_JSON.IDENTIFIER_DUPLICATION.KO";
    public static final String PROFILE_NOT_FOUND_IN_DATABASE = "STP_IMPORT_PROFILE_JSON.PROFILE_NOT_FOUND.KO";
    public static final String IMPORT_KO = "STP_IMPORT_PROFILE_JSON.KO";
    public static final String UPDATE_PROFILE_NOT_FOUND = "STP_UPDATE_PROFILE_JSON.PROFILE_NOT_FOUND.KO";
    public static final String UPDATE_VALUE_NOT_IN_ENUM = "STP_UPDATE_PROFILE_JSON.NOT_IN_ENUM.KO";
    public static final String UPDATE_DUPLICATE_IN_DATABASE = "STP_UPDATE_PROFILE_JSON.IDENTIFIER_DUPLICATION.KO";
    public static final String UPDATE_KO = "STP_UPDATE_PROFILE_JSON.KO";
    private static final String PROFILE_SERVICE_ERROR = "Profile service Error";
    private static final String FUNCTIONAL_MODULE_PROFILE = "FunctionalModule-Profile";
    private static final String PARSE_PROFILE_DATE_ERROR = "Error profile parse dates";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ProfileManager.class);
    private final Map<ProfileValidator, String> validators = new HashMap<ProfileValidator, String>();
    private final GUID eip;
    private final LogbookOperationsClient logbookClient;

    public ProfileManager(LogbookOperationsClient logbookClient, GUID eip) {
        this.logbookClient = logbookClient;
        this.eip = eip;
        this.validators.put(this.createMandatoryParamsValidator(), EMPTY_REQUIRED_FIELD);
        this.validators.put(this.createWrongFieldFormatValidator(), EMPTY_REQUIRED_FIELD);
        this.validators.put(this.createCheckDuplicateInDatabaseValidator(), DUPLICATE_IN_DATABASE);
    }

    public boolean validateProfile(ProfileModel profile, VitamError error) {
        for (ProfileValidator validator : this.validators.keySet()) {
            Optional<ProfileValidator.RejectionCause> result = validator.validate(profile);
            if (!result.isPresent()) continue;
            error.addToErrors(this.getVitamError(result.get().getReason()).setDescription(result.get().getReason()).setMessage(this.validators.get(validator)));
            return false;
        }
        return true;
    }

    public boolean validateProfileFile(ProfileModel profileModel, File file, VitamError error) throws Exception {
        if (null == profileModel) {
            error.addToErrors(this.getVitamError("Profile metadata not found for the corresponding inputstream"));
            return false;
        }
        switch (profileModel.getFormat()) {
            case XSD: {
                return this.validateXSD(file, error);
            }
            case RNG: {
                return this.validateRNG(file, error);
            }
        }
        error.addToErrors(this.getVitamError("Profile format not supported"));
        return false;
    }

    public boolean validateXSD(File file, VitamError error) throws Exception {
        try {
            new XsdValidator(file);
        }
        catch (SAXException e) {
            LOGGER.error("Malformed profile xsd file", (Throwable)e);
            return false;
        }
        return this.checkTag(file, "xsd", "schema", error);
    }

    private boolean checkTag(File file, String prefix, String element, VitamError error) throws FileNotFoundException, XMLStreamException {
        XMLEventReader eventReader = SecureXMLFactoryUtils.createSecureXMLEventReader((InputStream)new FileInputStream(file));
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (event.isStartDocument() || !event.isStartElement()) continue;
            String elementName = event.asStartElement().getName().getLocalPart();
            String elementPrefix = event.asStartElement().getName().getPrefix();
            if (!Objects.equals(element, elementName) && !Objects.equals(prefix, elementPrefix)) continue;
            error.addToErrors(this.getVitamError("Profile file xsd have not the xsd:schema tag name"));
            return true;
        }
        return false;
    }

    private VitamError getVitamError(String error) {
        return new VitamError(VitamCode.PROFILE_VALIDATION_ERROR.getItem()).setMessage(PROFILE_SERVICE_ERROR).setState("ko").setContext(FUNCTIONAL_MODULE_PROFILE).setDescription(error);
    }

    public boolean validateRNG(File file, VitamError error) throws Exception {
        try {
            new RngValidator(file);
        }
        catch (SAXException e) {
            LOGGER.error("Malformed profile rng file", (Throwable)e);
            return false;
        }
        return this.checkTag(file, "rng", "grammar", error);
    }

    public void logValidationError(String eventType, String objectId, String errorsDetails, String eventTypeKO) throws VitamException {
        LOGGER.error("There are validation errors on the input file {}", (Object)errorsDetails);
        GUID eipId = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipId, (String)eventType, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.KO, (String)VitamLogbookMessages.getFromFullCodeKey((String)eventTypeKO), (GUID)this.eip);
        logbookParameters.putParameterValue(LogbookParameterName.outcomeDetail, eventTypeKO);
        this.logbookMessageError(objectId, errorsDetails, logbookParameters, eventTypeKO);
        this.logbookClient.update(new LogbookOperationParameters[]{logbookParameters});
    }

    private void logbookMessageError(String objectId, String errorsDetails, LogbookOperationParameters logbookParameters) {
        if (null != errorsDetails && !errorsDetails.isEmpty()) {
            try {
                ObjectNode object = JsonHandler.createObjectNode();
                object.put("profileCheck", errorsDetails);
                String wellFormedJson = SanityChecker.sanitizeJson((JsonNode)object);
                logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, wellFormedJson);
            }
            catch (InvalidParseOperationException invalidParseOperationException) {
                // empty catch block
            }
        }
        if (null != objectId && !objectId.isEmpty()) {
            logbookParameters.putParameterValue(LogbookParameterName.objectIdentifier, objectId);
        }
    }

    private void logbookMessageError(String objectId, String errorsDetails, LogbookOperationParameters logbookParameters, String eventTypeKO) {
        if (null != errorsDetails && !errorsDetails.isEmpty()) {
            try {
                ObjectNode object = JsonHandler.createObjectNode();
                object.put(switch (eventTypeKO) {
                    case EMPTY_REQUIRED_FIELD -> "Mandatory Fields";
                    case WRONG_FIELD_FORMAT -> "Incorrect Field and value";
                    case DUPLICATE_IN_DATABASE, UPDATE_DUPLICATE_IN_DATABASE -> "Duplicate Field";
                    case PROFILE_NOT_FOUND_IN_DATABASE, UPDATE_PROFILE_NOT_FOUND -> "Profile not found";
                    case UPDATE_VALUE_NOT_IN_ENUM -> "Not in Enum";
                    default -> " profileCheck";
                }, errorsDetails);
                String wellFormedJson = SanityChecker.sanitizeJson((JsonNode)object);
                logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, wellFormedJson);
            }
            catch (InvalidParseOperationException invalidParseOperationException) {
                // empty catch block
            }
        }
        if (null != objectId && !objectId.isEmpty()) {
            logbookParameters.putParameterValue(LogbookParameterName.objectIdentifier, objectId);
        }
    }

    public void logFatalError(String eventType, String objectId, String errorsDetails) throws VitamException {
        LOGGER.error("There are validation errors on the input file {}", (Object)errorsDetails);
        GUID eipId = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipId, (String)eventType, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.FATAL, (String)VitamLogbookMessages.getCodeOp((String)eventType, (StatusCode)StatusCode.FATAL), (GUID)this.eip);
        this.logbookMessageError(objectId, errorsDetails, logbookParameters);
        this.logbookClient.update(new LogbookOperationParameters[]{logbookParameters});
    }

    public void logStarted(String eventType, String objectId) throws VitamException {
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)this.eip, (String)eventType, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)eventType, (StatusCode)StatusCode.STARTED), (GUID)this.eip);
        this.logbookMessageError(objectId, null, logbookParameters);
        this.logbookClient.create(new LogbookOperationParameters[]{logbookParameters});
    }

    public void logSuccess(String eventType, String objectId, String message) throws VitamException {
        GUID eipId = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipId, (String)eventType, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.OK, (String)VitamLogbookMessages.getCodeOp((String)eventType, (StatusCode)StatusCode.OK), (GUID)this.eip);
        if (null != objectId && !objectId.isEmpty()) {
            logbookParameters.putParameterValue(LogbookParameterName.objectIdentifier, objectId);
        }
        if (null != message && !message.isEmpty()) {
            logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, message);
        }
        this.logbookClient.update(new LogbookOperationParameters[]{logbookParameters});
    }

    public ProfileValidator createMandatoryParamsValidator() {
        return profile -> {
            ArrayList<String> missingParams = new ArrayList<String>();
            if (profile.getFormat() == null || !profile.getFormat().equals((Object)ProfileFormat.RNG) && !profile.getFormat().equals((Object)ProfileFormat.XSD)) {
                missingParams.add("Format");
            }
            if (profile.getName() == null || profile.getName().length() == 0) {
                missingParams.add("Name");
            }
            return missingParams.isEmpty() ? Optional.empty() : Optional.of(ProfileValidator.RejectionCause.rejectSeveralMandatoryMissing(missingParams));
        };
    }

    public ProfileValidator createWrongFieldFormatValidator() {
        return profile -> {
            ProfileValidator.RejectionCause rejection = null;
            String now = LocalDateUtil.nowFormatted();
            if (profile.getStatus() == null) {
                profile.setStatus(ProfileStatus.INACTIVE);
            }
            if (profile.getSedaVersion() == null) {
                profile.setSedaVersion(ProfileSedaVersion.DEFAULT);
            }
            try {
                if (profile.getCreationDate() == null || profile.getCreationDate().trim().isEmpty()) {
                    profile.setCreationDate(now);
                } else {
                    profile.setCreationDate(LocalDateUtil.getFormattedDateTimeForMongo((String)profile.getCreationDate()));
                }
            }
            catch (Exception e) {
                LOGGER.error(PARSE_PROFILE_DATE_ERROR, (Throwable)e);
                rejection = ProfileValidator.RejectionCause.rejectMandatoryMissing("CreationDate");
            }
            try {
                if (profile.getActivationDate() == null || profile.getActivationDate().trim().isEmpty()) {
                    profile.setActivationDate(now);
                } else {
                    profile.setActivationDate(LocalDateUtil.getFormattedDateTimeForMongo((String)profile.getActivationDate()));
                }
            }
            catch (Exception e) {
                LOGGER.error(PARSE_PROFILE_DATE_ERROR, (Throwable)e);
                rejection = ProfileValidator.RejectionCause.rejectMandatoryMissing("ActivationDate");
            }
            try {
                if (profile.getDeactivationDate() == null || profile.getDeactivationDate().trim().isEmpty()) {
                    profile.setDeactivationDate(null);
                } else {
                    profile.setDeactivationDate(LocalDateUtil.getFormattedDateTimeForMongo((String)profile.getDeactivationDate()));
                }
            }
            catch (Exception e) {
                LOGGER.error(PARSE_PROFILE_DATE_ERROR, (Throwable)e);
                rejection = ProfileValidator.RejectionCause.rejectMandatoryMissing("DeactivationDate");
            }
            profile.setLastUpdate(now);
            return rejection == null ? Optional.empty() : Optional.of(rejection);
        };
    }

    public ProfileValidator createCheckDuplicateInDatabaseValidator() {
        return profile -> {
            if (ParametersChecker.isNotEmpty((String[])new String[]{profile.getIdentifier()})) {
                boolean exist;
                int tenant = ParameterHelper.getTenantParameter();
                Bson clause = Filters.and((Bson[])new Bson[]{Filters.eq((String)"_tenant", (Object)tenant), Filters.eq((String)"Identifier", (Object)profile.getIdentifier())});
                boolean bl = exist = FunctionalAdminCollections.PROFILE.getCollection().countDocuments(clause) > 0L;
                if (exist) {
                    return Optional.of(ProfileValidator.RejectionCause.rejectDuplicatedInDatabase(profile.getIdentifier()));
                }
            }
            return Optional.empty();
        };
    }
}

