/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.griffin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.functional.administration.core.griffin.GriffinReport;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;

class LogbookGriffinHelper {
    LogbookGriffinHelper() {
        throw new IllegalStateException("Utility class");
    }

    static void createLogbook(LogbookOperationsClientFactory factory, GUID guid, String stepName) throws LogbookClientBadRequestException, LogbookClientAlreadyExistsException, LogbookClientServerException {
        String codeOp = VitamLogbookMessages.getCodeOp((String)stepName, (StatusCode)StatusCode.STARTED);
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)guid, (String)stepName, (GUID)guid, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)codeOp, (GUID)guid);
        String parameterValue = stepName + "." + String.valueOf(StatusCode.STARTED);
        logbookParameters.putParameterValue(LogbookParameterName.outcomeDetail, parameterValue);
        try (LogbookOperationsClient client = factory.getClient();){
            client.create(new LogbookOperationParameters[]{logbookParameters});
        }
    }

    static void createLogbookEventSuccess(LogbookOperationsClientFactory factory, GUID guid, String stepName) throws LogbookClientBadRequestException, LogbookClientServerException, LogbookClientNotFoundException {
        GUID guiEvent = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        String codeOp = VitamLogbookMessages.getCodeOp((String)stepName, (StatusCode)StatusCode.OK);
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)guiEvent, (String)stepName, (GUID)guid, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.OK, (String)codeOp, (GUID)guid);
        String parameterValue = stepName + "." + String.valueOf(StatusCode.OK);
        logbookParameters.putParameterValue(LogbookParameterName.outcomeDetail, parameterValue);
        try (LogbookOperationsClient client = factory.getClient();){
            client.update(new LogbookOperationParameters[]{logbookParameters});
        }
    }

    static void createLogbookEventWarning(LogbookOperationsClientFactory factory, GUID guid, String stepName, GriffinReport warnings) throws LogbookClientBadRequestException, LogbookClientServerException, LogbookClientNotFoundException {
        GUID guiEvent = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        String codeOp = VitamLogbookMessages.getCodeOp((String)stepName, (StatusCode)StatusCode.WARNING);
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)guiEvent, (String)stepName, (GUID)guid, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.WARNING, (String)codeOp, (GUID)guid);
        String parameterValue = stepName + "." + String.valueOf(StatusCode.WARNING);
        logbookParameters.putParameterValue(LogbookParameterName.outcomeDetail, parameterValue);
        logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, JsonHandler.unprettyPrint((Object)warnings));
        try (LogbookOperationsClient client = factory.getClient();){
            client.update(new LogbookOperationParameters[]{logbookParameters});
        }
    }

    static void createLogbookEventKo(LogbookOperationsClientFactory factory, GUID guid, String stepName, String error) throws LogbookClientBadRequestException, LogbookClientServerException, LogbookClientNotFoundException, InvalidParseOperationException {
        GUID guiEvent = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        String codeOp = VitamLogbookMessages.getCodeOp((String)stepName, (StatusCode)StatusCode.KO);
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)guiEvent, (String)stepName, (GUID)guid, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.KO, (String)codeOp, (GUID)guid);
        String parameterValue = stepName + "." + String.valueOf(StatusCode.KO);
        logbookParameters.putParameterValue(LogbookParameterName.outcomeDetail, parameterValue);
        ObjectNode object = JsonHandler.createObjectNode();
        object.put("ErrorDetail", error);
        String wellFormedJson = SanityChecker.sanitizeJson((JsonNode)object);
        logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, wellFormedJson);
        try (LogbookOperationsClient client = factory.getClient();){
            client.update(new LogbookOperationParameters[]{logbookParameters});
        }
    }
}

