/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.griffin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.collections.VitamCollection;
import fr.gouv.vitam.common.database.server.DbRequestResult;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.DocumentAlreadyExistsException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.SchemaValidationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.preservation.DefaultGriffin;
import fr.gouv.vitam.common.model.administration.preservation.GriffinByFormat;
import fr.gouv.vitam.common.model.administration.preservation.GriffinModel;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.common.Griffin;
import fr.gouv.vitam.functional.administration.common.PreservationScenario;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminImpl;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessReferential;
import fr.gouv.vitam.functional.administration.core.backup.FunctionalBackupService;
import fr.gouv.vitam.functional.administration.core.format.model.FunctionalOperationModel;
import fr.gouv.vitam.functional.administration.core.griffin.GriffinReport;
import fr.gouv.vitam.functional.administration.core.griffin.LogbookGriffinHelper;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.Response;

public class GriffinService {
    private static final String GRIFFIN_BACKUP_EVENT = "STP_BACKUP_GRIFFIN";
    private static final String GRIFFIN_IMPORT_EVENT = "STP_IMPORT_GRIFFIN";
    private static final String GRIFFIN_REPORT = "GRIFFIN_REPORT";
    private static final String UND_TENANT = "_tenant";
    private final VitamCollection<PreservationScenario> preservationScenarioCollection;
    private final MongoDbAccessReferential mongoDbAccess;
    private final FunctionalBackupService functionalBackupService;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;

    @VisibleForTesting
    GriffinService(MongoDbAccessReferential mongoDbAccess, FunctionalBackupService functionalBackupService, LogbookOperationsClientFactory logbookOperationsClientFactory, VitamCollection<PreservationScenario> preservationScenarioCollection) {
        this.mongoDbAccess = mongoDbAccess;
        this.functionalBackupService = functionalBackupService;
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
        this.preservationScenarioCollection = preservationScenarioCollection;
    }

    public GriffinService(MongoDbAccessAdminImpl mongoAccess, FunctionalBackupService functionalBackupService) {
        this((MongoDbAccessReferential)mongoAccess, functionalBackupService, LogbookOperationsClientFactory.getInstance(), (VitamCollection<PreservationScenario>)FunctionalAdminCollections.PRESERVATION_SCENARIO.getVitamCollection());
    }

    public RequestResponse<GriffinModel> importGriffin(@NotNull List<GriffinModel> griffinsFromRequest) throws VitamException, InvalidCreateOperationException {
        String operationId = VitamThreadUtils.getVitamSession().getRequestId();
        GUID guid = GUIDReader.getGUID((String)operationId);
        LogbookGriffinHelper.createLogbook(this.logbookOperationsClientFactory, guid, GRIFFIN_IMPORT_EVENT);
        try {
            this.validate(griffinsFromRequest);
            HashSet<String> griffinIdsToDelete = new HashSet<String>();
            ArrayList<GriffinModel> griffinsToUpdate = new ArrayList<GriffinModel>();
            ArrayList<GriffinModel> griffinsToInsert = new ArrayList<GriffinModel>();
            ObjectNode finalSelect = new Select().getFinalSelect();
            DbRequestResult result = this.mongoDbAccess.findDocuments((JsonNode)finalSelect, FunctionalAdminCollections.GRIFFIN);
            List allGriffins = result.getDocuments(Griffin.class, GriffinModel.class);
            this.classifyDataInInsertUpdateOrDeleteLists(griffinsFromRequest, griffinsToInsert, griffinsToUpdate, griffinIdsToDelete, allGriffins);
            this.checkDeletion(griffinIdsToDelete);
            List<String> griffinIdsToUpdate = griffinsToUpdate.stream().map(GriffinModel::getIdentifier).collect(Collectors.toList());
            Set<String> griffinsToUpdateUsedByScenario = this.getGriffinIdentifierUsedByScenario(griffinIdsToUpdate);
            this.insertGriffins(griffinsToInsert);
            this.updateGriffins(griffinsToUpdate);
            this.deleteGriffins(griffinIdsToDelete);
            Set<String> griffinsIdsToInsert = griffinsToInsert.stream().map(GriffinModel::getIdentifier).collect(Collectors.toSet());
            GriffinReport griffinReport = this.generateReport(allGriffins, griffinsFromRequest, griffinIdsToUpdate, griffinIdsToDelete, griffinsIdsToInsert, griffinsToUpdateUsedByScenario);
            this.functionalBackupService.saveCollectionAndSequence(guid, GRIFFIN_BACKUP_EVENT, FunctionalAdminCollections.GRIFFIN, operationId);
            this.saveReport(guid, griffinReport);
            if (!griffinReport.getWarnings().isEmpty()) {
                LogbookGriffinHelper.createLogbookEventWarning(this.logbookOperationsClientFactory, guid, GRIFFIN_IMPORT_EVENT, GriffinReport.onlyWarning(griffinReport));
            } else {
                LogbookGriffinHelper.createLogbookEventSuccess(this.logbookOperationsClientFactory, guid, GRIFFIN_IMPORT_EVENT);
            }
            return new RequestResponseOK().addAllResults(griffinsFromRequest).setHttpCode(Response.Status.CREATED.getStatusCode());
        }
        catch (InvalidCreateOperationException | VitamException e) {
            LogbookGriffinHelper.createLogbookEventKo(this.logbookOperationsClientFactory, guid, GRIFFIN_IMPORT_EVENT, e.getMessage());
            throw e;
        }
    }

    private void saveReport(GUID guid, GriffinReport griffinReport) throws StorageException {
        try (InputStream reportInputStream = JsonHandler.writeToInpustream((Object)griffinReport);){
            String fileName = guid.getId() + ".json";
            this.functionalBackupService.saveFile(reportInputStream, guid, GRIFFIN_REPORT, DataCategory.REPORT, fileName);
        }
        catch (VitamException | IOException e) {
            throw new StorageException(e.getMessage(), e);
        }
    }

    private FunctionalOperationModel retrieveOperationModel() {
        try {
            JsonNode result = this.logbookOperationsClientFactory.getClient().selectOperationById(VitamThreadUtils.getVitamSession().getRequestId());
            return (FunctionalOperationModel)JsonHandler.getFromJsonNode((JsonNode)result.get("$results").get(0), FunctionalOperationModel.class);
        }
        catch (InvalidParseOperationException | LogbookClientException e) {
            throw new VitamRuntimeException("Could not load operation data", e);
        }
    }

    private GriffinReport generateReport(List<GriffinModel> currentGriffinsModels, List<GriffinModel> newGriffinsModels, List<String> updatedIdentifiers, Set<String> removedIdentifiers, Set<String> addedIdentifiers, Set<String> griffinIdentifiersUsedInPSC) {
        GriffinReport report = new GriffinReport();
        FunctionalOperationModel operationModel = this.retrieveOperationModel();
        report.setOperation(operationModel);
        if (!currentGriffinsModels.isEmpty()) {
            report.setPreviousGriffinsVersion(currentGriffinsModels.get(0).getExecutableVersion());
            report.setPreviousGriffinsCreationDate(currentGriffinsModels.get(0).getCreationDate());
        }
        if (!newGriffinsModels.isEmpty()) {
            report.setNewGriffinsVersion(newGriffinsModels.get(0).getExecutableVersion());
            report.setPreviousGriffinsCreationDate(newGriffinsModels.get(0).getCreationDate());
        }
        Map<String, GriffinModel> currentGriffinsModelsByIdentifiers = newGriffinsModels.stream().collect(Collectors.toMap(GriffinModel::getIdentifier, model -> model));
        Map<String, GriffinModel> newGriffinsModelByIdentifiers = newGriffinsModels.stream().collect(Collectors.toMap(GriffinModel::getIdentifier, model -> model));
        report.setRemovedIdentifiers(removedIdentifiers);
        report.setAddedIdentifiers(addedIdentifiers);
        this.reportUpdatedIdentifiers(updatedIdentifiers, report, currentGriffinsModelsByIdentifiers, newGriffinsModelByIdentifiers);
        this.reportVersioning(report);
        if (!griffinIdentifiersUsedInPSC.isEmpty()) {
            report.addWarning(String.format(" identifier(s) %s updated but they're already used in preservation scenarios.", griffinIdentifiersUsedInPSC.toString()));
        }
        if (report.getWarnings().isEmpty()) {
            return report.setStatusCode(StatusCode.OK);
        }
        return report.setStatusCode(StatusCode.WARNING);
    }

    private void reportVersioning(GriffinReport report) {
        if (report.getPreviousGriffinsCreationDate() != null && report.getNewGriffinsCreationDate() != null) {
            String newDate;
            String previousDate = LocalDateUtil.getFormattedDateTimeForMongo((String)report.getPreviousGriffinsCreationDate());
            if (previousDate.equals(newDate = LocalDateUtil.getFormattedDateTimeForMongo((String)report.getNewGriffinsCreationDate()))) {
                report.addWarning("Same referential date: " + report.getNewGriffinsCreationDate());
            }
            if (previousDate.compareTo(newDate) > 0) {
                report.addWarning("New imported referential date " + report.getNewGriffinsCreationDate() + " is older than previous report date " + report.getNewGriffinsCreationDate());
            }
        }
    }

    private void reportUpdatedIdentifiers(List<String> updatedIdentifiers, GriffinReport report, Map<String, GriffinModel> currentGriffinsModelsByIdentifiers, Map<String, GriffinModel> newGriffinsModelByIdentifiers) {
        for (String identifier : updatedIdentifiers) {
            GriffinModel currentGriffinModel = currentGriffinsModelsByIdentifiers.get(identifier);
            GriffinModel newGriffinModel = newGriffinsModelByIdentifiers.get(identifier);
            List<String> diff = this.diff(currentGriffinModel, newGriffinModel);
            report.addUpdatedIdentifiers(identifier, diff);
        }
    }

    private void validate(List<GriffinModel> listToImport) throws ReferentialException {
        Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
        ArrayList<String> identifiers = new ArrayList<String>();
        for (GriffinModel model : listToImport) {
            if (identifiers.contains(model.getIdentifier())) {
                throw new ReferentialException(String.format("Duplicate griffin : '%s'.", model.getIdentifier()));
            }
            Set constraint = validator.validate((Object)model, new Class[0]);
            if (!constraint.isEmpty()) {
                throw new ReferentialException(String.format("Invalid griffin for : '%s' : '%s'.", model.getIdentifier(), this.getConstraintsStrings(constraint)));
            }
            identifiers.add(model.getIdentifier());
        }
    }

    private void checkDeletion(Set<String> griffinsToDelete) throws ReferentialException {
        if (griffinsToDelete.isEmpty()) {
            return;
        }
        Set<String> griffinsToDeleteUsedByScenario = this.getGriffinIdentifierUsedByScenario(griffinsToDelete);
        if (!griffinsToDeleteUsedByScenario.isEmpty()) {
            throw new ReferentialException(String.format("Can not remove used griffin(s), %s.", String.join((CharSequence)", ", griffinsToDeleteUsedByScenario)));
        }
    }

    private Set<String> getGriffinIdentifierUsedByScenario(Collection<String> griffinIds) {
        if (griffinIds.isEmpty()) {
            return Collections.emptySet();
        }
        Spliterator preservationModels = this.preservationScenarioCollection.getCollection().find().map(PreservationScenario::toModel).spliterator();
        return StreamSupport.stream(preservationModels, false).flatMap(model -> Stream.concat(model.getGriffinByFormat().stream().map(GriffinByFormat::getGriffinIdentifier), Stream.of(model.getDefaultGriffin()).map(DefaultGriffin::getGriffinIdentifier))).filter(griffinIds::contains).collect(Collectors.toSet());
    }

    private String getConstraintsStrings(Set<ConstraintViolation<GriffinModel>> constraints) {
        ArrayList<CallSite> result = new ArrayList<CallSite>();
        for (ConstraintViolation<GriffinModel> constraintViolation : constraints) {
            result.add((CallSite)((Object)("'" + String.valueOf(constraintViolation.getPropertyPath()) + "' : " + constraintViolation.getMessage())));
        }
        return ((Object)result).toString();
    }

    private List<String> diff(GriffinModel griffinModel, GriffinModel newModel) {
        String after = this.toComparableString(newModel);
        String before = this.toComparableString(griffinModel);
        List concernedDiffLines = VitamDocument.getConcernedDiffLines((List)VitamDocument.getUnifiedDiff((String)before, (String)after));
        concernedDiffLines.sort(Comparator.naturalOrder());
        return concernedDiffLines;
    }

    private String toComparableString(GriffinModel griffinModel) {
        try {
            ObjectNode currentJsonNode = (ObjectNode)JsonHandler.toJsonNode((Object)griffinModel);
            currentJsonNode.remove("_id");
            currentJsonNode.remove("_v");
            currentJsonNode.remove("CreationDate");
            currentJsonNode.remove("LastUpdate");
            return JsonHandler.prettyPrint((Object)currentJsonNode);
        }
        catch (InvalidParseOperationException e) {
            throw new RuntimeException(e);
        }
    }

    void classifyDataInInsertUpdateOrDeleteLists(@NotNull List<GriffinModel> listToImport, @NotNull List<GriffinModel> listToInsert, @NotNull List<GriffinModel> listToUpdate, @NotNull Set<String> listToDelete, List<GriffinModel> allGriffinInDatabase) {
        Set<String> dataBaseIds = allGriffinInDatabase.stream().map(GriffinModel::getIdentifier).collect(Collectors.toSet());
        HashSet updateIds = new HashSet(dataBaseIds);
        Set importIds = listToImport.stream().map(GriffinModel::getIdentifier).collect(Collectors.toSet());
        updateIds.retainAll(importIds);
        HashSet removeIds = new HashSet(dataBaseIds);
        removeIds.removeAll(updateIds);
        listToDelete.addAll(removeIds);
        for (GriffinModel griffinModel : listToImport) {
            this.classifyModelToImportIntoInsertOrUpdateList(griffinModel, dataBaseIds, listToInsert, listToUpdate);
        }
    }

    private void classifyModelToImportIntoInsertOrUpdateList(@NotNull GriffinModel griffinModel, @NotNull Set<String> dataBaseIds, @NotNull List<GriffinModel> listToInsert, @NotNull List<GriffinModel> listToUpdate) {
        if (dataBaseIds.contains(griffinModel.getIdentifier())) {
            listToUpdate.add(griffinModel);
            return;
        }
        listToInsert.add(griffinModel);
    }

    private void insertGriffins(@NotNull List<GriffinModel> listToInsert) throws InvalidParseOperationException, ReferentialException, SchemaValidationException, DocumentAlreadyExistsException {
        if (listToInsert.isEmpty()) {
            return;
        }
        ArrayNode griffinToInsert = JsonHandler.createArrayNode();
        for (GriffinModel griffinModel : listToInsert) {
            griffinModel.setTenant(ParameterHelper.getTenantParameter());
            this.formatDateForMongo(griffinModel);
            griffinToInsert.add(this.toJson(griffinModel));
        }
        this.mongoDbAccess.insertDocuments(griffinToInsert, FunctionalAdminCollections.GRIFFIN);
    }

    private JsonNode toJson(@NotNull GriffinModel model) throws InvalidParseOperationException {
        JsonNode jsonNode;
        ObjectNode modelNode = (ObjectNode)JsonHandler.toJsonNode((Object)model);
        JsonNode hashTenant = modelNode.remove(VitamFieldsHelper.tenant());
        if (hashTenant != null) {
            modelNode.set(UND_TENANT, hashTenant);
        }
        if ((jsonNode = modelNode.remove(VitamFieldsHelper.id())) != null) {
            modelNode.set("_id", jsonNode);
        }
        return modelNode;
    }

    private void deleteGriffins(@NotNull Set<String> listIdsToDelete) throws ReferentialException, BadRequestException, SchemaValidationException, InvalidCreateOperationException {
        for (String identifier : listIdsToDelete) {
            Select select = new Select();
            select.setQuery((Query)QueryHelper.eq((String)"Identifier", (String)identifier));
            this.mongoDbAccess.deleteDocument((JsonNode)select.getFinalSelect(), FunctionalAdminCollections.GRIFFIN);
        }
    }

    private void updateGriffins(@NotNull List<GriffinModel> listToUpdate) throws InvalidParseOperationException, DatabaseException, ReferentialException {
        for (GriffinModel griffinModel : listToUpdate) {
            this.formatDateForMongo(griffinModel);
            ObjectNode griffin = (ObjectNode)JsonHandler.toJsonNode((Object)griffinModel);
            griffin.put(UND_TENANT, VitamThreadUtils.getVitamSession().getTenantId());
            this.mongoDbAccess.replaceDocument((JsonNode)griffin, griffinModel.getIdentifier(), "Identifier", FunctionalAdminCollections.GRIFFIN);
        }
    }

    private void formatDateForMongo(GriffinModel griffinModel) throws ReferentialException {
        try {
            String lastUpdate = LocalDateUtil.nowFormatted();
            griffinModel.setLastUpdate(lastUpdate);
            String creationDate = griffinModel.getCreationDate();
            if (creationDate == null) {
                creationDate = LocalDateUtil.nowFormatted();
            }
            creationDate = LocalDateUtil.getFormattedDateTimeForMongo((String)creationDate);
            griffinModel.setCreationDate(creationDate);
        }
        catch (DateTimeParseException e) {
            throw new ReferentialException(griffinModel.getIdentifier() + " Invalid CreationDate : " + griffinModel.getCreationDate(), (Throwable)e);
        }
    }

    public RequestResponse<GriffinModel> findGriffin(JsonNode queryDsl) throws ReferentialException, InvalidParseOperationException {
        DbRequestResult documents = this.mongoDbAccess.findDocuments(queryDsl, FunctionalAdminCollections.GRIFFIN);
        return documents.getRequestResponseOK(queryDsl, Griffin.class, GriffinModel.class);
    }
}

