/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.format;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Delete;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.server.DbRequestResult;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.DocumentAlreadyExistsException;
import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.SchemaValidationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.VitamAutoCloseable;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.common.FileFormat;
import fr.gouv.vitam.functional.administration.common.ReferentialFile;
import fr.gouv.vitam.functional.administration.common.counter.VitamCounterService;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminImpl;
import fr.gouv.vitam.functional.administration.core.backup.FunctionalBackupService;
import fr.gouv.vitam.functional.administration.core.format.PronomParser;
import fr.gouv.vitam.functional.administration.core.format.model.FileFormatImportEventDetails;
import fr.gouv.vitam.functional.administration.core.format.model.FileFormatModel;
import fr.gouv.vitam.functional.administration.core.format.model.FormatImportReport;
import fr.gouv.vitam.functional.administration.core.format.model.FunctionalOperationModel;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.parameters.Contexts;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.io.FileUtils;

public class ReferentialFormatFileImpl
implements ReferentialFile<FileFormat>,
VitamAutoCloseable {
    public static final String FILE_FORMAT_REPORT = "FILE_FORMAT_REPORT";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ReferentialFormatFileImpl.class);
    private static final String BACKUP_FORMAT_EVENT = "STP_BACKUP_REFERENTIAL_FORMAT";
    private static final String VERSION = " version ";
    private static final String FILE_PRONOM = " du fichier de signature PRONOM (DROID_SignatureFile)";
    private final MongoDbAccessAdminImpl mongoAccess;
    private final FunctionalBackupService backupService;
    private final LogbookOperationsClient logbookOperationsClient;

    public ReferentialFormatFileImpl(MongoDbAccessAdminImpl dbConfiguration, VitamCounterService vitamCounterService) {
        this.mongoAccess = dbConfiguration;
        this.backupService = new FunctionalBackupService(vitamCounterService);
        this.logbookOperationsClient = LogbookOperationsClientFactory.getInstance().getClient();
    }

    @VisibleForTesting
    ReferentialFormatFileImpl(MongoDbAccessAdminImpl dbConfiguration, FunctionalBackupService backupService, LogbookOperationsClient logbookOperationsClient) {
        this.mongoAccess = dbConfiguration;
        this.logbookOperationsClient = logbookOperationsClient;
        this.backupService = backupService;
    }

    public void importFile(InputStream xmlPronom, String filename) throws VitamException {
        ParametersChecker.checkParameter((String)"Pronom file is a mandatory parameter", (Object[])new Object[]{xmlPronom});
        List<FileFormatModel> newFileFormalModels = this.checkFile(xmlPronom);
        GUID eip = this.createLogbook();
        GUID eip1 = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        try {
            ObjectNode selectAll = new Select().getFinalSelect();
            DbRequestResult result = this.mongoAccess.findDocuments((JsonNode)selectAll, FunctionalAdminCollections.FORMATS);
            List documents = result.getDocuments(FileFormat.class);
            List<FileFormatModel> currentFileFormatModels = documents.stream().map(this::toFileFormatModel).collect(Collectors.toList());
            FormatImportReport report = this.generateReport(currentFileFormatModels, newFileFormalModels);
            this.deleteRemovedFormats(report);
            this.insertAddedFormats(report, newFileFormalModels);
            this.updateExistingFormats(report, newFileFormalModels);
            this.backupService.saveCollectionAndSequence(eip, BACKUP_FORMAT_EVENT, FunctionalAdminCollections.FORMATS, eip.toString());
            try (InputStream reportInputStream = JsonHandler.writeToInpustream((Object)report);){
                String fileName = String.valueOf(eip) + ".json";
                this.backupService.saveFile(reportInputStream, eip, FILE_FORMAT_REPORT, DataCategory.REPORT, fileName);
            }
            catch (VitamException | IOException e) {
                throw new StorageException(e.getMessage(), e);
            }
            LogbookOperationParameters logbookParametersEnd = this.createLogbookOperationParametersImport(filename, newFileFormalModels, eip, eip1, report);
            this.updateLogbook(logbookParametersEnd);
        }
        catch (ReferentialException e) {
            LOGGER.error((Throwable)e);
            LogbookOperationParameters logbookParametersEnd = this.createLogbookOperationParametersKo(eip, eip1);
            this.updateLogbook(logbookParametersEnd);
            throw e;
        }
    }

    private void deleteRemovedFormats(FormatImportReport report) throws ReferentialException {
        if (report.getRemovedPuids().isEmpty()) {
            return;
        }
        try {
            Delete delete = new Delete();
            delete.setQuery((Query)QueryHelper.in((String)"PUID", (String[])report.getRemovedPuids().toArray(new String[0])));
            this.mongoAccess.deleteDocument((JsonNode)delete.getFinalDelete(), FunctionalAdminCollections.FORMATS);
        }
        catch (InvalidCreateOperationException | BadRequestException | SchemaValidationException | ReferentialException e) {
            throw new ReferentialException("Could not delete removed formats", e);
        }
    }

    private void insertAddedFormats(FormatImportReport report, List<FileFormatModel> newFileFormatModels) throws ReferentialException {
        if (report.getAddedPuids().isEmpty()) {
            return;
        }
        try {
            List fileFormatsToAdd = newFileFormatModels.stream().filter(fileFormatModel -> report.getAddedPuids().contains(fileFormatModel.getPuid())).collect(Collectors.toList());
            this.mongoAccess.insertDocuments((ArrayNode)JsonHandler.toJsonNode(fileFormatsToAdd), FunctionalAdminCollections.FORMATS).close();
        }
        catch (DocumentAlreadyExistsException | InvalidParseOperationException | SchemaValidationException | ReferentialException e) {
            throw new ReferentialException("Could not insert added formats", e);
        }
    }

    private void updateExistingFormats(FormatImportReport report, List<FileFormatModel> newFileFormatModels) throws ReferentialException {
        List<FileFormatModel> existingFormatsToUpdate = newFileFormatModels.stream().filter(fileFormatModel -> !report.getAddedPuids().contains(fileFormatModel.getPuid())).filter(fileFormatModel -> !report.getRemovedPuids().contains(fileFormatModel.getPuid())).collect(Collectors.toList());
        this.updateExistingFormats(existingFormatsToUpdate);
    }

    private void updateExistingFormats(List<FileFormatModel> fileFormatModels) throws ReferentialException {
        Map<String, JsonNode> fileFormatModelMap = fileFormatModels.stream().collect(Collectors.toMap(FileFormatModel::getPuid, fileFormatModel -> {
            try {
                return JsonHandler.toJsonNode((Object)fileFormatModel);
            }
            catch (InvalidParseOperationException e) {
                throw new VitamRuntimeException("Could not update format document with puid " + fileFormatModel.getPuid(), (Throwable)e);
            }
        }));
        try {
            this.mongoAccess.replaceDocuments(fileFormatModelMap, "PUID", FunctionalAdminCollections.FORMATS);
        }
        catch (DatabaseException e) {
            throw new ReferentialException("Could not update format documents with PUIDs " + String.valueOf(fileFormatModelMap.keySet()), (Throwable)e);
        }
    }

    private FormatImportReport generateReport(List<FileFormatModel> currentFileFormatModels, List<FileFormatModel> newFileFormatModels) {
        FormatImportReport report = new FormatImportReport();
        FunctionalOperationModel operationModel = this.retrieveOperationModel();
        report.setOperation(operationModel);
        if (!currentFileFormatModels.isEmpty()) {
            report.setPreviousPronomVersion(currentFileFormatModels.get(0).getVersionPronom());
            report.setPreviousPronomCreationDate(currentFileFormatModels.get(0).getCreatedDate());
        }
        if (!newFileFormatModels.isEmpty()) {
            report.setNewPronomVersion(newFileFormatModels.get(0).getVersionPronom());
            report.setNewPronomCreationDate(newFileFormatModels.get(0).getCreatedDate());
        }
        Map<String, FileFormatModel> currentFileFormatModelsByPuid = this.mapByPuid(currentFileFormatModels);
        Map<String, FileFormatModel> newFileFormatModelsByPuid = this.mapByPuid(newFileFormatModels);
        SetUtils.SetView removedPuids = SetUtils.difference(currentFileFormatModelsByPuid.keySet(), newFileFormatModelsByPuid.keySet());
        for (Object removedPuid : removedPuids) {
            LOGGER.warn("Removed puid: " + (String)removedPuid);
            report.addRemovedPuids((String)removedPuid);
        }
        SetUtils.SetView addedPuids = SetUtils.difference(newFileFormatModelsByPuid.keySet(), currentFileFormatModelsByPuid.keySet());
        for (Object addedPuid : addedPuids) {
            LOGGER.debug("Added puid: " + (String)addedPuid);
            report.addAddedPuid((String)addedPuid);
        }
        SetUtils.SetView commonPuids = SetUtils.intersection(newFileFormatModelsByPuid.keySet(), currentFileFormatModelsByPuid.keySet());
        for (String commonPuid : commonPuids) {
            FileFormatModel newFileFormatModel;
            FileFormatModel currentFileFormatModel = currentFileFormatModelsByPuid.get(commonPuid);
            List<String> diff = this.diff(currentFileFormatModel, newFileFormatModel = newFileFormatModelsByPuid.get(commonPuid));
            if (diff.isEmpty()) {
                LOGGER.debug("Unchanged puid: " + commonPuid);
                continue;
            }
            LOGGER.debug("Updated puid: " + commonPuid);
            report.addUpdatedPuids(commonPuid, diff);
        }
        if (report.getPreviousPronomVersion() != null && report.getNewPronomVersion() != null) {
            int newVersion;
            int previousVersion = Integer.parseInt(report.getPreviousPronomVersion());
            if (previousVersion == (newVersion = Integer.parseInt(report.getNewPronomVersion()))) {
                report.addWarning("Same referential version: " + newVersion);
            } else if (previousVersion > newVersion) {
                report.addWarning("New imported referential version " + newVersion + " is older than previous referential version " + previousVersion);
            }
        }
        if (report.getPreviousPronomCreationDate() != null && report.getNewPronomCreationDate() != null) {
            String newDate;
            String previousDate = LocalDateUtil.getFormattedDateTimeForMongo((String)report.getPreviousPronomCreationDate());
            if (previousDate.equals(newDate = LocalDateUtil.getFormattedDateTimeForMongo((String)report.getNewPronomCreationDate()))) {
                report.addWarning("Same referential date: " + report.getNewPronomCreationDate());
            } else if (previousDate.compareTo(newDate) > 0) {
                report.addWarning("New imported referential date " + report.getNewPronomCreationDate() + " is older than previous report date " + report.getPreviousPronomCreationDate());
            }
        }
        if (!removedPuids.isEmpty()) {
            report.addWarning(removedPuids.size() + " puids removed.");
        }
        if (report.getWarnings().isEmpty()) {
            report.setStatusCode(StatusCode.OK);
        } else {
            report.setStatusCode(StatusCode.WARNING);
        }
        return report;
    }

    private FunctionalOperationModel retrieveOperationModel() {
        try {
            JsonNode result = this.logbookOperationsClient.selectOperationById(VitamThreadUtils.getVitamSession().getRequestId());
            return (FunctionalOperationModel)JsonHandler.getFromJsonNode((JsonNode)result.get("$results").get(0), FunctionalOperationModel.class);
        }
        catch (InvalidParseOperationException | LogbookClientException e) {
            throw new VitamRuntimeException("Could not load operation data", e);
        }
    }

    private Map<String, FileFormatModel> mapByPuid(List<FileFormatModel> fileFormatModels) {
        return fileFormatModels.stream().collect(Collectors.toMap(FileFormatModel::getPuid, fileFormatModel -> fileFormatModel));
    }

    private List<String> diff(FileFormatModel currentFileFormatModel, FileFormatModel newFileFormatModel) {
        String before = this.toComparableString(currentFileFormatModel);
        String after = this.toComparableString(newFileFormatModel);
        List unifiedDiff = VitamDocument.getUnifiedDiff((String)before, (String)after);
        List concernedDiffLines = VitamDocument.getConcernedDiffLines((List)unifiedDiff);
        concernedDiffLines.sort(Comparator.naturalOrder());
        return concernedDiffLines;
    }

    private String toComparableString(FileFormatModel currentFileFormatModel) {
        try {
            ObjectNode currentJsonNode = (ObjectNode)JsonHandler.toJsonNode((Object)currentFileFormatModel);
            currentJsonNode.remove("VersionPronom");
            currentJsonNode.remove("CreatedDate");
            currentJsonNode.remove("UpdateDate");
            return JsonHandler.prettyPrint((Object)currentJsonNode);
        }
        catch (InvalidParseOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private FileFormatModel toFileFormatModel(FileFormat fileFormat) {
        try {
            return (FileFormatModel)JsonHandler.getFromJsonNode((JsonNode)JsonHandler.toJsonNode((Object)fileFormat), FileFormatModel.class);
        }
        catch (InvalidParseOperationException e) {
            throw new RuntimeException("Could parse current file formats", e);
        }
    }

    private LogbookOperationParameters createLogbookOperationParametersKo(GUID eip, GUID eip1) {
        return LogbookParameterHelper.newLogbookOperationParameters((GUID)eip1, (String)Contexts.REFERENTIAL_FORMAT_IMPORT.getEventType(), (GUID)eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.KO, (String)VitamLogbookMessages.getCodeOp((String)Contexts.REFERENTIAL_FORMAT_IMPORT.getEventType(), (StatusCode)StatusCode.KO), (GUID)eip);
    }

    private void updateLogbook(LogbookOperationParameters logbookParametersEnd) throws ReferentialException {
        try {
            this.logbookOperationsClient.update(new LogbookOperationParameters[]{logbookParametersEnd});
        }
        catch (LogbookClientBadRequestException | LogbookClientNotFoundException | LogbookClientServerException e) {
            LOGGER.error(e);
            throw new ReferentialException(e);
        }
    }

    private LogbookOperationParameters createLogbookOperationParametersImport(String filename, List<FileFormatModel> pronomList, GUID eip, GUID eip1, FormatImportReport report) throws InvalidParseOperationException {
        LogbookOperationParameters logbookParametersEnd = LogbookParameterHelper.newLogbookOperationParameters((GUID)eip1, (String)Contexts.REFERENTIAL_FORMAT_IMPORT.getEventType(), (GUID)eip, (LogbookTypeProcess)Contexts.REFERENTIAL_FORMAT_IMPORT.getLogbookTypeProcess(), (StatusCode)report.getStatusCode(), (String)(VitamLogbookMessages.getCodeOp((String)Contexts.REFERENTIAL_FORMAT_IMPORT.getEventType(), (StatusCode)report.getStatusCode()) + VERSION + pronomList.get(0).getVersionPronom() + FILE_PRONOM), (GUID)eip);
        FileFormatImportEventDetails eventDetails = new FileFormatImportEventDetails().setFilename(filename);
        if (!report.getWarnings().isEmpty()) {
            eventDetails.setWarnings(report.getWarnings());
        }
        ObjectNode evDetData = (ObjectNode)JsonHandler.toJsonNode((Object)eventDetails);
        logbookParametersEnd.putParameterValue(LogbookParameterName.eventDetailData, JsonHandler.unprettyPrint((Object)evDetData));
        return logbookParametersEnd;
    }

    private GUID createLogbook() throws ReferentialException {
        GUID eip;
        String operationId = VitamThreadUtils.getVitamSession().getRequestId();
        try {
            eip = GUIDReader.getGUID((String)operationId);
            LogbookOperationParameters logbookParametersStart = LogbookParameterHelper.newLogbookOperationParameters((GUID)eip, (String)Contexts.REFERENTIAL_FORMAT_IMPORT.getEventType(), (GUID)eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)Contexts.REFERENTIAL_FORMAT_IMPORT.getEventType(), (StatusCode)StatusCode.STARTED), (GUID)eip);
            this.logbookOperationsClient.create(new LogbookOperationParameters[]{logbookParametersStart});
        }
        catch (InvalidGuidOperationException | LogbookClientAlreadyExistsException | LogbookClientBadRequestException | LogbookClientServerException e) {
            LOGGER.error(e);
            throw new ReferentialException(e);
        }
        return eip;
    }

    public List<FileFormatModel> checkFile(InputStream xmlPronom) throws ReferentialException {
        ParametersChecker.checkParameter((String)"Pronom file is a mandatory parameter", (Object[])new Object[]{xmlPronom});
        File xmlPronomFile = null;
        try {
            xmlPronomFile = PropertiesUtils.fileFromTmpFolder((String)(VitamThreadUtils.getVitamSession().getRequestId() + ".xml"));
            FileUtils.copyInputStreamToFile((InputStream)xmlPronom, (File)xmlPronomFile);
            List<FileFormatModel> list = PronomParser.getPronom(xmlPronomFile);
            return list;
        }
        catch (IOException e) {
            throw new ReferentialException((Throwable)e);
        }
        finally {
            StreamUtils.closeSilently((InputStream)xmlPronom);
            FileUtils.deleteQuietly((File)xmlPronomFile);
        }
    }

    public FileFormat findDocumentById(String id) {
        return (FileFormat)this.mongoAccess.getDocumentByUniqueId(id, FunctionalAdminCollections.FORMATS, "PUID");
    }

    public RequestResponseOK<FileFormat> findDocuments(JsonNode select) throws ReferentialException {
        try (DbRequestResult result = this.mongoAccess.findDocuments(select, FunctionalAdminCollections.FORMATS);){
            RequestResponseOK requestResponseOK = result.getRequestResponseOK(select, FileFormat.class);
            return requestResponseOK;
        }
    }

    public void close() {
        this.logbookOperationsClient.close();
    }
}

