/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.contract;

import fr.gouv.vitam.common.model.administration.AbstractContractModel;
import java.util.Optional;

public interface GenericContractValidator<T extends AbstractContractModel> {
    public Optional<GenericRejectionCause> validate(T var1, String var2);

    public static class GenericRejectionCause {
        private static final String ERR_ID_NOT_ALLOWED_IN_CREATE = "Id must be null when creating contracts (%s)";
        private static final String ERR_DUPLICATE_CONTRACT = "The contract %s already exists in database";
        private static final String ERR_ARCHIVEPROFILE_NOT_FOUND_CONTRACT = "One or multiple archive profiles or the contract %s not found in db";
        private static final String ERR_CONTRACT_EXCEPTION_OCCURRED = "Exception while validating contract (%s), %s : %s";
        private static final String ERR_CONTRACT_ROOT_UNITS_NOT_FOUND = "Error while validating contract (%s), RootUnits (%s) not found in database";
        private static final String ERR_CONTRACT_EXCLUDED_ROOT_UNITS_NOT_FOUND = "Error while validating contract (%s), ExcludedRootUnits (%s) not found in database";
        private static final String ERR_CONTRACT_EXCLUDED_AND_ROOT_UNITS_NOT_FOUND = "Error while validating contract (%s), ExcludedRootUnits and RootUnits (%s) not found in database";
        private static final String ERR_MANDATORY_FIELD = "The field %s is mandatory";
        private static final String ERR_IDS_NOT_FOUND = "At least one AU id %s not found";
        private static final String ERR_MC_IDS_NOT_FOUND = "At least one Management Contract with Id %s not found";
        private static final String ERR_FORMATFILETYPE_NOT_FOUND_CONTRACT = "One or multiple file format %s not found in db";
        private static final String ERR_INCONSISTENT_CONTRACT_DEFINITION = "Error while validating contract (%s) : %s";
        private static final String ERR_STORAGE_STRATEGY_NOT_FOUND = "Storage Strategy (%s) not found for the field %s";
        private static final String ERR_STORAGE_STRATEGY_DOES_NOT_CONTAINS_ONE_REFERENT_OFFER = "Storage Strategy (%s) does not contains one and only one 'referent' offer for the field %s";
        private static final String ERR_VERSION_RETENTION_POLICY_INVALID = "The version retention policy's %s parameter in %s usage is invalid in the contract %s.";
        private static final String ERR_VERSION_RETENTION_POLICY_INVALID_USAGE = "The usage type %s is invalid in the contract %s.";
        private static final String ERR_PERSISTENCE_IDENTIFIER_RETENTION_POLICY_DUPLICATE_USAGE = "Duplicate usage type %s found in the contract %s.";
        private String reason;

        public GenericRejectionCause(String error) {
            this.setReason(error);
        }

        public static GenericRejectionCause rejectIdNotAllowedInCreate(String contractName) {
            return new GenericRejectionCause(String.format(ERR_ID_NOT_ALLOWED_IN_CREATE, contractName));
        }

        public static GenericRejectionCause rejectAuNotFoundInDatabase(String linkParentId) {
            return new GenericRejectionCause(String.format(ERR_IDS_NOT_FOUND, linkParentId));
        }

        public static GenericRejectionCause rejectMCNotFoundInDatabase(String managementContractID) {
            return new GenericRejectionCause(String.format(ERR_MC_IDS_NOT_FOUND, managementContractID));
        }

        public static GenericRejectionCause rejectDuplicatedInDatabase(String contractName) {
            return new GenericRejectionCause(String.format(ERR_DUPLICATE_CONTRACT, contractName));
        }

        public static GenericRejectionCause rejectArchiveProfileNotFoundInDatabase(String contractName) {
            return new GenericRejectionCause(String.format(ERR_ARCHIVEPROFILE_NOT_FOUND_CONTRACT, contractName));
        }

        public static GenericRejectionCause rejectExceptionOccurred(String contractName, String msg, Throwable e) {
            return new GenericRejectionCause(String.format(ERR_CONTRACT_EXCEPTION_OCCURRED, contractName, msg, e.getMessage()));
        }

        public static GenericRejectionCause rejectRootUnitsNotFound(String contractName, String guidArrayAsString) {
            return new GenericRejectionCause(String.format(ERR_CONTRACT_ROOT_UNITS_NOT_FOUND, contractName, guidArrayAsString));
        }

        public static GenericRejectionCause rejectExcludedRootUnitsNotFound(String contractName, String guidArrayAsString) {
            return new GenericRejectionCause(String.format(ERR_CONTRACT_EXCLUDED_ROOT_UNITS_NOT_FOUND, contractName, guidArrayAsString));
        }

        public static GenericRejectionCause rejectExcludedAndRootUnitsNotFound(String contractName, String guidArrayAsString) {
            return new GenericRejectionCause(String.format(ERR_CONTRACT_EXCLUDED_AND_ROOT_UNITS_NOT_FOUND, contractName, guidArrayAsString));
        }

        public static GenericRejectionCause rejectMandatoryMissing(String fieldName) {
            return new GenericRejectionCause(String.format(ERR_MANDATORY_FIELD, fieldName));
        }

        public static GenericRejectionCause rejectFormatFileTypeNotFoundInDatabase(String contractName) {
            return new GenericRejectionCause(String.format(ERR_FORMATFILETYPE_NOT_FOUND_CONTRACT, contractName));
        }

        public static GenericRejectionCause rejectInconsistentContract(String contractName, String reason) {
            return new GenericRejectionCause(String.format(ERR_INCONSISTENT_CONTRACT_DEFINITION, contractName, reason));
        }

        public static GenericRejectionCause rejectStorageStrategyMissing(String storageStrategy, String fieldName) {
            return new GenericRejectionCause(String.format(ERR_STORAGE_STRATEGY_NOT_FOUND, storageStrategy, fieldName));
        }

        public static GenericRejectionCause rejectStorageStrategyDoesNotContainsOneReferent(String storageStrategy, String fieldName) {
            return new GenericRejectionCause(String.format(ERR_STORAGE_STRATEGY_DOES_NOT_CONTAINS_ONE_REFERENT_OFFER, storageStrategy, fieldName));
        }

        public static GenericRejectionCause rejectInvalidVersionRetentionPolicyParamOfUsage(String fieldName, String UsageName, String contractName) {
            return new GenericRejectionCause(String.format(ERR_VERSION_RETENTION_POLICY_INVALID, fieldName, UsageName, contractName));
        }

        public static GenericRejectionCause rejectInvalidVersionRetentionPolicyUsage(String fieldName, String contractName) {
            return new GenericRejectionCause(String.format(ERR_VERSION_RETENTION_POLICY_INVALID_USAGE, fieldName, contractName));
        }

        public static GenericRejectionCause rejectDuplicateVersionRetentionPolicyUsage(String fieldName, String contractName) {
            return new GenericRejectionCause(String.format(ERR_PERSISTENCE_IDENTIFIER_RETENTION_POLICY_DUPLICATE_USAGE, fieldName, contractName));
        }

        public String getReason() {
            return this.reason;
        }

        private void setReason(String reason) {
            this.reason = reason;
        }
    }
}

