/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.agencies;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.FileUtil;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.SetAction;
import fr.gouv.vitam.common.database.builder.query.action.UnsetAction;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Delete;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.builder.request.single.Update;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.single.UpdateParserSingle;
import fr.gouv.vitam.common.database.server.DbRequestResult;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.DocumentAlreadyExistsException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.SchemaValidationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.i18n.VitamErrorMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.model.administration.AgenciesModel;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.security.IllegalPathException;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.common.AccessionRegisterDetail;
import fr.gouv.vitam.functional.administration.common.Agencies;
import fr.gouv.vitam.functional.administration.common.ErrorReportAgencies;
import fr.gouv.vitam.functional.administration.common.FileAgenciesErrorCode;
import fr.gouv.vitam.functional.administration.common.counter.SequenceType;
import fr.gouv.vitam.functional.administration.common.counter.VitamCounterService;
import fr.gouv.vitam.functional.administration.common.exception.AgencyImportDeletionException;
import fr.gouv.vitam.functional.administration.common.exception.InvalidFileException;
import fr.gouv.vitam.functional.administration.common.exception.InvalidFileFormatParseException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialImportInProgressException;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminImpl;
import fr.gouv.vitam.functional.administration.core.agencies.AgenciesImportResult;
import fr.gouv.vitam.functional.administration.core.agencies.AgenciesReport;
import fr.gouv.vitam.functional.administration.core.agencies.LogbookAgenciesImportManager;
import fr.gouv.vitam.functional.administration.core.backup.FunctionalBackupService;
import fr.gouv.vitam.functional.administration.core.contract.AccessContractImpl;
import fr.gouv.vitam.functional.administration.core.contract.ContractService;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.StringUtils;

public class AgenciesService {
    static final String AGENCIES_IMPORT_EVENT = "IMPORT_AGENCIES";
    private static final String AGENCIES_REPORT_EVENT = "AGENCIES_REPORT";
    private static final String AGENCIES_BACKUP_EVENT = "BACKUP_AGENCIES";
    private static final String IMPORT_AGENCIES_BACKUP_CSV = "IMPORT_AGENCIES_BACKUP_CSV";
    public static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AgenciesService.class);
    private static final String AGENCIES_IMPORT_ANOTHER_IMPORT_IN_PROGRESS = "IMPORT_AGENCIES.CHECK_CONCURRENT_AGENCIES_IMPORT";
    private static final String AGENCIES_IMPORT_AU_USAGE = "IMPORT_AGENCIES.USED_AU";
    private static final String AGENCIES_IMPORT_CONTRACT_USAGE = "IMPORT_AGENCIES.USED_CONTRACT";
    private static final String AGENCIES_IMPORT_DELETION_ERROR = "DELETION";
    private static final String AGENCIES_IMPORT_CONCURRENCE_ERROR = "CONCURRENCE";
    private static final String CSV = ".csv";
    private static final String INVALID_CSV_FILE = "Invalid CSV File";
    private static final String USED_AGENCIES_IN_METADATA_TO_BE_DELETED_ERROR = "Error deleting used agencies in metadata";
    private static final String USED_AGENCIES_IN_ACCESS_CONTRACT_TO_BE_DELETED_ERROR = "Error deleting used agencies in access contract";
    private static final String MESSAGE_ERROR = "Import agency error > ";
    private static final String UND_ID = "_id";
    private static final String UND_TENANT = "_tenant";
    private static final String AGENCIES_PROCESS_IMPORT_ALREADY_EXIST = "There is already another agencies import in progress";
    public static final String CSV_MULTIPLE_STRINGS_SEPARATOR = "\\|";
    private final MongoDbAccessAdminImpl mongoAccess;
    private final FunctionalBackupService backupService;
    private final LogbookAgenciesImportManager manager;
    private final ContractService<AccessContractModel> accessContractService;
    private final VitamCounterService vitamCounterService;

    public AgenciesService(MongoDbAccessAdminImpl mongoAccess, VitamCounterService vitamCounterService, FunctionalBackupService backupService) {
        this(mongoAccess, vitamCounterService, backupService, new LogbookAgenciesImportManager(LogbookOperationsClientFactory.getInstance()), new AccessContractImpl(mongoAccess, vitamCounterService));
    }

    @VisibleForTesting
    public AgenciesService(MongoDbAccessAdminImpl mongoAccess, VitamCounterService vitamCounterService, FunctionalBackupService backupService, LogbookAgenciesImportManager manager, ContractService<AccessContractModel> accessContractService) {
        this.mongoAccess = mongoAccess;
        this.backupService = backupService;
        this.manager = manager;
        this.vitamCounterService = vitamCounterService;
        this.accessContractService = accessContractService;
    }

    private Set<AgenciesModel> findAgenciesUsedByAccessContracts(Set<AgenciesModel> agenciesToCheck) throws InvalidCreateOperationException, VitamException {
        HashSet<AgenciesModel> usedAgenciesByContracts = new HashSet<AgenciesModel>();
        for (AgenciesModel agency : agenciesToCheck) {
            if (!this.isUsedByAccessContract(agency)) continue;
            usedAgenciesByContracts.add(agency);
        }
        return usedAgenciesByContracts;
    }

    private Set<AgenciesModel> findAgenciesUsedInMetadata(Set<AgenciesModel> agenciesToCheck) throws InvalidCreateOperationException, VitamException {
        HashSet<AgenciesModel> usedAgenciesByContracts = new HashSet<AgenciesModel>();
        for (AgenciesModel agency : agenciesToCheck) {
            if (!this.isUsedInMetadata(agency)) continue;
            usedAgenciesByContracts.add(agency);
        }
        return usedAgenciesByContracts;
    }

    public AgenciesImportResult parseFile(File csvFile) throws IOException, ReferentialException {
        int tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        HashMap<Integer, List<ErrorReportAgencies>> errorsMap = new HashMap<Integer, List<ErrorReportAgencies>>();
        int lineNumber = 1;
        HashMap<String, AgenciesModel> agenciesModelMap = new HashMap<String, AgenciesModel>();
        try (InputStreamReader reader = new InputStreamReader((InputStream)((BOMInputStream.Builder)BOMInputStream.builder().setFile(csvFile)).get(), StandardCharsets.UTF_8);){
            try {
                CSVParser parser = new CSVParser((Reader)reader, CSVFormat.DEFAULT.withHeader(new String[0]).withTrim().withIgnoreEmptyLines(false));
                List headerNames = parser.getHeaderNames();
                Set duplicatedFields = headerNames.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
                if (CollectionUtils.isNotEmpty(duplicatedFields)) {
                    throw new InvalidFileException("Duplicate fields found in the CSV : " + String.join((CharSequence)",", duplicatedFields));
                }
                List<String> unknownFields = headerNames.stream().filter(element -> !AgenciesModel.getAllFieldNames().contains(element)).toList();
                if (CollectionUtils.isNotEmpty(unknownFields)) {
                    throw new InvalidFileException("Unknown fields found: " + String.join((CharSequence)",", unknownFields));
                }
                for (CSVRecord record : parser) {
                    ArrayList<ErrorReportAgencies> errors = new ArrayList<ErrorReportAgencies>();
                    ++lineNumber;
                    if (!this.checkRecords(record)) continue;
                    String identifier = record.get("Identifier");
                    String name = record.get("Name");
                    String description = record.get("Description");
                    AgenciesModel agenciesModel = new AgenciesModel(identifier, name, description, tenantId);
                    this.checkParametersNotEmpty(identifier, name, errors, lineNumber);
                    this.extractOptionalStringField(record, "EntityType").ifPresent(arg_0 -> ((AgenciesModel)agenciesModel).setEntityType(arg_0));
                    this.extractOptionalStringArrayField(record, "AlternativeForm").ifPresent(arg_0 -> ((AgenciesModel)agenciesModel).setAlternativeForm(arg_0));
                    this.extractOptionalStringArrayField(record, "AuthorizedForm").ifPresent(arg_0 -> ((AgenciesModel)agenciesModel).setAuthorizedForm(arg_0));
                    this.extractOptionalStringField(record, "BiogHist").ifPresent(arg_0 -> ((AgenciesModel)agenciesModel).setBiogHist(arg_0));
                    this.extractOptionalStringField(record, "GeneralContext").ifPresent(arg_0 -> ((AgenciesModel)agenciesModel).setGeneralContext(arg_0));
                    Optional<String> fromDateValue = this.extractOptionalDateField(record, "FromDate");
                    fromDateValue.ifPresent(arg_0 -> ((AgenciesModel)agenciesModel).setFromDate(arg_0));
                    Optional<String> toDateValue = this.extractOptionalDateField(record, "ToDate");
                    toDateValue.ifPresent(arg_0 -> ((AgenciesModel)agenciesModel).setToDate(arg_0));
                    this.extractOptionalStringField(record, "EventDescription").ifPresent(arg_0 -> ((AgenciesModel)agenciesModel).setEventDescription(arg_0));
                    this.extractOptionalStringField(record, "EntityId").ifPresent(arg_0 -> ((AgenciesModel)agenciesModel).setEntityId(arg_0));
                    this.extractOptionalStringArrayField(record, "NameEntryParallel").ifPresent(arg_0 -> ((AgenciesModel)agenciesModel).setNameEntryParallel(arg_0));
                    this.extractOptionalStringArrayField(record, "Functions").ifPresent(arg_0 -> ((AgenciesModel)agenciesModel).setFunctions(arg_0));
                    this.extractOptionalStringField(record, "StructureOrGenealogy").ifPresent(arg_0 -> ((AgenciesModel)agenciesModel).setStructureOrGenealogy(arg_0));
                    this.extractOptionalStringArrayField(record, "LegalStatuses").ifPresent(arg_0 -> ((AgenciesModel)agenciesModel).setLegalStatuses(arg_0));
                    this.extractOptionalStringArrayField(record, "Sources").ifPresent(arg_0 -> ((AgenciesModel)agenciesModel).setSources(arg_0));
                    this.extractOptionalStringField(record, "LocalStatus").ifPresent(arg_0 -> ((AgenciesModel)agenciesModel).setLocalStatus(arg_0));
                    this.extractOptionalStringArrayField(record, "Mandates").ifPresent(arg_0 -> ((AgenciesModel)agenciesModel).setMandates(arg_0));
                    this.extractOptionalStringField(record, "MaintenanceStatus").ifPresent(arg_0 -> ((AgenciesModel)agenciesModel).setMaintenanceStatus(arg_0));
                    this.extractOptionalStringArrayField(record, "Places").ifPresent(arg_0 -> ((AgenciesModel)agenciesModel).setPlaces(arg_0));
                    if (agenciesModelMap.containsKey(identifier)) {
                        errors.add(new ErrorReportAgencies(FileAgenciesErrorCode.STP_IMPORT_AGENCIES_ID_DUPLICATION, lineNumber, agenciesModel));
                    }
                    agenciesModelMap.put(identifier, agenciesModel);
                    if (errors.isEmpty()) continue;
                    errorsMap.put(lineNumber, errors);
                }
            }
            catch (IllegalArgumentException e) {
                String message = e.getMessage();
                if (message.contains("Name not found")) {
                    message = "File invalid -- lack of column Name";
                }
                if (message.contains("Identifier not found")) {
                    message = "File invalid -- lack of column Identifier";
                }
                if (message.contains("Description not found")) {
                    message = "File invalid -- lack of column Description";
                }
                throw new InvalidFileException(message);
            }
            AgenciesImportResult agenciesImportResult = new AgenciesImportResult(new HashSet<AgenciesModel>(agenciesModelMap.values()), errorsMap);
            return agenciesImportResult;
        }
    }

    private Optional<String> extractOptionalStringField(CSVRecord record, String fieldName) {
        return Optional.ofNullable(record.isSet(fieldName) ? record.get(fieldName) : null).filter(StringUtils::isNotEmpty);
    }

    private Optional<String> extractOptionalDateField(CSVRecord record, String fieldName) throws InvalidFileFormatParseException {
        try {
            if (!record.isSet(fieldName)) {
                return Optional.empty();
            }
            if (StringUtils.isEmpty((CharSequence)record.get(fieldName))) {
                return Optional.empty();
            }
            return Optional.of(LocalDateUtil.getFormattedDateOnlyForMongo((String)record.get(fieldName)));
        }
        catch (DateTimeParseException e) {
            throw new InvalidFileFormatParseException("The field " + fieldName + " contains bad date format value", (Throwable)e);
        }
    }

    private Optional<List<String>> extractOptionalStringArrayField(CSVRecord record, String fieldName) throws InvalidFileFormatParseException {
        String fieldValue;
        if (record.isSet(fieldName) && StringUtils.isNotEmpty((CharSequence)(fieldValue = record.get(fieldName)))) {
            List<String> fieldValueTokens = Arrays.asList(fieldValue.split(CSV_MULTIPLE_STRINGS_SEPARATOR));
            List<String> fieldValueTokensCleaned = fieldValueTokens.stream().filter(StringUtils::isNotBlank).toList();
            if (fieldValueTokensCleaned.size() < fieldValueTokens.size()) {
                throw new InvalidFileFormatParseException("The field " + fieldName + " contains bad formatted values");
            }
            return Optional.of(fieldValueTokensCleaned);
        }
        return Optional.empty();
    }

    public Set<AgenciesModel> retrieveAgenciesInDb() throws ReferentialException {
        Select select = new Select();
        RequestResponseOK response = this.findAgencies((JsonNode)select.getFinalSelect()).getRequestResponseOK((JsonNode)select.getFinalSelect(), Agencies.class);
        return response.getResults().stream().map(Agencies::wrap).collect(Collectors.toSet());
    }

    private void checkParametersNotEmpty(String identifier, String name, List<ErrorReportAgencies> errors, int line) {
        ArrayList<String> missingParam = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)identifier)) {
            missingParam.add("Identifier");
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            missingParam.add("Name");
        }
        if (!missingParam.isEmpty()) {
            errors.add(new ErrorReportAgencies(FileAgenciesErrorCode.STP_IMPORT_AGENCIES_MISSING_INFORMATIONS, line, String.join((CharSequence)"", missingParam)));
        }
    }

    private boolean checkRecords(CSVRecord record) {
        return record.get("Identifier") != null && record.get("Name") != null && record.get("Description") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse<AgenciesModel> importAgencies(InputStream stream, String filename) throws VitamException {
        GUID eip = GUIDReader.getGUID((String)VitamThreadUtils.getVitamSession().getRequestId());
        this.manager.logStarted(eip, AGENCIES_IMPORT_EVENT);
        File file = null;
        try {
            this.checkConcurrentImportOperation(eip);
            file = FileUtil.convertInputStreamToFile((InputStream)stream, (String)GUIDFactory.newGUID().getId(), (String)CSV);
            AgenciesImportResult agenciesImportResult = this.parseFile(file);
            if (agenciesImportResult.getErrorsMap().size() > 0) {
                throw new InvalidFileException(INVALID_CSV_FILE);
            }
            Set<AgenciesModel> agenciesToImport = agenciesImportResult.getAgenciesToImport();
            Set<AgenciesModel> agenciesInDb = this.retrieveAgenciesInDb();
            HashSet<AgenciesModel> agenciesToUpdate = new HashSet<AgenciesModel>(agenciesToImport);
            agenciesToUpdate.removeAll(agenciesInDb);
            Set<AgenciesModel> agenciesToInsert = agenciesToUpdate.stream().filter(e -> agenciesInDb.stream().map(AgenciesModel::getIdentifier).noneMatch(t -> t.equals(e.getIdentifier()))).collect(Collectors.toSet());
            agenciesImportResult.setInsertedAgencies(agenciesToInsert);
            agenciesToUpdate.removeAll(agenciesToInsert);
            agenciesImportResult.setUpdatedAgencies(agenciesToUpdate);
            agenciesToUpdate.forEach(agencyModel -> agencyModel.setUpdateDate(LocalDateUtil.nowFormatted()));
            Set<AgenciesModel> agenciesToDelete = agenciesInDb.stream().filter(e -> agenciesToImport.stream().map(AgenciesModel::getIdentifier).noneMatch(t -> t.equals(e.getIdentifier()))).collect(Collectors.toSet());
            agenciesImportResult.setDeletedAgencies(agenciesToDelete);
            try {
                Set<AgenciesModel> usedAgenciesInAccessContracts = this.findAgenciesUsedByAccessContracts(agenciesToDelete);
                if (!usedAgenciesInAccessContracts.isEmpty()) {
                    String errorMessage = this.buildErrorMessageWithAgenciesList(USED_AGENCIES_IN_ACCESS_CONTRACT_TO_BE_DELETED_ERROR, usedAgenciesInAccessContracts);
                    throw new AgencyImportDeletionException(errorMessage);
                }
                this.manager.logEventSuccess(eip, AGENCIES_IMPORT_CONTRACT_USAGE);
                Set<AgenciesModel> usedAgenciesInMetaData = this.findAgenciesUsedInMetadata(agenciesToDelete);
                if (!usedAgenciesInMetaData.isEmpty()) {
                    String errorMessage = this.buildErrorMessageWithAgenciesList(USED_AGENCIES_IN_METADATA_TO_BE_DELETED_ERROR, usedAgenciesInMetaData);
                    throw new AgencyImportDeletionException(errorMessage);
                }
                this.manager.logEventSuccess(eip, AGENCIES_IMPORT_AU_USAGE);
                Set<AgenciesModel> usedAgenciesByContractsToUpdate = this.findAgenciesUsedByAccessContracts(agenciesToUpdate);
                if (usedAgenciesByContractsToUpdate.isEmpty()) {
                    this.manager.logEventSuccess(eip, AGENCIES_IMPORT_CONTRACT_USAGE);
                } else {
                    ArrayNode usedAgenciesContractNode = JsonHandler.createArrayNode();
                    usedAgenciesByContractsToUpdate.forEach(agency -> usedAgenciesContractNode.add(agency.getIdentifier()));
                    ObjectNode data = JsonHandler.createObjectNode();
                    data.set("Information additionnelle", (JsonNode)usedAgenciesContractNode);
                    this.manager.setEvDetData(data);
                    this.manager.logEventWarning(eip, AGENCIES_IMPORT_CONTRACT_USAGE);
                }
                agenciesImportResult.setUsedAgenciesContract(usedAgenciesByContractsToUpdate);
                Set<AgenciesModel> usedAgenciesInMetadataToUpdate = this.findAgenciesUsedInMetadata(agenciesToUpdate);
                if (usedAgenciesByContractsToUpdate.isEmpty()) {
                    this.manager.logEventSuccess(eip, AGENCIES_IMPORT_AU_USAGE);
                } else {
                    ArrayNode usedAgenciesContractNode = JsonHandler.createArrayNode();
                    usedAgenciesByContractsToUpdate.forEach(agency -> usedAgenciesContractNode.add(agency.getIdentifier()));
                    ObjectNode data = JsonHandler.createObjectNode();
                    data.set("Information additionnelle", (JsonNode)usedAgenciesContractNode);
                    this.manager.setEvDetData(data);
                    this.manager.logEventWarning(eip, AGENCIES_IMPORT_AU_USAGE);
                }
                agenciesImportResult.setUsedAgenciesAU(usedAgenciesInMetadataToUpdate);
                this.commitAgencies(agenciesToInsert, agenciesToUpdate, agenciesToDelete);
                try (FileInputStream csvFileInputStream = new FileInputStream(file);){
                    this.backupService.saveFile(csvFileInputStream, eip, IMPORT_AGENCIES_BACKUP_CSV, DataCategory.REPORT, String.valueOf(eip) + CSV);
                }
                this.backupService.saveCollectionAndSequence(eip, AGENCIES_BACKUP_EVENT, FunctionalAdminCollections.AGENCIES, eip.toString());
                InputStream reportStream = this.generateReportOK(agenciesImportResult);
                this.backupService.saveFile(reportStream, eip, AGENCIES_REPORT_EVENT, DataCategory.REPORT, String.valueOf(eip) + ".json");
                this.manager.logFinishSuccess(eip, filename, StatusCode.OK);
            }
            catch (AgencyImportDeletionException e2) {
                LOGGER.error(MESSAGE_ERROR, (Throwable)e2);
                InputStream errorStream = this.generateErrorReport(agenciesImportResult);
                this.backupService.saveFile(errorStream, eip, AGENCIES_REPORT_EVENT, DataCategory.REPORT, String.valueOf(eip) + ".json");
                errorStream.close();
                VitamError<AgenciesModel> vitamError = this.generateVitamBadRequestError(eip, e2.getMessage(), AGENCIES_IMPORT_DELETION_ERROR);
                if (file != null && !file.delete()) {
                    LOGGER.warn("Failed to delete file");
                }
                return vitamError;
            }
            catch (InvalidCreateOperationException | IOException e3) {
                VitamError<AgenciesModel> vitamError;
                block29: {
                    VitamError<AgenciesModel> vitamError2;
                    try {
                        LOGGER.error(MESSAGE_ERROR, e3);
                        vitamError = this.generateVitamFatalError(eip, MESSAGE_ERROR + e3.getMessage());
                        if (file == null || file.delete()) break block29;
                    }
                    catch (ReferentialImportInProgressException e4) {
                        LOGGER.error(MESSAGE_ERROR, (Throwable)e4);
                        vitamError2 = this.generateVitamBadRequestError(eip, AGENCIES_PROCESS_IMPORT_ALREADY_EXIST, AGENCIES_IMPORT_CONCURRENCE_ERROR);
                        return vitamError2;
                    }
                    catch (InvalidFileException | InvalidFileFormatParseException e5) {
                        LOGGER.error(MESSAGE_ERROR, e5);
                        vitamError2 = this.generateVitamBadRequestError(eip, MESSAGE_ERROR + e5.getMessage(), null);
                        return vitamError2;
                    }
                    catch (VitamException | IllegalPathException | IOException e6) {
                        LOGGER.error(MESSAGE_ERROR, e6);
                        vitamError2 = this.generateVitamFatalError(eip, MESSAGE_ERROR + e6.getMessage());
                        return vitamError2;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    LOGGER.warn("Failed to delete file");
                }
                return vitamError;
            }
        }
        finally {
            if (file != null && !file.delete()) {
                LOGGER.warn("Failed to delete file");
            }
        }
        return new RequestResponseOK().setHttpCode(Response.Status.CREATED.getStatusCode());
    }

    private String buildErrorMessageWithAgenciesList(String mainErrorMessage, Set<AgenciesModel> agencies) {
        ObjectNode errorMessageNode = JsonHandler.createObjectNode();
        String listAgencies = agencies.stream().map(AgenciesModel::getIdentifier).collect(Collectors.joining(","));
        errorMessageNode.put("Message ", mainErrorMessage);
        errorMessageNode.put("Agencies ", listAgencies);
        return errorMessageNode.toString();
    }

    private boolean isUsedByAccessContract(AgenciesModel agency) throws InvalidCreateOperationException, ReferentialException, InvalidParseOperationException {
        Select select = new Select();
        select.setQuery((Query)QueryHelper.in((String)"OriginatingAgencies", (String[])new String[]{agency.getIdentifier()}));
        ObjectNode queryDsl = select.getFinalSelect();
        RequestResponseOK<AccessContractModel> result = this.accessContractService.findContracts((JsonNode)queryDsl);
        return !result.getResults().isEmpty();
    }

    private boolean isUsedInMetadata(AgenciesModel agency) throws InvalidCreateOperationException, ReferentialException {
        Select select = new Select();
        select.setQuery((Query)QueryHelper.and().add(new Query[]{QueryHelper.eq((String)"OriginatingAgency", (String)agency.getIdentifier())}));
        ObjectNode queryDsl = select.getFinalSelect();
        DbRequestResult result = this.mongoAccess.findDocuments((JsonNode)queryDsl, FunctionalAdminCollections.ACCESSION_REGISTER_SUMMARY);
        RequestResponseOK response = result.getRequestResponseOK((JsonNode)queryDsl, AccessionRegisterDetail.class);
        return !response.getResults().isEmpty();
    }

    private VitamError<AgenciesModel> generateVitamBadRequestError(GUID eip, String err, String subEvenType) throws VitamException {
        this.manager.logError(eip, err, subEvenType);
        return new VitamError(VitamCode.AGENCIES_VALIDATION_ERROR.getItem()).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode()).setCode(VitamCode.AGENCIES_VALIDATION_ERROR.getItem()).setDescription(err).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
    }

    private VitamError<AgenciesModel> generateVitamFatalError(GUID eip, String err) throws VitamException {
        this.manager.logEventFatal(eip, AGENCIES_IMPORT_EVENT);
        return new VitamError(VitamCode.AGENCIES_VALIDATION_ERROR.getItem()).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).setCode(VitamCode.GLOBAL_INTERNAL_SERVER_ERROR.getItem()).setDescription(err).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
    }

    private void insertDocuments(Set<AgenciesModel> agenciesToInsert, Integer sequence) throws InvalidParseOperationException, ReferentialException, SchemaValidationException, DocumentAlreadyExistsException {
        ArrayNode agenciesNodeToPersist = JsonHandler.createArrayNode();
        for (AgenciesModel agency : agenciesToInsert) {
            JsonNode hashTenant;
            String currentDate = LocalDateUtil.nowFormatted();
            agency.setId(GUIDFactory.newGUID().getId());
            agency.setTenant(ParameterHelper.getTenantParameter());
            agency.setCreationDate(currentDate);
            agency.setUpdateDate(currentDate);
            ObjectNode agencyNode = (ObjectNode)JsonHandler.toJsonNode((Object)agency);
            JsonNode jsonNode = agencyNode.remove(VitamFieldsHelper.id());
            if (jsonNode != null) {
                agencyNode.set(UND_ID, jsonNode);
            }
            if ((hashTenant = agencyNode.remove(VitamFieldsHelper.tenant())) != null) {
                agencyNode.set(UND_TENANT, hashTenant);
            }
            agenciesNodeToPersist.add((JsonNode)agencyNode);
        }
        if (!agenciesToInsert.isEmpty()) {
            this.mongoAccess.insertDocuments(agenciesNodeToPersist, FunctionalAdminCollections.AGENCIES, sequence).close();
        }
    }

    private void commitAgencies(Set<AgenciesModel> agenciesToInsert, Set<AgenciesModel> agenciesToUpdate, Set<AgenciesModel> agenciesToDelete) throws InvalidParseOperationException, ReferentialException, InvalidCreateOperationException, SchemaValidationException, BadRequestException, DocumentAlreadyExistsException {
        Integer sequence = this.vitamCounterService.getNextSequence(ParameterHelper.getTenantParameter(), SequenceType.AGENCIES_SEQUENCE);
        for (AgenciesModel agency : agenciesToUpdate) {
            this.updateAgency(agency, sequence);
        }
        for (AgenciesModel agenciesModel : agenciesToDelete) {
            this.deleteAgency(agenciesModel);
        }
        if (!agenciesToInsert.isEmpty()) {
            this.insertDocuments(agenciesToInsert, sequence);
        }
    }

    private void updateAgency(AgenciesModel fileAgenciesModel, Integer sequence) throws InvalidCreateOperationException, ReferentialException, InvalidParseOperationException, SchemaValidationException, BadRequestException {
        UpdateParserSingle updateParser = new UpdateParserSingle(new VarNameAdapter());
        Update updateFileAgencies = new Update();
        fileAgenciesModel.setUpdateDate(LocalDateUtil.nowFormatted());
        List<Action> actions = this.prepareUpdateActions(fileAgenciesModel);
        updateFileAgencies.setQuery((Query)QueryHelper.eq((String)"Identifier", (String)fileAgenciesModel.getIdentifier()));
        updateFileAgencies.addActions(actions.toArray(new Action[0]));
        updateParser.parse((JsonNode)updateFileAgencies.getFinalUpdate());
        this.mongoAccess.updateData((JsonNode)updateParser.getRequest().getFinalUpdate(), FunctionalAdminCollections.AGENCIES, sequence);
    }

    private List<Action> prepareUpdateActions(AgenciesModel fileAgenciesModel) throws InvalidCreateOperationException {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add((Action)new SetAction("Name", fileAgenciesModel.getName()));
        actions.add((Action)new SetAction("Description", fileAgenciesModel.getDescription()));
        actions.add((Action)new SetAction("UpdateDate", fileAgenciesModel.getUpdateDate()));
        if (StringUtils.isNotEmpty((CharSequence)fileAgenciesModel.getEntityType())) {
            actions.add((Action)new SetAction("EntityType", fileAgenciesModel.getEntityType()));
        } else {
            actions.add((Action)new UnsetAction(new String[]{"EntityType"}));
        }
        if (CollectionUtils.isNotEmpty((Collection)fileAgenciesModel.getNameEntryParallel())) {
            actions.add((Action)new SetAction("NameEntryParallel", fileAgenciesModel.getNameEntryParallel()));
        } else {
            actions.add((Action)new UnsetAction(new String[]{"NameEntryParallel"}));
        }
        if (CollectionUtils.isNotEmpty((Collection)fileAgenciesModel.getAuthorizedForm())) {
            actions.add((Action)new SetAction("AuthorizedForm", fileAgenciesModel.getAuthorizedForm()));
        } else {
            actions.add((Action)new UnsetAction(new String[]{"AuthorizedForm"}));
        }
        if (CollectionUtils.isNotEmpty((Collection)fileAgenciesModel.getAlternativeForm())) {
            actions.add((Action)new SetAction("AlternativeForm", fileAgenciesModel.getAlternativeForm()));
        } else {
            actions.add((Action)new UnsetAction(new String[]{"AlternativeForm"}));
        }
        if (StringUtils.isNotEmpty((CharSequence)fileAgenciesModel.getEntityId())) {
            actions.add((Action)new SetAction("EntityId", fileAgenciesModel.getEntityId()));
        } else {
            actions.add((Action)new UnsetAction(new String[]{"EntityId"}));
        }
        if (StringUtils.isNotEmpty((CharSequence)fileAgenciesModel.getFromDate())) {
            actions.add((Action)new SetAction("FromDate", fileAgenciesModel.getFromDate()));
        } else {
            actions.add((Action)new UnsetAction(new String[]{"FromDate"}));
        }
        if (StringUtils.isNotEmpty((CharSequence)fileAgenciesModel.getToDate())) {
            actions.add((Action)new SetAction("ToDate", fileAgenciesModel.getToDate()));
        } else {
            actions.add((Action)new UnsetAction(new String[]{"ToDate"}));
        }
        if (CollectionUtils.isNotEmpty((Collection)fileAgenciesModel.getFunctions())) {
            actions.add((Action)new SetAction("Functions", fileAgenciesModel.getFunctions()));
        } else {
            actions.add((Action)new UnsetAction(new String[]{"Functions"}));
        }
        if (StringUtils.isNotEmpty((CharSequence)fileAgenciesModel.getBiogHist())) {
            actions.add((Action)new SetAction("BiogHist", fileAgenciesModel.getBiogHist()));
        } else {
            actions.add((Action)new UnsetAction(new String[]{"BiogHist"}));
        }
        if (CollectionUtils.isNotEmpty((Collection)fileAgenciesModel.getPlaces())) {
            actions.add((Action)new SetAction("Places", fileAgenciesModel.getPlaces()));
        } else {
            actions.add((Action)new UnsetAction(new String[]{"Places"}));
        }
        if (CollectionUtils.isNotEmpty((Collection)fileAgenciesModel.getLegalStatuses())) {
            actions.add((Action)new SetAction("LegalStatuses", fileAgenciesModel.getLegalStatuses()));
        } else {
            actions.add((Action)new UnsetAction(new String[]{"LegalStatuses"}));
        }
        if (CollectionUtils.isNotEmpty((Collection)fileAgenciesModel.getMandates())) {
            actions.add((Action)new SetAction("Mandates", fileAgenciesModel.getMandates()));
        } else {
            actions.add((Action)new UnsetAction(new String[]{"Mandates"}));
        }
        if (StringUtils.isNotEmpty((CharSequence)fileAgenciesModel.getStructureOrGenealogy())) {
            actions.add((Action)new SetAction("StructureOrGenealogy", fileAgenciesModel.getStructureOrGenealogy()));
        } else {
            actions.add((Action)new UnsetAction(new String[]{"StructureOrGenealogy"}));
        }
        if (StringUtils.isNotEmpty((CharSequence)fileAgenciesModel.getGeneralContext())) {
            actions.add((Action)new SetAction("GeneralContext", fileAgenciesModel.getGeneralContext()));
        } else {
            actions.add((Action)new UnsetAction(new String[]{"GeneralContext"}));
        }
        if (StringUtils.isNotEmpty((CharSequence)fileAgenciesModel.getMaintenanceStatus())) {
            actions.add((Action)new SetAction("MaintenanceStatus", fileAgenciesModel.getMaintenanceStatus()));
        } else {
            actions.add((Action)new UnsetAction(new String[]{"MaintenanceStatus"}));
        }
        if (StringUtils.isNotEmpty((CharSequence)fileAgenciesModel.getLocalStatus())) {
            actions.add((Action)new SetAction("LocalStatus", fileAgenciesModel.getLocalStatus()));
        } else {
            actions.add((Action)new UnsetAction(new String[]{"LocalStatus"}));
        }
        if (CollectionUtils.isNotEmpty((Collection)fileAgenciesModel.getSources())) {
            actions.add((Action)new SetAction("Sources", fileAgenciesModel.getSources()));
        } else {
            actions.add((Action)new UnsetAction(new String[]{"Sources"}));
        }
        if (StringUtils.isNotEmpty((CharSequence)fileAgenciesModel.getEventDescription())) {
            actions.add((Action)new SetAction("EventDescription", fileAgenciesModel.getEventDescription()));
        } else {
            actions.add((Action)new UnsetAction(new String[]{"EventDescription"}));
        }
        return actions;
    }

    private void deleteAgency(AgenciesModel fileAgenciesModel) throws BadRequestException, ReferentialException {
        Delete delete = new Delete();
        try {
            delete.setQuery((Query)QueryHelper.eq((String)"Identifier", (String)fileAgenciesModel.getIdentifier()));
            DbRequestResult result = this.mongoAccess.deleteDocument((JsonNode)delete.getFinalDelete(), FunctionalAdminCollections.AGENCIES);
            result.close();
        }
        catch (InvalidCreateOperationException | SchemaValidationException e) {
            throw new BadRequestException(e);
        }
    }

    public DbRequestResult findAgencies(JsonNode queryDsl) throws ReferentialException {
        return this.mongoAccess.findDocuments(queryDsl, FunctionalAdminCollections.AGENCIES);
    }

    private InputStream generateReportOK(AgenciesImportResult agenciesImportResult) {
        AgenciesReport reportFinal = this.generateReport(agenciesImportResult);
        return new ByteArrayInputStream(JsonHandler.unprettyPrint((Object)reportFinal).getBytes(StandardCharsets.UTF_8));
    }

    private AgenciesReport generateReport(AgenciesImportResult agenciesImportResult) {
        AgenciesReport report = new AgenciesReport();
        HashMap<String, String> guidmasterNode = new HashMap<String, String>();
        String operationId = VitamThreadUtils.getVitamSession().getRequestId();
        guidmasterNode.put("evType", AGENCIES_IMPORT_EVENT);
        guidmasterNode.put("evDateTime", LocalDateUtil.nowFormatted());
        guidmasterNode.put("evId", operationId);
        report.setOperation(guidmasterNode);
        report.setAgenciesToImport(agenciesImportResult.getAgenciesToImport().stream().map(AgenciesModel::getIdentifier).collect(Collectors.toList()));
        report.setInsertedAgencies(agenciesImportResult.getInsertedAgencies().stream().map(AgenciesModel::getIdentifier).collect(Collectors.toList()));
        report.setUpdatedAgencies(agenciesImportResult.getUpdatedAgencies().stream().map(AgenciesModel::getIdentifier).collect(Collectors.toList()));
        report.setUsedAgenciesByContracts(agenciesImportResult.getUsedAgenciesContract().stream().map(AgenciesModel::getIdentifier).collect(Collectors.toList()));
        report.setUsedAgenciesByAu(agenciesImportResult.getUsedAgenciesAU().stream().map(AgenciesModel::getIdentifier).collect(Collectors.toList()));
        report.setAgenciesToDelete(agenciesImportResult.getDeletedAgencies().stream().map(AgenciesModel::getIdentifier).collect(Collectors.toList()));
        return report;
    }

    public InputStream generateErrorReport(AgenciesImportResult agenciesImportResult) {
        AgenciesReport reportFinal = this.generateReport(agenciesImportResult);
        ArrayNode messagesArrayNode = JsonHandler.createArrayNode();
        HashMap<String, Object> errors = new HashMap<String, Object>();
        for (Integer line : agenciesImportResult.getErrorsMap().keySet()) {
            List<ErrorReportAgencies> errorsReports = agenciesImportResult.getErrorsMap().get(line);
            for (ErrorReportAgencies error : errorsReports) {
                ObjectNode errorNode = JsonHandler.createObjectNode();
                errorNode.put("Code", error.getCode().name() + ".KO");
                errorNode.put("Message", VitamErrorMessages.getFromKey((String)error.getCode().name()));
                switch (error.getCode()) {
                    case STP_IMPORT_AGENCIES_MISSING_INFORMATIONS: {
                        errorNode.put("Information additionnelle", error.getMissingInformations());
                        break;
                    }
                    case STP_IMPORT_AGENCIES_ID_DUPLICATION: {
                        errorNode.put("Information additionnelle", error.getFileAgenciesModel().getId());
                        break;
                    }
                }
                messagesArrayNode.add((JsonNode)errorNode);
            }
            errors.put(String.format("line %s", line), messagesArrayNode);
        }
        reportFinal.setErrors(errors);
        return new ByteArrayInputStream(JsonHandler.unprettyPrint((Object)reportFinal).getBytes(StandardCharsets.UTF_8));
    }

    private void checkConcurrentImportOperation(GUID eip) throws VitamException {
        if (this.manager.isImportOperationInProgress(eip)) {
            throw new ReferentialImportInProgressException(AGENCIES_PROCESS_IMPORT_ALREADY_EXIST);
        }
        this.manager.logEventSuccess(eip, AGENCIES_IMPORT_ANOTHER_IMPORT_IN_PROGRESS);
    }
}

