/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools;

import fr.gouv.vitam.common.guid.GUIDFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class SipTool {
    public static final String REPLACEMENT_STRING = "_REPLACE_ME_";
    public static final String REPLACEMENT_NAME = "_REPLACE_ME_NAME_";
    public static final String REPLACEMENT_VALUE = "_REPLACE_ME_VALUE_";

    public static Path copyAndModifyManifestInZip(Path zipPath, String text1, String replacement1, String text2, String replacement2) throws IOException {
        File tempFile = Files.createTempFile(GUIDFactory.newGUID().toString(), ".zip", new FileAttribute[0]).toFile();
        try (FileInputStream zipFile = new FileInputStream(zipPath.toFile());){
            Files.copy(zipFile, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        try (FileSystem fs = FileSystems.newFileSystem(tempFile.toPath(), (ClassLoader)null);){
            Path source = fs.getPath("manifest.xml", new String[0]);
            Path temp = fs.getPath("manifest_tmp.xml", new String[0]);
            if (Files.exists(temp, new LinkOption[0])) {
                throw new IOException("error");
            }
            Files.move(source, temp, new CopyOption[0]);
            SipTool.streamCopy(temp, source, text1, replacement1, text2, replacement2);
            Files.delete(temp);
        }
        return tempFile.getAbsoluteFile().toPath();
    }

    static void streamCopy(Path src, Path dst, String text1, String replacement1, String text2, String replacement2) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(src, new OpenOption[0])));
             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(dst, new OpenOption[0])));){
            String line;
            while ((line = br.readLine()) != null) {
                line = line.replace(text1, replacement1);
                if (null != text2) {
                    line = line.replace(text2, replacement2);
                }
                bw.write(line);
                bw.newLine();
            }
        }
    }
}

