/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.step;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.access.external.client.OperationStatusClient;
import fr.gouv.vitam.access.external.client.VitamPoolingClient;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.ProbativeValueRequest;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.functionaltest.cucumber.step.CommonStep;
import fr.gouv.vitam.functionaltest.cucumber.step.World;
import io.cucumber.java.en.Then;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Java6Assertions;

public class ProbativeStep
extends CommonStep {
    private String lastProbativeValueOperationId;

    public ProbativeStep(World world) {
        super(world);
    }

    @Then(value="^Je lance un r\u00e9lev\u00e9 de valeur probante avec l'usage suivant (.*)")
    public void probativeValue(String usage) throws Exception {
        this.probativeValue(usage, false);
    }

    @Then(value="^Je lance un r\u00e9lev\u00e9 de valeur probante \u00e9tendu aux \u00e9l\u00e9ments de preuves de signature \u00e9lectronique avec l'usage suivant (.*)")
    public void probativeValueIncludeDetachedSigningInformation(String usage) throws Exception {
        this.probativeValue(usage, true);
    }

    private void probativeValue(String usage, boolean includeDetachedSigningInformation) throws Exception {
        JsonNode query = JsonHandler.getFromString((String)this.world.getQuery());
        ProbativeValueRequest probativeValueRequest = new ProbativeValueRequest(query, usage, "1", includeDetachedSigningInformation);
        RequestResponse response = this.world.getAdminClient().exportProbativeValue(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId()), probativeValueRequest);
        Assertions.assertThat((boolean)response.isOk()).isTrue();
        String operationId = response.getHeaderString("X-Request-Id");
        this.world.setOperationId(operationId);
        VitamPoolingClient vitamPoolingClient = new VitamPoolingClient((OperationStatusClient)this.world.getAdminClient());
        boolean processTimeout = vitamPoolingClient.wait(this.world.getTenantId(), operationId, ProcessState.COMPLETED, 100, 1000L, TimeUnit.MILLISECONDS);
        if (!processTimeout) {
            Java6Assertions.fail((String)"Probative value processing not finished. Timeout exceeded.");
        }
        ((AbstractStringAssert)Assertions.assertThat((String)operationId).as(String.format("%s not found for request", "X-Request-Id"), new Object[0])).isNotNull();
        this.lastProbativeValueOperationId = operationId;
    }

    @Then(value="^le p\u00e9rim\u00e8tre effectif du rapport de valeur probante contient les unit\u00e9s ayant pour titres$")
    public void probativeValueIncludeDetachedSigningInformation(List<String> expectedUnitTitles) throws Exception {
        JsonNode reportContent;
        VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId());
        try (Response response = this.world.getAdminClient().downloadRulesReport(vitamContext, this.lastProbativeValueOperationId);
             InputStream is = (InputStream)response.readEntity(InputStream.class);){
            reportContent = JsonHandler.getFromInputStream((InputStream)is);
        }
        ArrayList<String> unitIds = new ArrayList<String>();
        for (JsonNode reportEntry : reportContent.get("reportEntries")) {
            for (JsonNode unitIdNode : reportEntry.get("unitIds")) {
                unitIds.add(unitIdNode.asText());
            }
        }
        SelectMultiQuery selectMultiQuery = new SelectMultiQuery();
        selectMultiQuery.addRoots((String[])unitIds.toArray(String[]::new));
        selectMultiQuery.addUsedProjection(new String[]{"Title"});
        RequestResponseOK selectedUnits = (RequestResponseOK)this.world.getAccessClient().selectUnits(vitamContext, (JsonNode)selectMultiQuery.getFinalSelect());
        List foundUnitTitles = selectedUnits.getResults().stream().map(unit -> unit.get("Title").asText()).collect(Collectors.toList());
        Assertions.assertThat(foundUnitTitles).hasSameSizeAs(unitIds);
        Assertions.assertThat(foundUnitTitles).containsExactlyInAnyOrderElementsOf(expectedUnitTitles);
    }
}

